@php
    use Illuminate\Support\Facades\DB;

@endphp
@extends('admin.main')
@section('content')
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>


    <style>
        body {
            margin: 30px;
            background-color: aliceblue;
        }

        .step {
            display: none;
        }

        .step.active {
            display: block;
        }

        h1 {
            text-align: center;
        }

        .height::after,
        .weight::after {
            margin-left: -75px;
            font-size: 14px;
            font-weight: bold;
            color: #1c3866;
        }

        .width-100 {
            width: 100%;
        }

        #comment {
            background-color: transparent;
            padding: 30px;
            border-radius: 10px;
            /* box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2); */
            border: 1px solid rgba(0, 0, 0, .15);
            width: 100%;
        }

        input,
        select {
            height: 50px !important;
            border-radius: 8px !important;
            border: 1px solid rgba(0, 0, 0, .15) !important;
            background-color: transparent !important;
        }

        .error-border {
            border: 2px solid #dc3545 !important;
        }
    </style>



    <div class="container">
        <h1 class="mb-4 mt-5">Child Health Checkup Survey</h1>
        <p id="timer">Time: 0 seconds</p>
        <form id="multiStepForm">
            <!-- Step-one -->
            <input type="hidden" name="_token" value="{{ csrf_token() }}">
            <div class="step active mb-5" id="step1">
                <h3>Bio Data</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Name">Name</label>
                            <input type="text" class="form-control" id="name" name="name"
                                @if (isset($_GET['name'])) value="{{ $_GET['name'] }}"

                            @else
                            value="{{ old('name') }}" @endif
                                required>
                        </div>
                    </div>


                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="GName">Guardian Name</label>
                            <input type="text" class="form-control" id="guardianname" name="guardianname"
                                @if (isset($_GET['guardianname'])) value="{{ $_GET['guardianname'] }}"

                            @else
                            value="{{ old('guardianname') }}" @endif
                                required>



                            <span class="error-message"></span>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select class="form-control" id="gender" name="gender" required>
                                <option value="">Select</option>
                                {{-- <option value="male">Male</option>
                                <option value="female">Female</option>
                                <option value="other">Other</option> --}}

                                <option value="male"
                                    {{ (isset($_GET['gender']) && $_GET['gender'] == 'male') || old('gender') == 'male' ? 'selected' : '' }}>
                                    Male
                                </option>

                                <option value="female"
                                    {{ (isset($_GET['gender']) && $_GET['gender'] == 'female') || old('gender') == 'female' ? 'selected' : '' }}>
                                    Female
                                </option>

                                <option value="other"
                                    {{ (isset($_GET['gender']) && $_GET['gender'] == 'other') || old('gender') == 'other' ? 'selected' : '' }}>
                                    Other
                                </option>


                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">

                        <div class="form-group">
                            <label for="dob">School</label>
                            <select class="form-control" id="school" name="school" required>
                                <option value="">Select</option>
                                @if (!empty($school))
                                    @foreach ($school as $item)
                                        <option @if (isset($_GET['school']) && $_GET['school'] == $item->id) selected @endif
                                            value="{{ $item->id }}">{{ $item->school_name }}</option>
                                    @endforeach
                                @endif

                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="gender">City</label>
                            <select class="form-control" id="city" name="city" required>
                                <option value="">Select</option>
                                @if (!empty($city))
                                    @foreach ($city as $item)
                                        <option @if (isset($_GET['city']) && $_GET['city'] == $item->id) selected @endif
                                            value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                @endif

                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">

                        <div class="form-group">
                            <label for="age">Area</label>
                            <select class="form-control" id="area" name="area" required>
                                <option value="">Select</option>

                                @if (!empty($area))
                                    @foreach ($area as $item)
                                        <option @if (isset($_GET['area']) && $_GET['area'] == $item->id) selected @endif
                                            value="{{ $item->id }}">{{ $item->name }}</option>
                                    @endforeach
                                @endif


                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="dob">Date Of Birth</label>
                            <input type="date" class="form-control" id="dob" name="dob"
                                @if (isset($_GET['dob'])) value="{{ $_GET['dob'] }}"

                            @else
                            value="{{ old('dob') }}" @endif
                                required>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="age">Age</label>
                            <input type="number" class="form-control" id="age" name="age" readonly required
                                @if (isset($_GET['age'])) value="{{ $_GET['age'] }}"

                               @else
                               value="{{ old('age') }}" @endif>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="contact">Emergency Contact Number</label>
                            <input type="text" class="form-control" id="Emergency_Contact_Number"
                                name="Emergency_Contact_Number"
                                @if (isset($_GET['emergency_contact_number'])) value="{{ $_GET['emergency_contact_number'] }}" @endif
                                required>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="contact">GR Number</label>
                            <input type="text" class="form-control" id="Gr_Number" name="Gr_Number"
                                @if (isset($_GET['grno'])) value="{{ $_GET['grno'] }}"

                            @else
                            value="{{ old('Gr_Number') }}" @endif
                                required>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Medical_condition">Any Known Medical Condition</label>
                            <input type="text" class="form-control" id="Any_Known_Medical_Condition"
                                name="Any_Known_Medical_Condition" required>
                        </div>
                    </div>



                    <div class="form-group col-md-6">
                        <label for="address">Address</label>
                        <input type="text" class="form-control" id="address" name="Address" required>
                    </div>
                    <div class="form-group col-md-12">
                        <div class="form-group">
                            <label for="contact">Blood Group</label>




                            <?php
                            $selectedBloodGroup = isset($_GET['blood_group']) ? $_GET['blood_group'] : ''; // Default to an empty string if 'blood_group' is not set
                            ?>

                            <select class="form-control" id="blood_group" name="Blood_group" required>
                                <option value="">Select</option>
                                <option value="A+" {{ $selectedBloodGroup == 'A+' ? 'selected' : '' }}>A+</option>
                                <option value="A-" {{ $selectedBloodGroup == 'A-' ? 'selected' : '' }}>A-</option>
                                <option value="B+" {{ $selectedBloodGroup == 'B+' ? 'selected' : '' }}>B+</option>
                                <option value="B-" {{ $selectedBloodGroup == 'B-' ? 'selected' : '' }}>B-</option>
                                <option value="O+" {{ $selectedBloodGroup == 'O+' ? 'selected' : '' }}>O+</option>
                                <option value="O-" {{ $selectedBloodGroup == 'O-' ? 'selected' : '' }}>O-</option>
                                <option value="AB+" {{ $selectedBloodGroup == 'AB+' ? 'selected' : '' }}>AB+</option>
                                <option value="AB-" {{ $selectedBloodGroup == 'AB-' ? 'selected' : '' }}>AB-</option>
                                <option value="Unknown" {{ $selectedBloodGroup == 'Unknown' ? 'selected' : '' }}>Unknown
                                </option>
                            </select>


                        </div>
                    </div>
                    <div class="form-roup col-md-12">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "bio_data_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>

            <!-- Second Step -->

            <div class="step" id="step2">
                <h3>Vitals/BMI</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group height">
                            <div class="group-form">
                                <label for="height" class="width-100">Question No.1: Height :cm(s)<input type="number"
                                        class="form-control" id="height" name="Question_No_1_Height"
                                        placeholder="Height in cm example 170" required> </label>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-6">

                        <div class="form-group weight">
                            <div class="group-form">
                                <label for="weight" class="width-100">Question No.2: Weight :kg(s)
                                    <input type="number" class="form-control" id="weight"
                                        name="Question_No_2_Weight"placeholder="Weight in kg example 65" required> </label>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="bmi">Question No.3: BMI (Red field means abnomality )</label>
                            <span id="bmishow"></span>
                            <input type="number" class="form-control" id="bmi" name="Question_No_3_BMI"
                                placeholder="auto calculate" readonly required>

                        </div>
                        <input type="hidden" class="form-control" id="bmiresult" name="bmiresult" readonly
                            @if (isset($_GET['bmiresult'])) value="{{ $_GET['bmiresult'] }}" readonly

                    @else
                    value="{{ old('bmiresult') }}" @endif>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="temp">Question No.4: Body Temperature</label>
                            <div class="row">
                                <div class="form-group col-md-8 pr-2">
                                    <input type="number" class="form-control" id="Question_No_4_Body_Temperature"
                                        name="Question_No_4_Body_Temperature" required>
                                </div>
                                <div class="form-group col-md-4 pl-0">
                                    {{-- <select class="form-control" id="bodytempunit" name="Bodytempunit" required>
                                        <option value="">Select Unit</option>
                                        <option value="f">f (fahrenheit)</option>
                                        
                                    </select> --}}
                                    <input type="hidden" id="bodytempunit" name="Bodytempunit" value="f" />
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="blood">Question No.5: Blood Pressure (Systolic) (Red field means abnomality
                                )</label> <span id="Blood_Pressure_Systolic"></span>
                            <input type="number" class="form-control" id="Question_No_5_Blood_Pressure_Systolic"
                                name="Question_No_5_Blood_Pressure_Systolic" required>
                        </div>

                        <input type="hidden" class="form-control" id="systolicresult" name="systolicresult" readonly
                            @if (isset($_GET['systolicresult'])) value="{{ $_GET['systolicresult'] }}"

                    @else
                    value="{{ old('systolicresult') }}" @endif>

                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="blood">Question No.6: Blood Pressure (Diastolic) (Red field means abnomality
                                ) </label> <span id="Blood_Pressure_Diastolic"></span>
                            <input type="number" class="form-control" id="Question_No_6_Blood_Pressure_Diastolic"
                                name="Question_No_6_Blood_Pressure_Diastolic" required>
                        </div>
                        <input type="hidden" class="form-control" id="diastolicresult" name="diastolicresult" readonly
                            @if (isset($_GET['diastolicresult'])) value="{{ $_GET['diastolicresult'] }}"

                    @else
                    value="{{ old('diastolicresult') }}" @endif>
                    </div>


                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="pulse">Question No.7: Pulse (Red field means abnomality )</label>
                            <input type="text" class="form-control" id="Question_No_7_Pulse"
                                name="Question_No_7_Pulse" required>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "vitals_bmi_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>
            <!-- ADD  Step -->


            <!-- Third Step -->
            <div class="step" id="step3">
                <h3>General Apperance</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="field2">Question No.8: Normal Posture/Gait</label><br>
                            <select class="form-control" id="Question_No_8_Normal_Posture_Gait"
                                name="Question_No_8_Normal_Posture/Gait" required>
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Mentalstatus">Question No.9: Mental Status</label><br>
                            <select class="form-control" id="Question_No_9_Mental_Status"
                                name="Question_No_9_Mental_Status" required>
                                <option value="">Select</option>
                                <option value="Alert">Alert</option>
                                <option value="Lethargic">Lethargic</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="jaundice">Question No.10: Look For jaundice</label><br>
                            <select class="form-control" id="Question_No_10_Look_For_jaundice"
                                name="Question_No_10_Look_For_jaundice" required>
                                <option value="">Select</option>
                                <option value="yes">Yes</option>
                                <option value="no">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="anemia">Question No.11: Look For anemia</label><br>
                            <select class="form-control" id="Question_No_11_Look_For_anemia"
                                name="Question_No_11_Look_For_anemia" required " >
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="clubbing">Question No.12: Look For Clubbing</label><br>
                                                <select class="form-control" id="Question_No_12_Look_For_Clubbing"
                                                    name="Question_No_12_Look_For_Clubbing" required  >
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="cyanosis">Question No.13: Look for Cyanosis</label><br>
                                                <select class="form-control" id="Question_No_13_Look_for_Cyanosis"
                                                    name="Question_No_13_Look_for_Cyanosis" required ">
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="skin">Question No.14: Skin</label><br>
                            <select class="form-control" id="Question_No_14_Skin" name="Question_No_14_Skin" required>
                                <option value="">Select</option>
                                <option value="Rash">Rash</option>
                                <option value="Allergy">Allergy</option>
                                <option value="Lesion">Lesion</option>
                                <option value="Bruises">Bruises</option>
                                <option value="Normal">Normal</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="breath">Question No.15: Breath</label><br>
                            <select class="form-control" id="Question_No_15_Breath" name="Question_No_15_Breath" required ">
                                                    <option value="">Select</option>
                                                    <option value="Bad Breath">Bad Breath</option>
                                                    <option value="Normal">Normal</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "general_apperance_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>
                                </div>
                                <!-- Fourth Step -->
                                {{-- add step end --}}
                                <div class="step" id="step4">
                                    <h3>Inspect Hygiene </h3>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="Nails">Question No.16: Nails</label><br>
                                                <select class="form-control" id="Question_No_16_Nails" name="Question_No_16_Nails" required
                                                    ">
                                <option value="">Select</option>
                                <option value="Clean">Clean</option>
                                <option value="Dirty">Dirty</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Uniform or shoes">Question No.17: Uniform or shoes</label><br>
                            <select class="form-control" id="Question_No_17_Uniform_or_shoes"
                                name="Question_No_17_Uniform_or_shoes" required ">
                                                    <option value="">Select</option>
                                                    <option value="Tidy">Tidy</option>
                                                    <option value="Untidy">Untidy</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="Lice/nits">Question No.18: Lice/nits</label><br>
                                                <select class="form-control" id="Question_No_18_Lice_nits" name="Question_No_18_Lice/nits"
                                                    required  ">
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="field2">Question No.19: Discuss hygiene routines and practices.</label><br>
                            <select class="form-control" id="Question_No_19_Discuss_hygiene_routines_and_practices"
                                name="Question_No_19_Discuss_hygiene_routines_and_practices" required>
                                <option value="">Select</option>
                                <option value="well-aware">well-aware</option>
                                <option value="not-aware">not aware</option>
                                <option value="has-been-counseled">has been counseled</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "inspect_hygiene_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>

            <!--  Step Five -->
            <div class="step" id="step5">
                <h3>Head and Neck examination</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="hair_and_scalp">Question No:20 Hair and Scalp</label><br>
                            <select class="form-control" id="Question_No_20_Hair_and_Scalp"
                                name="Question_No_20_Hair_and_Scalp" required ">
                                                    <option value="">Select</option>
                                                    <option value="Straight">Straight</option>
                                                    <option value="Wavy">Wavy</option>
                                                    <option value="Curly">Curly</option>
                                                    <option value="Color-faded">Color faded</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="field2">Question No.21: Any Hair Problem</label><br>
                                                <select class="form-control" id="Question_No_21_Any_Hair_Problem"
                                                    name="Question_No_21_Any_Hair_Problem" required>
                                                    <option value="">Select</option>
                                                    <option value="Kinky">Kinky</option>
                                                    <option value="Brittle">Brittle</option>
                                                    <option value="Dry">Dry</option>
                                                    <option value="Normal">Normal</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="field2">Question No.22: Scalp</label><br>
                                                <select class="form-control" id="Question_No_22_Sclap" name="Question_No_22_Sclap" required>
                                                    <option value="">Select</option>
                                                    <option value="Scaly">Scaly</option>
                                                    <option value="Dry">Dry</option>
                                                    <option value="Moist">Moist</option>
                                                    <option value="Normal">Normal</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="field2">Question No.23: Hair distribution</label><br>
                                                <select class="form-control" id="Question_No_23_Hair_distribution"
                                                    name="Question_No_23_Hair_distribution" required>
                                                    <option value="">Select</option>
                                                    <option value="Even">Even</option>
                                                    <option value="Patchy">Patchy</option>
                                                    <option value="Receding">Receding</option>
                                                    <option value="Receding_Hair_Line">Receding Hair Line</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "head_and_neck_examination_comment" placeholder = "Comment here" id = "comment" cols="50"
                                                    required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>

                                </div>
                                <!--  Step six -->
                                <div class="step" id="step6">
                                    <h3>Eye:</h3>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="normal_ocular_alignment">Question No.24: Visual acuity using Snellen’s
                                                    chart</label><br>
                                                <input type="text" id="Question_No_24_Visual_acuity_using_Snellen’s_chart"
                                                    name="Question_No_24_Visual_acuity_using_Snellen’s_chart" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="nystagmus">Question No.25: Normal ocular alignment</label><br>
                                                <select class="form-control" id="Question_No_25_Normal_ocular_alignment"
                                                    name="Question_No_25_Normal_ocular_alignment" required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="normal_eye_inspection">Question No.26: Normal eye inspection</label><br>
                                                <select class="form-control" id="Question_No_26_Normal_eye_inspection"
                                                    name="Question_No_26_Normal_eye_inspection" required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </div>
                                        </div>



                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="normal_color_vision">Question No.27: Normal Color vision</label><br>
                                                <select class="form-control" id="Question_No_27_Normal_Color_vision"
                                                    name="Question_No_27_Normal_Color_vision" required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="Nystagmus">Question No.28: Nystagmus</label><br>
                                                <select class="form-control" id="Question_No_28_Nystagmus" name="Question_No_28_Nystagmus"
                                                    required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "eye_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>
                                </div>
                                <!--  Step Seven -->
                                <div class="step" id="step7">
                                    <h3>Ears:</h3>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="Right_ear">Question No.29: Normal ears shape and position</label><br>
                                                <select class="form-control" id="Question_No_29_Normal_ears_shape_and_position"
                                                    name="Question_No_29_Normal_ears_shape_and_position"required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="Right_ear">Question No.30: Ear examination</label><br>
                                                <select class="form-control" id="Question_No_30_Ear_examination"
                                                    name="Question_No_30_Ear_examination" required>
                                                    <option value="">Select</option>
                                                    <option value="Ear wax">Ear wax</option>
                                                    <option value="Canal infection">Canal infection</option>
                                                    <option value="None">None</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="field8">Question No.31: Conclusion of hearing test with Rinner and
                                                    Weber</label><br>
                                                <select class="form-control"
                                                    id="Question_No_31_Conclusion_of_hearing_test_with_Rinner_and_Weber"
                                                    name="Question_No_31_Conclusion_of_hearing_test_with_Rinner_and_Weber" required>
                                                    <option value="">Select</option>
                                                    <option value="Normal">Normal</option>
                                                    <option value="right_ear_conductive_hearing_loss">right ear conductive hearing loss
                                                    </option>
                                                    <option value="left_ear_conductive_hearing_loss">left ear conductive hearing loss </option>
                                                    <option value="right_ear_sensorineural_hearing_loss">right sensorineural hearing loss
                                                    </option>
                                                    <option value="left_ear_sensorineural_hearing_loss">left sensorineural hearing loss
                                                    </option>
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "ears_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>
                                </div>

                                <!--  Step nine -->
                                <div class="step" id="step9">
                                    <h3>Nose</h3>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="nose">Question No.32:External nasal examinaton</label><br>
                                                <select class="form-control" id="Question_No_32_External_inasal_examinaton"
                                                    name="Question_No_32_External_nasal_examinaton" required>
                                                    <option value="">Select</option>
                                                    <option value="Deformities">Deformities</option>
                                                    <option value="Swelling">Swelling </option>
                                                    <option value="Redness">Redness </option>
                                                    <option value="Lesions">Lesions </option>
                                                    <option value="Nasal Discharge">Nasal Discharge </option>
                                                    <option value="Crusting">Crusting</option>
                                                    <option value="Normal">Normal </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <div class="form-group">
                                                <label for="field9">Question No.33:perform a nasal patency test [which involves gently
                                                    closing
                                                    one nostril at a time to assess the patient's ability to breathe through each
                                                    nostril]</label><br>
                                                <select class="form-control"
                                                    id="Question_No_33_perform_a_nasal_patency_test_which_involves_gently_closing_one_nostril_at_a_time_to_assess_the_patient_s_ability_to_breathe_through_each_nostril"
                                                    name="Question_No_33_perform_a_nasal_patency_test_which_involves_gently_closing_one_nostril_at_a_time_to_assess_the_patient's_ability_to_breathe_through_each_nostril"
                                                    required>
                                                    <option value="">Select</option>
                                                    <option value="Obstruction">Obstruction </option>
                                                    <option value="DNS">DNS </option>
                                                    <option value="Normal">Normal </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "nose_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>
                                </div>
                                <!--  Step Ten -->
                                <div class="step" id="step10">
                                    <h3>Oral</h3>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="assess_gingiva">Question No.34: Assess gingiva</label><br>
                                                <select class="form-control" id="Question_No_34_Assess_gingiva"
                                                    name="Question_No_34_Assess_gingiva" required  ">
                                <option value="">Select</option>
                                <option value="Infection">Infection</option>
                                <option value="Bleed">Bleed </option>
                                <option value="Normal">Normal </option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="are_there_dental_caries">Question No.35: Are there dental caries</label><br>
                            <select class="form-control" id="Question_No_35_Are_there_dental_caries"
                                name="Question_No_35_Are_there_dental_caries" required ">
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "oral_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>
                                </div>
                                <!--  Step Eleven -->
                                <div class="step" id="step10">
                                    <h3>Throat</h3>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="Examine tonsils">Question No.36: Examine tonsils</label>
                                                <select class="form-control" id="Question_No_36_Examine_tonsils"
                                                    name="Question_No_36_Examine_tonsils" required>
                                                    <option value="">Select</option>
                                                    <option value="Normal">Normal</option>
                                                    <option value="Tonsillitis">Tonsillitis</option>
                                                    <option value="Tonsillectomy done">Tonsillectomy done</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="normal_speech_development">Question No.37: Normal Speech development</label><br>
                                                <select class="form-control" id="Question_No_37_Normal_Speech_development"
                                                    name="Question_No_37_Normal_Speech_development" required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="any_neck_swelling">Question No.38:Any Neck swelling </label><br>
                                                <select class="form-control" id="any_neck_swelling" name="Question_No_38_Any_Neck_swelling"
                                                    required  ">
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No </option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Examine lymph_node">Question No.39: Examine lymph node</label><br>
                            <select class="form-control" id="lymph_node" name="Question_No_39_Examine_lymph_node"
                                required>
                                <option value="">Select</option>
                                <option value="normal">normal</option>
                                <option value="abnormal">abnormal</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group lymph_node_specify d-none">
                            <label for="lymph_node_specify">Specify lymph node</label><br>
                            <input type="text" name="Specify_lymph_node" class="form-control" id="Specify_lymph_node"
                                placeholder="Please specify lymph node"><br>
                        </div>
                    </div>

                    <div class="form-group col-md-6 any_neck_swelling_specify d-none">
                        <div class="form-group">
                            <label for="any_neck_swelling">Specify Any Neck swelling</label><br>
                            <input type="text" name="Specify_Any_Neck_swelling" class="form-control"
                                id="Specify_Any_Neck_swelling" placeholder="please specify Neck swelling"><br>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <div class="form-group">
                                <label for="comment">Comment/Findings</label><br>
                                <textarea name = "throat_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                            </div>
                        </div>
                    </div>
                </div>


                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>
            <!--  Step Twelve -->
            <div class="step" id="step12">
                <h3>Chest</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="any_visible_chest_deformity">Question No.40 Any visible chest deformity</label><br>
                            <select class="form-control" id="Question_No_40_Any_visible_chest_deformity"
                                name="Question_No_40_Any_visible_chest_deformity" required ">
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No </option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="lung_auscultation">Question No.41 Lung Auscultation</label><br>
                                                <select class="form-control" id="Question_No_41_Lung_Auscultation"
                                                    name="Question_No_41_Lung_Auscultation" required >
                                                    <option value="">Select</option>
                                                    <option value="Ronchi">Ronchi </option>
                                                    <option value="Wheezing">Wheezing </option>
                                                    <option value="Crackles">Crackles</option>
                                                    <option value="Vesicular_Breathing">Vesicular_Breathing</option>
                                                    <option value="Vesicular Diminished Breath Sound(specify)">Vesicular Diminished Breath
                                                        Sound(specify)</option>

                                                </select>
                                            </div>
                                        </div>



                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="Cardiac Auscultation">Question No.42: Cardiac Auscultation</label><br>
                                                <select class="form-control" id="Question_No_42_Cardiac_Auscultation"
                                                    name="Question_No_42_Cardiac_Auscultation" required  >
                                                    <option value="">Select</option>
                                                    <option value="Normal S1/S2">Normal S1/S2 </option>
                                                    <option value="Murmur">Murmur</option>
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "chest_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>
                                </div>
                                <!--  Step Thirteen -->
                                <div class="step" id="step12">
                                    <h3>Abdomen</h3>
                                    <div class="form-group">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for="did you observe any distension, scars, or masses on the child's abdomen">
                                                    Question No.43: Did you observe any distension, scars, or masses on the child's
                                                    abdomen?</label><br>
                                                <select class="form-control" id="distention_scar_mass"
                                                    name="Question_No_43_Did_you_observe_any_distension,_scars,_or_masses_on_the_child's_abdomen?"
                                                    required>
                                                    <option value="">Select</option>
                                                    <option value="Distention">Distention</option>
                                                    <option value="Scar">Scar</option>
                                                    <option value="Mass">Mass</option>
                                                    <option value="Normal">Normal</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label for=" Any history of abdominal Pain">Question No.44 Any history of abdominal
                                                    Pain</label><br>
                                                <select class="form-control" id="any_history_of_abdominal_pain"
                                                    name="Question_No_44_Any_history_of_abdominal_Pain" required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No </option>
                                                </select>
                                            </div>



                                            <div class="form-group col-md-6 any_history_of_abdominal_pain_specify d-none">
                                                <div class="form-group">
                                                    <label for="any_neck_swelling">Specify Abdominal Pain</label><br>
                                                    <input type="text" name="any_history_of_abdominal_pain_specify" class="form-control"
                                                        id="any_history_of_abdominal_pain_specify"
                                                        placeholder="Please specify any history of abdominal Pain">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="comment">Comment/Findings</label><br>
                                                <textarea name = "abdomen_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="button" class="btn btn-primary prevStep">Previous</button>
                                    <button type="button" class="btn btn-primary nextStep">Next</button>
                                </div>
                                <!--  Step Fourteen -->
                                <div class="step" id="step13">
                                    <h3>Musculoskeletal</h3>
                                    <div class="form-row">
                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="field6">Question No.45: Did you observe any limitations in the child's range of
                                                    joint motion during your examination?*</label><br>
                                                <select class="form-control" id="limitations_range_motion"
                                                    name="Question_No_45_Did_you_observe_any_limitations_in_the_child's_range_of_joint_motion_during_your_examination?"
                                                    required>
                                                    <option value="">Select</option>
                                                    <option value="Yes">Yes</option>
                                                    <option value="No">No </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="form-group col-md-6">
                                            <div class="form-group limitations_range_motion_specify d-none">
                                                <label for="any_neck_swelling">Specify limitations in the child's range of joint motion during
                                                    your examination?*</label><br>
                                                <input type="text"
                                                    name="Specify_limitations_in_the_child's_range_of_joint_motion_during_your_examination?"
                                                    class="form-control" id="limitations_range_motion_specify"
                                                    placeholder="Please specify limitations in the child's range of joint motion during your examination?*"><br>
                                            </div>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <div class="form-group">
                                                <label for="field6">Question No.46: Spinal curvature assessment (tick positive finding)
                                                </label><br>
                                                <select class="form-control" id="spinal_curvature_assessment"
                                                    name="Question_No_46_Spinal_curvature_assessment_(tick_positive_finding)" required
                                                    ">
                                <option value="">Select</option>
                                <option value="Uneven shoulders">Uneven Shoulders</option>
                                <option value="Shoulder Blade">Shoulder Blade</option>
                                <option value="Uneven waist">Uneven Waist</option>
                                <option value="Hips">Hips</option>
                                <option value="Normal">Normal</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="side-to-side curvature in the spine resembling ">Question No.47: side-to-side
                                curvature in the spine resembling </label><br>
                            <select class="form-control" id="curvature_spine_resembling"
                                name="Question_No_47_side-to-side_curvature_in_the_spine_resembling" required>
                                <option value="">Select</option>
                                <option value="S_Shape">S Shape</option>
                                <option value="C_Shape">C Shape</option>
                                <option value="Normal">Normal</option>
                            </select>
                        </div>
                    </div>


                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Adams forward bend test">Question No.48: Adams forward bend test</label><br><br>
                            <select class="form-control" id="adams_forward_bend_test"
                                name="Question_No_48_Adams_forward_bend_test" required>
                                <option value="">Select</option>
                                <option value="Positive">Positive</option>
                                <option value="Negative">Negative</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="field6">Question No.49: Any foot or toe abnormalities</label><br>
                            <select class="form-control" id="foot_or_toe_abnormalities"
                                name="Question_No_49_Any_foot_or_toe_abnormalities" required>
                                <option value="">Select</option>
                                <option value="Normal">Normal</option>
                                <option value="Flat Feet">Flat Feet</option>
                                <option value="Varus">Varus</option>
                                <option value="Valgus">Valgus</option>
                                <option value="High Arch">High Arch</option>
                                <option value="Hammer Toe">Hammer Toe</option>
                                <option value="Bunion">Bunion</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "musculoskeletal_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>
            <!--  Step Fifteen -->
            <div class="step" id="step14">
                <h3>Vaccination:</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="field13">Question No.50: Have EPI immunization card? </label><br>
                            <select class="form-control" id="immunization_card"
                                name="Question_No_50_Have_EPI_immunization_card?" required>
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No </option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group immunization_card_specify d-none">
                            <label for="Reason">Reason of not being vaccinated</label><br>
                            <input type="text" name="Reason_of_not_being_vaccinated" class="form-control"
                                id="Reason_of_not_being_vaccinated">
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="field13">Question No.50: Mark all the vaccinations that are completed</label><br>
                            <input type="checkbox" value="BCG_1_dose" id="BCG_1_dose" name="BCG_1_dose">
                            <label for="deformities ">BCG_1_dose</label><br>
                            <input type="checkbox" value="OPV_4_dose" id="OPV_4_dose" name="OPV_4_dose">
                            <label for="swelling ">OPV_4_dose </label><br>
                            <input type="checkbox" value="Pentavalent vaccine (DTP+Hep B + Hib) 3 dose" id="Pentavalent"
                                name="Pentavalent_vaccine_(DTP+Hep B + Hib)_3_dose">
                            <label for="redness">Pentavalent_vaccine_(DTP+Hep B + Hib)_3_dose </label><br>
                            <input type="checkbox" value="Rota 2 doses" id="rota" name="rota">
                            <label for="of nasal discharge ">Rota_2_doses</label><br>
                            <input type="checkbox" value="Measles 2 dose" id="measles" name="measles">
                            <label for="lesions ">Measles 2 dose</label><br>
                            <input type="checkbox" value="Never had any vaccination" id="never_had_any_vaccination"
                                name="never_had_any_vaccination">
                            <label for="of nasal discharge ">Never had any vaccination</label>
                        </div>
                    </div>

                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "vaccination_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>

                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>
            <!--  Step Sixteen -->
            <div class="step" id="step15">
                <h3>Lead exposure</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <label for="field51">
                            Question.51:Do you Frequently put things in his/her mouth such as toys, jewelry, or
                            keys?</label>
                        <select class="form-control"
                            name="Question_51_Do_you_Frequently_put_things_in_his/her_mouth_such_as_toys,_jewelry,_or_keys?"
                            id="Question_51_Do_you_Frequently_put_things_in_his_her_mouth_such_as_toys_jewelry_or_keys"
                            required>
                            <option value="">Select</option>
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="Does your child eat non-food items(pica)">Question.52: Does your child eat non-food
                            <br> items(pica)?</label><br>
                        <select class="form-control" id="eat_non-food_items"
                            name="Question_52_Does_your_child_eat_non_food_items_(pica)?" required>
                            <option value="">Select</option>
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="field6">Question.53: Do you frequently come in contact with an adult whose job
                            involves exposure to lead?</label>
                        <select class="form-control"
                            id="Question_53_Do_you_frequently_come_in_contact_with_an_adult_whose_job_involves_exposure_to_lead"
                            name="Question_53_Do_you_frequently_come_in_contact_with_an_adult_whose_job_involves_exposure_to_lead?"
                            required>
                            <option value="">Select</option>
                            <option value="House painting">House painting</option>
                            <option value="Plumbing">Plumbing</option>
                            <option value="Renovation">Renovation</option>
                            <option value="Construction">Construction</option>
                            <option value="Auto repair">Auto repair</option>
                            <option value="Welding">Welding</option>
                            <option value="Electronics repair">Electronics repair</option>
                            <option value="Jewelry or pottery making">Jewelry or pottery making</option>
                            <option value="None of the above">None of the above</option>

                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <label for="field6">Question.54: Do you frequently come in contact with an adult whose hobby
                            involves exposure to lead?</label>
                        <select class="form-control" id="hobby_involves"
                            name="Question_54_Do_you_frequently_come_in_contact_with_an_adult_whose_hobby_involves_exposure_to_lead?"
                            required>
                            <option value="">Select</option>
                            <option value="Making stained glass">Making stained glass</option>
                            <option value="Pottery">Pottery</option>
                            <option value="Firearm making">Firearm making</option>
                            <option value="Collecting lead">Collecting lead</option>
                            <option value="None of the above">None of the above</option>

                        </select>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "lead_exposure_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>
            {{-- step 18 --}}
            <div class="step" id="step15">
                <h3>Miscellaneous</h3>
                <div class="form-row">
                    <div class="form-group col-md-6 ">
                        <label for="do_you_have_any_Allergies">Question No.55:Do you have any Allergies</label><br>
                        <select class="form-control" id="do_you_have_any_Allergies"
                            name="Question_No_55_Do_you_have_any_Allergies" required>
                            <option value="">Select</option>
                            <option value="Yes">Yes</option>
                            <option value="No">No </option>
                        </select>

                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group do_you_have_any_Allergies_specify d-none">
                            <label for="Specify Allergies">Specify Allergies</label><br>
                            <input type="text" name="Do_you_have_any_allergies_specify" class="form-control"
                                id="do_you_have_any_allergies_specify" placeholder="Please specify allergies"><br>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Menarche age">Question No.56:Girls above 8 years old ask age of
                                Menarche:</label><br><br>
                            <input type="text" name="Question_No_56_Girls_above_8_years_old_ask:"
                                class="form-control"id="menarche_age" placeholder="Write Age"><br>
                        </div>
                    </div>

                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Menarche age">Question No.57:Inquire about urinary frequency, urgency, and any pain
                                or discomfort during urination.</label><br>
                            <select class="form-control" id="discomfort_during_urination"
                                name="Question_No_57_Inquire_about_urinary_frequency,_urgency,_and_any_pain_or_discomfort_during_urination"
                                required>
                                <option value="">Select</option>
                                <option value="No urinary issues reported">No urinary issues reported</option>
                                <option value="Urinary frequency">Urinary frequency</option>
                                <option value="Urinary urgency">Urinary urgency</option>
                                <option value="Pain or discomfort during urination">Pain or discomfort during urination
                                </option>
                                <option value="Nocturnal enuresis">Nocturnal enuresis</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="menstrual abnormality">Question No.58:Any menstrual abnormality.</label><br>
                            <select class="form-control" id="any_menstrual_abnormality"
                                name="QuestionNo_58_Any_menstrual_abnormality" required>
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group any_menstrual_abnormality_specify d-none">
                            <label for="any_menstrual_abnormality">Specify Menstrual Abnormality</label><br>
                            <input type="text" name="Any_menstrual_abnormality_specify" class="form-control"
                                id="any_menstrual_abnormality_specify" placeholder="Please Menstrual Abnormality"><br>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "miscellaneous_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
            </div>
            {{-- step 19 --}}
            <div class="step last-step mb-5" id="step17">
                <h3>Psychological</h3>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Thought Patterns">Question No.59: <b>Thought Patterns:</b>How often do you
                                experience negative or intrusive thoughts?</label><br>
                            <select class="form-control"
                                id="Question_No_59_How_often_do_you_experience_negative_or_intrusive_thoughts"
                                name="Question_No_59_How_often_do_you_experience_negative_or_intrusive_thoughts?"
                                required>
                                <option value="">Select</option>
                                <option value="Rarely">Rarely</option>
                                <option value="Occasionally">Occasionally</option>
                                <option value="Frequently">Frequently</option>
                                <option value="Almost always">Almost always</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Self-Esteem">Question No.60: <b>Self-Esteem:</b> How would you rate your overall
                                self-esteem and self-confidence?</label><br>
                            <select class="form-control"
                                id="Question_No_60_How_would_you_rate_your_overall_self_esteem_and_self_confidence"
                                name="Question_No_60_How_would_you_rate_your_overall_self_esteem_and_self_confidence?"
                                required>
                                <option value="">Select</option>
                                <option value="Very high">Very high</option>
                                <option value="Moderately high">Moderately high</option>
                                <option value="Moderately low">Moderately low</option>
                                <option value="Very low">Very low</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Energy Levels">Question No.61: <b>Energy Levels:</b> How would you describe your
                                energy levels throughout a typical day?</label><br>
                            <select class="form-control"
                                id="Question_No_61_How_would_you_describe_your_energy_levels_throughout_a_typical_day"
                                name="Question_No_61_How_would_you_describe_your_energy_levels_throughout_a_typical_day?"
                                required>
                                <option value="">Select</option>
                                <option value="High and consistent">High and consistent</option>
                                <option value="Moderate and stable">Moderate and stable</option>
                                <option value="Fluctuating">Fluctuating</option>
                                <option value="Low and inconsistent">Low and inconsistent</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Coping Strategies">Question No.62: <b>Coping Strategies:</b> When faced with
                                challenges, what are your typical coping mechanisms?</label><br>
                            <select class="form-control"
                                id="Question_No_62_When_faced_with_challenges_what_are_your_typical_coping_mechanisms"
                                name="Question_No_62_When_faced_with_challenges,_what_are_your_typical_coping_mechanisms?"
                                required>
                                <option value="">Select</option>
                                <option value="Healthy coping strategies">Healthy coping strategies</option>
                                <option value="Neutral coping strategies">Neutral coping strategies</option>
                                <option value="Unhealthy coping strategies">Unhealthy coping strategies</option>
                                <option value="No clear coping strategies">No clear coping strategies</option>
                            </select>
                        </div>
                    </div>
                </div>
                {{-- new --}}
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Sleep Quality">Question No.63: <b>Sleep Quality:</b> How would you rate the
                                quality of your sleep on average?</label><br>
                            <select class="form-control"
                                id="Question_No_63_How_would_you_rate_the_quality_of_your_sleep_on_average"
                                name="Question_No_63_How_would_you_rate_the_quality_of_your_sleep_on_average?" required>
                                <option value="">Select</option>
                                <option value="Excellent">Excellent</option>
                                <option value="Good">Good</option>
                                <option value="Fair">Fair</option>
                                <option value="Poor">Poor</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Stress Levels">Question No.64: <b>Stress Levels:</b> How often have you felt
                                overwhelmed or stressed in the last few weeks?</label><br>
                            <select class="form-control"
                                id="Question_No_64_How_often_have_you_felt_overwhelmed_or_stressed_in_the_last_few_weeks"
                                name="Question_No_64_How_often_have_you_felt_overwhelmed_or_stressed_in_the_last_few_weeks?"
                                required>
                                <option value="">Select</option>
                                <option value="Rarely">Rarely</option>
                                <option value="Occasionally">Occasionally</option>
                                <option value="Frequently">Frequently</option>
                                <option value="Almost always">Almost always</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Mood Assessment">Question No.65: <b>Mood Assessment:</b> How would you describe
                                your overall mood during the day?</label><br>
                            <select class="form-control"
                                id="Question_No_65_How_would_you_describe_your_overall_mood_during_the_day"
                                name="Question_No_65_How_would_you_describe_your_overall_mood_during_the_day?" required>
                                <option value="">Select</option>
                                <option value="Very positive">Very positive</option>
                                <option value="Mostly positive">Mostly positive</option>
                                <option value="Mixed">Mixed</option>
                                <option value="Mostly negative">Mostly negative</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Family Relationships">Question No.66: <b>Family Relationships:</b> How would you
                                describe the quality of your relationships with family members?</label><br>
                            <select class="form-control"
                                id="Question_No_66_How_would_you_describe_the_quality_of_your_relationships_with_family_members"
                                name="Question_No_66_How_would_you_describe_the_quality_of_your_relationships_with_family_members?"
                                required>
                                <option value="">Select</option>
                                <option value="Very positive">Very positive</option>
                                <option value="Mostly positive">Mostly positive</option>
                                <option value="Mixed">Mixed</option>
                                <option value="Mostly negative">Mostly negative</option>
                            </select>
                        </div>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Sleep Quality">Question No.67: <b>Problem-Solving Skills:</b> How well does you
                                handle challenges and solve problems?</label><br>
                            <select class="form-control"
                                id="Question_No_67_How_well_does_you_handle_challenges_and_solve_problems"
                                name="Question_No_67_How_well_does_you_handle_challenges_and_solve_problems?" required>
                                <option value="">Select</option>
                                <option value="Very well">Very well</option>
                                <option value="Moderately well">Moderately well</option>
                                <option value="Somewhat poorly">Somewhat poorly</option>
                                <option value="Very poorly">Very poorly</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Sleep Patterns">Question No.68: <b>Sleep Patterns:</b> How many hours of sleep
                                does you typically get on a school night?</label><br>
                            <select class="form-control"
                                id="Question_No_68_How_many_hours_of_sleep_does_you_typically_get_on_a_school_night"
                                name="Question_No_68_How_many_hours_of_sleep_does_you_typically_get_on_a_school_night?"
                                required>
                                <option value="">Select</option>
                                <option value="9 or more hours">9 or more hours</option>
                                <option value="7-8 hours">7-8 hours</option>
                                <option value="6 hours or less">6 hours or less</option>
                                <option value="Variable, inconsistent">Variable, inconsistent</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Sleep Quality">Question No.69: <b> followup required?:</b></label><br>
                            <select class="form-control" id="followup_required" name="followup_required" required>
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group reffered d-none">
                            <label for="Sleep Patterns">Question No.70: <b>Referred By:</b></label><br>
                            <select class="form-control" id="referred_by" name="referred_by">
                                <option value="">Select</option>
                                <option value="Teacher">Teacher</option>
                                <option value="School Docotor">School Docotor</option>
                                <option value="Both">Both</option>
                                <option value="None">None</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="comment">Comment/Findings</label><br>
                            <textarea name = "psychological_comment" placeholder = "Comment here" id = "comment" cols="50" required></textarea>
                        </div>
                    </div>
                </div>
                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" class="btn btn-primary nextStep">Next</button>
                {{-- <button type="button" id="submit" name="submit" class="btn btn-success">Submit</button> --}}
            </div>
            {{-- step 20 --}}
            <div class="step last-step mb-5" id="step18">
                <h3>Nutritionist</h3>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Question_No_60_How_would_you_describe_your_lifestyle">Question No.60: How would
                                you describe your lifestyle?</label><br>
                            <select class="form-control" id="Question_No_60_How_would_you_describe_your_lifestyle"
                                name="Question_No_60_How_would_you_describe_your_lifestyle" required>
                                <option value="">Select</option>
                                <option value="Sedentary">Sedentary</option>
                                <option value="Moderately">Moderately</option>
                                {{-- <option value="Low Active">Low Active</option> --}}
                                <option value="Active">Active</option>
                                {{-- <option value="Very Active (Athletic)">Very Active (Athletic)</option> --}}
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6 bmi61">
                        <div class="form-group">
                            <label for="bmi61">Question No.61: BMI</label><br>
                            <input type="text" name="bmi61" class="form-control" id="bmi61"
                                placeholder="BMI" readonly>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group col-md-6 muac" id="muac-container">
                        <div class="form-group">
                            <label for="muac">Question No.62: MUAC</label><br>
                            <input type="text" name="muac" class="form-control" id="muac"
                                placeholder="MUAC">

                        </div>
                    </div>
                    <div class="form-group col-md-6 Daily_Protien_requirement">
                        <div class="form-group">
                            <label for="Daily_Protien_requirement">Question No.63: Daily Protien requirement</label><br>
                            <input type="text" name="Daily_Protien_requirement" class="form-control"
                                id="Daily_Protien_requirement" placeholder="Daily Protien requirement">
                        </div>
                    </div>
                </div>
                {{-- new --}}
                <div class="form-row">
                    <div class="form-group col-md-6 Daily_energy_requirement">
                        <div class="form-group">
                            <label for="Daily_energy_requirement">Question No.64: Daily Energy <br>
                                requirement</label><br>

                            <input type="text" name="Daily_energy_requirement" class="form-control"
                                id="Daily_energy_requirement" placeholder="Daily Energy requirement">


                            <select class="form-control" id="Daily_energy_requirement1" style="display: none;">
                                @php
                                    $energychart = DB::table('energyChart')->get();
                                    if (!$energychart->isEmpty()) {
                                        foreach ($energychart as $value) {
                                            $energychartID = htmlspecialchars($value->id, ENT_QUOTES, 'UTF-8');
                                            $sedentary = htmlspecialchars($value->Sedentarylal, ENT_QUOTES, 'UTF-8');
                                            $Moderate = htmlspecialchars($value->active, ENT_QUOTES, 'UTF-8');
                                            $activela = htmlspecialchars($value->Activela, ENT_QUOTES, 'UTF-8');
                                            $AGE = htmlspecialchars($value->AGE, ENT_QUOTES, 'UTF-8');
                                            $Gander = htmlspecialchars($value->Gander, ENT_QUOTES, 'UTF-8');

                                            echo "<option value='{$activela}' age='{$AGE}' gender='{$Gander}' sedentary='{$sedentary}' Moderate='{$Moderate}' activela='{$activela}' > {$activela} {$Gander}  </option>";
                                        }
                                    }
                                @endphp
                            </select>

                        </div>
                    </div>
                    
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day">Question
                                No.65: How many glasses of water/liquids do you consume in a day?</label><br>
                            <select class="form-control"
                                id="Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day"
                                name="Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day" required>
                                <option value="">Select</option>
                                <option value="6-8">6-8</option>
                                <option value="4-6">4-6</option>
                                <option value="< 4">
                                    < 4</option>
                            </select>

                        </div>
                    </div>

                </div>

                <div class="form-row">
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label
                                for="Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to">Question
                                No.66: Does the child have any history of substances abuse or addiction to</label><br>
                            <select class="form-control"
                                id="Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to"
                                name="Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to"
                                required>
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6 d-none" id="addictionContainer">
                        <div class="form-group">
                            <label for="addiction">Please Specify</label><br>
                            <select class="form-control mt-4" id="addiction" name="addiction" required>
                                <option value="">Select</option>
                                <option value="Smoking">Smoking</option>
                                <option value="Alcohol">Alcohol</option>
                                <option value="Pan / Gutka / Chalia consumption">Pan / Gutka / Chalia consumption</option>
                                <option value="Substance / Drugs abuse">Substance / Drugs abuse</option>
                                <option value="gutka">gutka</option>
                                <option value="chalia">chalia</option>
                                <option value="substance">substance </option>
                                <option value="drug abuse">drug abuse </option>
                                <option value="other">other</option>
                            </select>
                        </div>
                    </div>


                    <div class="form-group col-md-6 d-none" id="otherAddictionContainer">
                        <div class="form-group">
                            <label for="other_addiction">Please Describe</label><br>
                            <textarea class="form-control" name="other_addiction" id="other_addiction" class="w-100" rows="3"></textarea>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="food_allergies">Question No.67: Does the child suffer from any food intolerances/
                                food allergies?</label><br>
                            <select class="form-control" id="food_allergies" name="food_allergies" required>
                                <option value="">Select</option>
                                <option value="Yes">Yes</option>
                                <option value="No">No</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group col-md-6 d-none" id="food_allergiesContainer">
                        <div class="form-group">
                            <label for="other_addiction">Specify the foods</label><br>
                            {{-- <textarea class="form-control" name="other_food_allergies" id="other_food_allergies" class="w-100" rows="3"></textarea> --}}


                            <select name="other_food_allergies" id="other_food_allergies" class="form-control">
                                <option value="Milk" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Milk' ? 'selected' : ''; ?>>Milk</option>
                                <option value="Eggs" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Eggs' ? 'selected' : ''; ?>>Eggs</option>
                                <option value="Peanuts" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Peanuts' ? 'selected' : ''; ?>>Peanuts</option>
                                <option value="Tree nuts (e.g., almonds, walnuts, cashews)" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Tree nuts (e.g., almonds, walnuts, cashews)' ? 'selected' : ''; ?>>Tree nuts
                                    (e.g., almonds, walnuts, cashews)</option>
                                <option value="Almonds" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Almonds' ? 'selected' : ''; ?>>Almonds</option>
                                <option value="Walnuts" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Walnuts' ? 'selected' : ''; ?>>Walnuts</option>
                                <option value="Cashews" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Cashews' ? 'selected' : ''; ?>>Cashews</option>
                                <option value="Fish (e.g., salmon, tuna)" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Fish (e.g., salmon, tuna)' ? 'selected' : ''; ?>>Fish (e.g., salmon, tuna)
                                </option>
                                <option value="Salmon" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Salmon' ? 'selected' : ''; ?>>Salmon</option>
                                <option value="Tuna" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Tuna' ? 'selected' : ''; ?>>Tuna</option>
                                <option value="Shellfish (e.g., shrimp, crab)" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Shellfish (e.g., shrimp, crab)' ? 'selected' : ''; ?>>Shellfish (e.g.,
                                    shrimp, crab)</option>
                                <option value="Shrimp" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Shrimp' ? 'selected' : ''; ?>>Shrimp</option>
                                <option value="Crab" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Crab' ? 'selected' : ''; ?>>Crab</option>
                                <option value="Soy" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Soy' ? 'selected' : ''; ?>>Soy</option>
                                <option value="Wheat" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Wheat' ? 'selected' : ''; ?>>Wheat</option>
                            </select>


                        </div>
                    </div>
                    {{-- <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="lifestyle">Question No.68: How would you describe your <br> lifestyle?</label><br>
                            <select class="form-control" id="lifestyle" name="lifestyle" required>
                                <option value="">Select</option>
                                <option value="Sedentary">Sedentary</option>
                                <option value="Low Active">Low Active</option>
                                <option value="Active">Active</option>
                                <option value="Very Active (Athletic)">Very Active (Athletic)</option>
                            </select>
                        </div>
                    </div> --}}
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="meals">Question No.69: How many meals (breakfast / lunch / dinner) do you
                                consume in a day?</label><br>
                            <select class="form-control" id="meals" name="meals" required>
                                <option value="">Select</option>
                                <option value="1">1</option>
                                <option value="2-3">2-3</option>
                                <option value=">3"> >3</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="food_items">Question No.70: How many packed items/foods (chips / biscuits sodas)
                                do you consume in average in a day?</label><br>
                            <select class="form-control" id="food_items" name="food_items" required>
                                <option value="">Select</option>
                                <option value="0-1">0-1</option>
                                <option value="1-2">1-2</option>
                                <option value="3 or more">3 or more</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-md-6">
                        <div class="form-group">
                            <label for="fast_food">Question No.71: How frequently do you consume fast food on dineout on
                                average in a week?</label><br>
                            <select class="form-control" id="fast_food" name="fast_food" required>
                                <option value="">Select</option>
                                {{-- <option value="0-1">0-1</option> --}}
                                <option value="< 1">
                                    < 1</option>
                                <option value="1-2">1-2</option>
                                <option value="3 or more">3 or more</option>
                            </select>
                        </div>
                    </div>

                </div>






                <button type="button" class="btn btn-primary prevStep">Previous</button>
                <button type="button" id="submit" name="submit" class="btn btn-success">Submit</button>
            </div>
        </form>

    </div>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    
    <script>
        $(document).ready(function() {



            /* food_allergies */
            $('#food_allergies').change(function() {


                var selectedValue = $(this).val();
                console.log("selectedValue " + selectedValue);

                var other_food_allergies = document.getElementById("other_food_allergies");

                if (selectedValue === 'Yes') {


                    other_food_allergies.style.setProperty('background-color', 'red', 'important');
                    other_food_allergies.style.setProperty('color', 'white', 'important');

                } else {

                    other_food_allergies.style.removeProperty('background-color');
                    other_food_allergies.style.removeProperty('color');

                }
            });


            /* Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day*/
            $('#Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day').change(function() {
                var selectedValue = $(this).val();
                console.log("Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day " +
                    selectedValue);

                if (selectedValue === '< 4') {

                    // this.style.removeProperty('background-color');
                    // this.style.removeProperty('color');

                    this.style.setProperty('background-color', 'red', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else if (selectedValue === '6-8') {

                    this.style.setProperty('background-color', 'green', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else if (selectedValue === '4-6') {

                    this.style.setProperty('background-color', 'yellow', 'important');
                    this.style.setProperty('color', 'black', 'important');

                } else {

                    // this.style.setProperty('background-color', 'red', 'important');
                    // this.style.setProperty('color', 'white', 'important');

                    this.style.removeProperty('background-color');
                    this.style.removeProperty('color');
                }
            });



            /* Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to */
            $('#Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to').change(
                function() {


                    var selectedValue = $(this).val();

                    var addiction = document.getElementById("addiction");
                    const otherAddictionContainer = document.getElementById('otherAddictionContainer');

                    if (selectedValue === 'Yes') {


                        addiction.style.setProperty('background-color', 'red', 'important');
                        addiction.style.setProperty('color', 'white', 'important');
                        addictionContainer.classList.remove('d-none');

                        otherAddictionContainer.classList.remove('d-none');

                    } else {

                        addiction.style.removeProperty('background-color');
                        addiction.style.removeProperty('color');
                        otherAddictionContainer.classList.add('d-none');
                        addictionContainer.classList.add('d-none');


                    }
                });



            /* Function to capitalize the first letter of a string */
            function capitalizeFirstLetter(string) {
                return string.charAt(0).toUpperCase() + string.slice(1);
            }

            /* Question_No_60_How_would_you_describe_your_lifestyle */
            $('#Question_No_60_How_would_you_describe_your_lifestyle').change(
                function() {


                    var age = $("#age").val();
                    var gender = $("#gender").val();

                    // Capitalize the first letter
                    var gender = capitalizeFirstLetter(gender);

                    // Log the capitalized value to the console
                    console.log('Capitalized Gender:', gender);

                    var selectedValue = $(this).val();

                    var Question_No_60_How_would_you_describe_your_lifestyle = document.getElementById(
                        "Question_No_60_How_would_you_describe_your_lifestyle");

                    if (selectedValue === 'Sedentary') {


                        Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty(
                            'background-color', 'red', 'important');
                        Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty('color', 'white',
                            'important');



                        // Filter the options based on the specified attributes
                        var matchingOption = $('#Daily_energy_requirement1 option').filter(function() {
                            return $(this).attr('age') === age &&
                                $(this).attr('gender') === gender;
                        });

                        console.log('matchingOption.length', matchingOption.length);

                        // Check if any matching option was found and log the value of the moderate attribute
                        if (matchingOption.length) {
                            var sedentary = matchingOption.attr('sedentary');
                            console.log('sedentary:', sedentary);

                            $("#Daily_energy_requirement").val(sedentary).attr('readonly', true);

                        } else {
                            console.log('No matching option found');

                            $("#Daily_energy_requirement").val('').attr('readonly', false);

                        }



                    } else if (selectedValue === 'Moderately') {


                        Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty(
                            'background-color', 'yellow', 'important');
                        Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty('color', 'black',
                            'important');


                        // Filter the options based on the specified attributes
                        var matchingOption = $('#Daily_energy_requirement1 option').filter(function() {
                            return $(this).attr('age') === age &&
                                $(this).attr('gender') === gender;
                        });

                        console.log('matchingOption.length', matchingOption.length);

                        // Check if any matching option was found and log the value of the moderate attribute
                        if (matchingOption.length) {
                            var moderate = matchingOption.attr('moderate');
                            console.log('moderate:', moderate);

                            $("#Daily_energy_requirement").val(moderate).attr('readonly', true);

                        } else {
                            console.log('No matching option found');

                            $("#Daily_energy_requirement").val('').attr('readonly', false);

                        }




                    } else if (selectedValue === 'Active') {


                        Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty(
                            'background-color', 'green', 'important');
                        Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty('color', 'white',
                            'important');


                        // Filter the options based on the specified attributes
                        var matchingOption = $('#Daily_energy_requirement1 option').filter(function() {
                            return $(this).attr('age') === age &&
                                $(this).attr('gender') === gender;
                        });

                        console.log('matchingOption.length', matchingOption.length);


                        // Check if any matching option was found and log the value of the moderate attribute
                        if (matchingOption.length) {
                            var activela = matchingOption.attr('activela');
                            console.log('activela', activela);

                            $("#Daily_energy_requirement").val(activela).attr('readonly', true);

                        } else {
                            console.log('No matching option found');

                            $("#Daily_energy_requirement").val('').attr('readonly', false);

                        }



                    } else {

                        Question_No_60_How_would_you_describe_your_lifestyle.style.removeProperty(
                            'background-color');
                        Question_No_60_How_would_you_describe_your_lifestyle.style.removeProperty('color');
                        $("#Daily_energy_requirement").val('').attr('readonly', false);


                    }
                });










            /* lifestyle */


            $('#lifestyle').change(function() {


                var selectedValue = $(this).val();

                var lifestyle = document.getElementById("lifestyle");

                if (selectedValue === 'Sedentary') {


                    lifestyle.style.setProperty('background-color', 'red', 'important');
                    lifestyle.style.setProperty('color', 'white', 'important');

                } else {

                    lifestyle.style.removeProperty('background-color');
                    lifestyle.style.removeProperty('color');

                }
            });


            /* meals*/
            $('#meals').change(function() {
                var selectedValue = $(this).val();
                console.log("meals " + selectedValue);

                if (selectedValue === "1") {

                    this.style.setProperty('background-color', 'red', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else {

                    this.style.removeProperty('background-color');
                    this.style.removeProperty('color');
                }
            });



            /* food_items*/
            $('#food_items').change(function() {
                var selectedValue = $(this).val();
                // console.log("meals " + selectedValue);

                if (selectedValue === "0-1") {

                    this.style.setProperty('background-color', 'green', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else if (selectedValue === "1-2") {

                    this.style.setProperty('background-color', 'yellow', 'important');
                    this.style.setProperty('color', 'black', 'important');

                } else if (selectedValue === "3 or more") {

                    this.style.setProperty('background-color', 'red', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else {

                    this.style.removeProperty('background-color');
                    this.style.removeProperty('color');
                }
            });




            /* fast_food*/
            $('#fast_food').change(function() {
                var selectedValue = $(this).val();
                // console.log("meals " + selectedValue);

                if (selectedValue === "0-1") {

                    this.style.setProperty('background-color', 'green', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else if (selectedValue === "< 1") {

                    this.style.setProperty('background-color', 'green', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else if (selectedValue === "1-2") {

                    this.style.setProperty('background-color', 'yellow', 'important');
                    this.style.setProperty('color', 'black', 'important');

                } else if (selectedValue === "3 or more") {

                    this.style.setProperty('background-color', 'red', 'important');
                    this.style.setProperty('color', 'white', 'important');

                } else {

                    this.style.removeProperty('background-color');
                    this.style.removeProperty('color');
                }
            });


            $('#fast_food').change();




            var currentDate = new Date().toISOString().split('T')[0];
            $('#dob').attr('max', currentDate);

            $('.prevStep').click(function() {
                var currentStep = $(this).closest('.step');
                var prevStep = currentStep.prev('.step');

                // Move to the previous step
                currentStep.removeClass('active');
                prevStep.addClass('active');
            });

            $('.form-group').on('blur change', '.error-border', function() {
                if ($(this).val()) {
                    $(this).removeClass('error-border').closest('.form-group').find('.error-text').remove();
                }
            })

            function validate(e, isLastStep = false) {
                $('.error-text').remove()
                let closestDiv = isLastStep ? '.last-step' : '.step';
                var currentStep = $(e.target).closest(closestDiv);
                var nextStep = currentStep.next('.step');
                var checkboxes = $('.form-group input[type="checkbox"]');
                var isValid = true;

                var fieldErrors = [];
                // Check if all required fields in the current step are filled
                currentStep.find('input[required], select[required], input[type="checkbox"]:checked').each(
                    function() {
                        if ($(this).val() == '' || $(this).val() == null) {
                            fieldErrors.push($(this).attr('id'))
                            isValid = false;
                            // return false; // Exit the loop if a required field is empty
                        }
                    });


                if (isValid && !isLastStep) {
                    currentStep.removeClass('active');
                    nextStep.addClass('active');
                } else {
                    for (fieldError of fieldErrors) {
                        $('#' + fieldError)
                            .addClass('error-border')
                            .closest('.form-group')
                            .append('<small class="text-danger error-text">This field is required</small>');
                    }
                }
                return isValid;
            }
            $('.nextStep').click(validate)
            // });

            $("#height").on("keyup change", function(e) {

                var height = $('#height').val();
                if (height != '') {
                    $('#weight').removeAttr("disabled");
                } else {
                    $('#weight').attr("disabled", true);
                }

                var dob = $("#dob").val();


                var today = new Date();
                var birthDate = new Date(
                    dob
                ); // Assuming 'dob' is a variable containing the birthdate string in the format like "YYYY-MM-DD"
                var age = today.getFullYear() - birthDate.getFullYear();
                var monthDiff = today.getMonth() - birthDate.getMonth();
                var totalMonths = age * 12 + monthDiff;

                // if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {

                //     age--;
                // }

                /*
                console.log("birthDate.getDate()  " + birthDate.getDate());
                console.log("today.getDate()  " + today.getDate());
                console.log("birthDate.getFullYear()  " + birthDate.getFullYear());
                console.log("birthDate.getMonth()  " + birthDate.getMonth());
                console.log("today.getFullYear()  " + today.getFullYear());
                console.log("today.getMonth()  " + today.getMonth());
                console.log("dob " + dob);
                console.log("today " + today);
                console.log("birthDate " + birthDate);
                console.log("age " + age);
                console.log("monthDiff " + monthDiff);
                console.log("totalMonths " + totalMonths);
                console.log("---------------------------------------------------- ");
                */

                var this1 = $(this);


                /*
                var base_url = '{!! Route('HeightForAge') !!}';



                $.ajax({
                    url: base_url,
                    type: "post",
                    data: {
                        "_token": "{{ csrf_token() }}",
                        age_month: totalMonths,
                        height: height
                    },

                    dataType: 'json',



                    success: function(resp) {


                        if (resp['status'] === true) {

                            $('.errorSmall').remove()
                            if ($('.successsSmall').length == 0) {
                                $('#height')
                                    // .addClass('error-border')
                                    .closest('.form-group')
                                    .append(
                                        '<small class="successsSmall text-success error-text">' +
                                        resp['message'] + '</small>');

                            }


                            this1.css("background-color", "");
                            this1.css("color", "");



                        } else {
                            $('.successsSmall').remove()
                            if ($('.errorSmall').length == 0) {
                                $('#height')
                                    // .addClass('error-border')
                                    .closest('.form-group')
                                    .append(
                                        '<small class="errorSmall text-danger error-text">' +
                                        resp['message'] + '</small>');

                            }

                            this1.css("background-color", "#f94848");
                            this1.css("color", "white");
                        }



                    }
                });

                */

            });

            $("#weight, #height").on("keyup change", function(e) {
                var height = $('#height').val();
                var weight = $('#weight').val();
                var bmi = $('#bmi');
                if (height != '' && height > 0 && weight != '' && weight > 0) {
                    var result = (weight / height / height) * 10000;
                    $('#bmi').val(result.toFixed(2));
                    $('#bmi61').val(result.toFixed(2));
                    if (result <= 18.4 || result >= 24.10) {
                        $("#bmi").addClass("bg-danger");
                        $("#bmishow").val("High")
                        $("#bmiresult").val('High')
                        $("#bmi61").addClass("bg-danger");

                    } else {
                        $("#bmi").removeClass("bg-danger");
                        $("#bmishow").val("Noraml")
                        $("#bmiresult").val('Noraml')
                        $("#bmi61").removeClass("bg-danger");

                    }
                }
            });


            $("#Question_No_5_Blood_Pressure_Systolic").on("keyup change", function(e) {
                var systolic = parseInt($('#Question_No_5_Blood_Pressure_Systolic').val());
                var age = parseInt($('#age').val());
                /*console.log("Age", age);*/


                $("#Blood_Pressure_Systolic").text("").removeClass("text-success");

                if (age > 1 && age < 12) {
                    if (systolic < 90) {
                        $("#Blood_Pressure_Systolic").text("Normal BP").addClass("text-success");
                        $("#systolicresult").val("Normal BP")
                    } else if (systolic >= 90 && systolic < 95) {
                        $("#Blood_Pressure_Systolic").text("Elevated BP").addClass("text-success");
                        $("#systolicresult").val("Elevated BP")

                    } else if (systolic >= 130 && systolic < 139) {
                        $("#Blood_Pressure_Systolic").text("Stage 1 HTN ").addClass("text-success");
                        $("#systolicresult").val("Stage 1 HTN")

                    } else if (systolic > 140) {
                        $("#Blood_Pressure_Systolic").text("Stage 2 HTN ").addClass("text-success");
                        $("#systolicresult").val("Stage 2 HTN")

                    }
                } else if (age >= 13) {
                    if (systolic < 120) {
                        $("#Blood_Pressure_Systolic").text("Normal BP").addClass("text-success");
                        $("#systolicresult").val("Normal BP")

                    } else if (systolic >= 120 && systolic < 129) {
                        $("#Blood_Pressure_Systolic").text("Elevated BP").addClass("text-success");
                        $("#systolicresult").val("Elevated BP")

                    } else if (systolic >= 130 && systolic < 139) {
                        $("#Blood_Pressure_Systolic").text("Stage 1 HTN").addClass("text-success");
                        $("#systolicresult").val("Stage 1 HTN")

                    } else if (systolic > 90) {
                        $("#Blood_Pressure_Systolic").text("Stage 3 HTN ").addClass("text-success");
                        $("#systolicresult").val("Stage 1 HTN")

                    }
                }
            });


            $("#Question_No_6_Blood_Pressure_Diastolic").on("keyup change", function(e) {
                var diastolic = parseInt($('#Question_No_6_Blood_Pressure_Diastolic').val());
                var age = parseInt($('#age').val());
                /*console.log("Age", age);*/


                $("#Blood_Pressure_Diastolic").text("").removeClass("text-success");

                if (age > 1 && age < 12) {
                    if (diastolic < 90) {
                        $("#Blood_Pressure_Diastolic").text("Normal BP").addClass("text-success");
                        $("#diastolicresult").val("Normal BP")

                    } else if (diastolic >= 90 && diastolic < 95) {
                        $("#Blood_Pressure_Diastolic").text("Elevated BP").addClass("text-success");
                        $("#diastolicresult").val("Elevated BP")

                    } else if (diastolic >= 80 && diastolic < 89) {
                        $("#Blood_Pressure_Diastolic").text("Stage 1 HTN ").addClass("text-success");
                        $("#diastolicresult").val("Stage 1 HTN")

                    } else if (diastolic >= 140) {
                        $("#Blood_Pressure_Diastolic").text("Stage 2 HTN ").addClass("text-success");
                        $("#diastolicresult").val("Stage 2 HTN")

                    }
                } else if (age >= 13) {
                    if (diastolic < 80) {
                        $("#Blood_Pressure_Diastolic").text("Elevated BP").addClass("text-success");
                        $("#diastolicresult").val("Elevated BP")

                    } else if (diastolic >= 80 && diastolic < 89) {
                        $("#Blood_Pressure_Diastolic").text("Stage 1 HTN").addClass("text-success");
                        $("#diastolicresult").val("Stage 1 HTN")

                    } else if (diastolic > 90) {
                        $("#Blood_Pressure_Diastolic").text("Stage 2 HTN ").addClass("text-success");
                        $("#diastolicresult").val("Stage 2 HTN")

                    }
                }
            });


            $("#Question_No_7_Pulse").on("keyup change", function(e) {
                var pulse = $('#Question_No_7_Pulse').val();
                var age = $('#age').val();

                if (age >= 3 && age <= 5) {
                    if (pulse <= 79 || pulse >= 121) {
                        $("#Question_No_7_Pulse").addClass("bg-danger");
                    } else {
                        $("#Question_No_7_Pulse").removeClass("bg-danger");
                    }
                } else if (age >= 6 && age <= 12) {
                    if (pulse <= 74 || pulse >= 119) {
                        $("#Question_No_7_Pulse").addClass("bg-danger");
                    } else {
                        $("#Question_No_7_Pulse").removeClass("bg-danger");
                    }
                } else if (age >= 13 && age <= 17) {
                    if (pulse <= 59 || pulse >= 101) {
                        $("#Question_No_7_Pulse").addClass("bg-danger");
                    } else {
                        $("#Question_No_7_Pulse").removeClass("bg-danger");
                    }
                }
            });



            $('#any_neck_swelling').on('change', function() {
                var result = $(this).val();
                if (result === 'Yes') {
                    $('.any_neck_swelling_specify').removeClass('d-none');
                } else {
                    $('.any_neck_swelling_specify').addClass('d-none');
                }

            });

            $('#any_history_of_abdominal_pain').on('change', function() {
                var result = $(this).val();
                if (result === 'Yes') {
                    $('.any_history_of_abdominal_pain_specify').removeClass('d-none');
                } else {
                    $('.any_history_of_abdominal_pain_specify').addClass('d-none');
                }

            });
            $('#any_menstrual_abnormality').on('change', function() {
                var result = $(this).val();
                if (result === 'Yes') {
                    $('.any_menstrual_abnormality_specify').removeClass('d-none');
                } else {
                    $('.any_menstrual_abnormality_specify').addClass('d-none');
                }

            });

            $('#limitations_range_motion').on('change', function() {
                var result = $(this).val();
                if (result === 'Yes') {
                    $('.limitations_range_motion_specify').removeClass('d-none');
                } else {
                    $('.limitations_range_motion_specify').addClass('d-none');
                }

            });

            $('#lymph_node').on('change', function() {
                var result = $(this).val();
                if (result === 'abnormal') {
                    $('.lymph_node_specify').removeClass('d-none');
                } else {
                    $('.lymph_node_specify').addClass('d-none');
                }

            });

            $('#do_you_have_any_Allergies').on('change', function() {
                var result = $(this).val();
                if (result === 'Yes') {
                    $('.do_you_have_any_Allergies_specify').removeClass('d-none');
                } else {
                    $('.do_you_have_any_Allergies_specify').addClass('d-none');
                }

            });

            $('#menarche_age').on('change', function() {
                var result = $(this).val();
                if (result === 'none_of_the_above') {
                    $('.menarche_age_specify').removeClass('d-none');
                    $(".menstrual_abnormality option[value='']").attr('selected', 'selected');

                } else {
                    $('.menarche_age_specify').addClass('d-none');
                    $('.menstrual_abnormality_specify').addClass('d-none');

                }
            });
            // $('#followup_required').on('change', function() {
            //     var result = $(this).val();
            //     if (result === 'Yes') {
            //         $('.reffered').removeClass('d-none');
            //         $(".reffered option[value='']").attr('selected', 'selected');

            //     } else {
            //         $('.reffered').addClass('d-none');                   

            //     }
            // });
            $('#followup_required').on('change', function() {
                var result = $(this).val();
                if (result === 'Yes') {
                    $('.reffered').removeClass('d-none');
                    $(".reffered option[value='']").attr('selected', 'selected');
                } else {
                    $('#referred_by').val('');
                    $('.reffered').addClass('d-none');
                }
            });

            $('#menstrual_abnormality').on('change', function() {
                var result = $(this).val();
                if (result === 'Yes') {
                    $('.menstrual_abnormality_specify').removeClass('d-none');
                } else {
                    $('.menstrual_abnormality_specify').addClass('d-none');
                }

            });

            $('#immunization_card').on('change', function() {
                var result = $(this).val();
                if (result === 'No') {
                    $('.immunization_card_specify').removeClass('d-none');
                } else {
                    $('.immunization_card_specify').addClass('d-none');
                }

            });



            $("#dob").on("change", function() {

                var dob = $(this).val();

                if (dob) {

                    var today = new Date();
                    var birthDate = new Date(dob);
                    var age = today.getFullYear() - birthDate.getFullYear();
                    var monthDiff = today.getMonth() - birthDate.getMonth();
                    var gender = $("#gender").val();

                    var totalMonths = (age * 12) + monthDiff;

                    if (today.getDate() < birthDate.getDate()) {
                        totalMonths--;
                    }

                    $("#age").val(age);

                    if (totalMonths >= 7 && totalMonths <= 12) {
                        $("#Daily_Protien_requirement").val("1.0").attr('readonly', true);
                    } else if (age >= 1 && age <= 3) {
                        $("#Daily_Protien_requirement").val("0.87").attr('readonly', true);
                    } else if (age >= 4 && age <= 8) {
                        $("#Daily_Protien_requirement").val("0.76").attr('readonly', true);
                    } else if (age >= 9 && age <= 13) {
                        $("#Daily_Protien_requirement").val("0.76").attr('readonly', true);
                    } else if (age >= 14 && age <= 18 && $("#gender").val() == "male") {
                        $("#Daily_Protien_requirement").val("0.73").attr('readonly', true);
                    } else if (age >= 14 && age <= 18 && $("#gender").val() == "female") {
                        $("#Daily_Protien_requirement").val("0.71").attr('readonly', true);
                    } else {
                        $("#Daily_Protien_requirement").val("").attr('readonly', false);

                    }



                } else {

                    $("#age").val("");
                    $("#Daily_Protien_requirement").val("").attr('readonly', false);

                }


                /* Check if age is less than 5 */
                if (parseFloat(age) < 5) {
                    /* Hide the field and remove the required attribute */
                    $('#muac').closest('.form-group').hide();
                    $('#muac').removeAttr('required');
                    $('#muac').val('');
                    $('#muac-container').hide();

                } else {
                    /* Show the field and ensure the required attribute is present */
                    $('#muac').closest('.form-group').show();
                    $('#muac').attr('required', true);
                    $('#muac').val('');
                    $('#muac-container').show();


                }


                var weight = parseFloat($("#weight").val());
                var dailyEnergyRequirement = parseFloat($("#Daily_Protien_requirement").val());

                if (weight > 0) {
                    var dailyProteinRequirement = dailyEnergyRequirement * weight;
                    $("#Daily_Protien_requirement").val(dailyProteinRequirement).attr('readonly', true);
                }






            });


            $('#submit').on('click', function(e) {

                if (!validate(e, true)) return;
                //    console.log(validate());

                var form = $('#multiStepForm');
                var formData = form.serializeArray();
                var secondsOnSubmit;


                var endTime = new Date();
                var timeDiff = endTime - startTime;
                secondsOnSubmit = Math.round(timeDiff / 1000);

                var formData = $('#multiStepForm').serializeArray();
                console.log("formData "+ formData);


                $.each(formData, function(index, field) {
                    var fieldId = field['name'];
                    var fieldValue = field['value'];

                });


                
                let _token = $('meta[name="csrf-token"]').attr('content');
                formData.push({
                    name: 'duration',
                    value: secondsOnSubmit
                });
                $.ajax({
                    type: "post",
                    url: "{{ route('post_data') }}",
                    data: {
                        _token: _token,
                        formData: formData

                    },
                    dataType: "json",
                    beforeSend: function() {

                    },
                    success: function(response) {
                        // alert(response);
                        // console.log(response);
                        Swal.fire({
                            title: 'Success!',
                            text: 'Enrollment has been submitted successfully!',
                            icon: 'success',
                            confirmButtonText: 'OK',
                            timer: 2000, // Set the timer to 2 seconds (in milliseconds)
                            timerProgressBar: true, // Show a progress bar during the timer
                            showConfirmButton: false // Hide the "OK" button
                        }).then(() => {
                            window.location.href = "{{ route('admin.form.index') }}"
                        });

                    },
                    error: function(err) {
                        console.log(err);
                    }
                });
            });

            var form = $('#multiStepForm');
            var startTime;
            var timerInterval;
            var secondsOnSubmit;

            form.one('focusin', function() {
                // Set the start time when any form field is focused
                startTime = new Date();

                // Start a timer interval to update the display every second
                timerInterval = setInterval(function() {
                    var currentTime = new Date();
                    var timeDiff = currentTime - startTime;
                    var seconds = Math.round(timeDiff / 1000);
                    $('#timer').text('Time: ' + seconds + ' seconds');
                }, 1000);
            });
        });





        const food_allergies = document.getElementById('food_allergies');
        // Select the container of the textarea
        const food_allergiesContainer = document.getElementById('food_allergiesContainer');

        // Add change event listener to the dropdown
        food_allergies.addEventListener('change', function() {
            // If 'other' is selected, show the textarea; otherwise, hide it
            if (this.value === 'Yes') {
                food_allergiesContainer.classList.remove('d-none');
            } else {
                food_allergiesContainer.classList.add('d-none');
            }
        });
    </script>

@endsection
{{-- <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script> --}}
