<?php $__env->startSection('content'); ?>
    <style>
        @media (min-width: 992px) {

            .mdk-drawer-layout .container,
            .mdk-drawer-layout .container-fluid,
            .mdk-drawer-layout .container-lg,
            .mdk-drawer-layout .container-md,
            .mdk-drawer-layout .container-sm,
            .mdk-drawer-layout .container-xl {
                max-width: 1440px;
            }
        }



        #userDataTable_wrapper {
            padding: 10px;
        }

        #userDataTable_info {
            color: #fff;
        }

        div#userDataTable_filter {
            display: flex;
            justify-content: end;
            margin-right: 20px;
        }

        .ic {
            color: #d86744 !important;
            /* font-weight: 500; */
            height: 20px;
            width: 20px;
            /* font-size: 15px; */

        }
    </style>
    <div class="pt-32pt">
        <div class="container page__container d-flex flex-column flex-md-row align-items-center text-center text-sm-left">
            <div class="flex d-flex flex-column flex-sm-row align-items-center mb-24pt mb-md-0">

                <div class="mb-24pt mb-sm-0 mr-sm-24pt">
                    <h2 class="mb-0">Dashboard</h2>

                    <ol class="breadcrumb p-0 m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard.index')); ?>">Home</a></li>

                        <li class="breadcrumb-item active">

                            School

                        </li>

                    </ol>

                </div>
            </div>
            <div class="row" role="tablist">
                <div class="col-auto">
                    <!-- <a href="<?php echo e(url('/module')); ?>" class="btn btn-outline-secondary"><i class="fa fa-plus"></i> &nbsp; Add Student</a> -->
                    <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addStudentModal"><i
                            class="fas fa-user-plus"></i>Add School
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Page Content -->

    <div class="container page__container page__container page-section">
        <div class="page-separator">
            <div class="page-separator__text">School</div>
        </div>


        <?php if(Session::has('error_message')): ?>
            <div class="alert alert-secondary dark alert-dismissible fade show" role="alert">
                <?php echo e(Session::get('error_message')); ?>.
               
            </div>
        <?php endif; ?>

        <?php if(Session::has('success_message')): ?>
            <div class="alert alert-success dark alert-dismissible fade show" role="alert">
                <?php echo e(Session::get('success_message')); ?>.
             
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>


        <div class="card mb-0">
            <div class="table-responsive" data-toggle="lists" data-lists-sort-by="js-lists-values-employee-name"
                data-lists-values='["js-lists-values-employee-name", "js-lists-values-employer-name", "js-lists-values-projects", "js-lists-values-activity", "js-lists-values-earnings"]'>
                
                <table class="table mb-0 thead-border-top-0 table-nowrap" id="userDataTable">

                    <thead>
                        <tr>
                            <th>
                                SR No.
                            </th>
                            <th>
                                School Name
                            </th>

                            <th>
                                Address
                            </th>

                            <th>
                                Area
                            </th>


                            <th>
                                School Representative
                            </th>
                            <th>
                                Email
                            </th>

                            <th>
                                Status
                            </th>
                            <th>
                                Created At
                            </th>
                            <th>
                                Action
                            </th>
                            
                        </tr>
                    </thead>


                    <?php $__currentLoopData = $school; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <?php echo e($item->id); ?>

                            </td>
                            <td>
                                <?php echo e($item->school_name); ?>

                            </td>
                            <td>
                                <?php echo e($item->address); ?>


                            </td>
                            <td>
                                <?php echo e($item->area); ?>

                            </td>


                            <td>
                                <?php echo e($item->school_representative); ?>

                            </td>
                            <td>
                                <?php echo e($item->email); ?>

                            </td>
                            

                            <td>
                                <?php if($item->status == '1'): ?>
                                    <!-- Active Status -->
                                    <span class="badge badge-success">Active</span>
                                <?php elseif($item->status == '0'): ?>
                                    <!-- Inactive Status -->
                                    <span class="badge badge-danger">Inactive</span>
                                <?php else: ?>
                                    <!-- Pending Status -->
                                    <span class="badge badge-warning">Pending</span>
                                <?php endif; ?>
                            </td>


                            <td>
                                <?php echo e(\Carbon\Carbon::parse($item->created_at)->addHours(5)->toDateTimeString()); ?>


                            </td>

                            
                            <td>
                                <a href="<?php echo e(url('edit_school_form')); ?>/<?php echo e($item->id); ?>"><i
                                        class="fa fa-edit ic"></i></a>


                                <?php if($item->status == '1'): ?>
                                    <a href="<?php echo e(url('school_status')); ?>/<?php echo e($item->id); ?>/<?php echo e($item->status); ?>"> <i
                                            class="fa fa-close ic"></i></a>
                                <?php else: ?>
                                    <a href="<?php echo e(url('school_status')); ?>/<?php echo e($item->id); ?>/<?php echo e($item->status); ?>"> <i
                                            class="fa fa-check ic"></i></a>
                                <?php endif; ?>

                            </td>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
        </div>

    </div>

    <!-- Add Student Modal  -->
    <div class="modal fade" id="addStudentModal" tabindex="-1" role="dialog" aria-labelledby="addStudentModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addStudentModalLabel">Add School</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="adduser">
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                        <div class="form-group col-md-12">
                            <div class="form-group">
                                <label for="School Name">School Name</label>
                                <input type="text" class="form-control" id="school_name" name="school_name" required>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                            <div class="form-group">
                                <label for="Address">Address</label>
                                <input type="email" class="form-control" id="address" name="address" required>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                            <div class="form-group">
                                <label for="Area">Area</label>
                                <input type="text" class="form-control" id="area" name="area" required>
                            </div>
                        </div>

                        <div class="form-group col-md-12">
                            <div class="form-group">
                                <label for="School Representative">School Representative</label>
                                <input type="text" class="form-control" id="school_representative"
                                    name="school_representative" required>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                            <div class="form-group">
                                <label for="Email">Email</label>
                                <input type="email" class="form-control" id="email" name="email" required>
                            </div>
                        </div>


                        <div class="form-group col-md-12">
                            <div class="form-group position-relative">
                                <label for="Password">Password</label>
                                <input type="password" class="form-control" id="Password" name="Password" required>
                                <span class="toggle-password position-absolute">
                                    <i class="fas fa-eye "></i>
                                </span>
                            </div>
                        </div>



                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="submitStudent" onclick="datapass();">

                        Submit
                    </button>
                </div>
            </div>
        </div>
    </div>






    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Handle form submission
        // $('#submitStudent').on('click', function() {
        //     datapass();
        // });


        datapass = () => {
            var Schoolname = document.getElementById("school_name").value;
            var Address = document.getElementById("address").value;
            var Area = document.getElementById("area").value;
            var School_representative = document.getElementById("school_representative").value;
            var Email = document.getElementById("email").value;
            var Password = document.getElementById("Password").value;

            let _token = $('meta[name="csrf-token"]').attr('content');
            $.ajax({
                type: "post",
                url: "<?php echo e(route('add_school')); ?>",
                data: {
                    _token: _token,
                    school_name: Schoolname,
                    address: Address,
                    area: Area,
                    school_representative: School_representative,
                    email: Email,
                    Password: Password,
                },
                dataType: "json",
                success: function(response) {
                    if (response.status === 'success') {
                        
                        Swal.fire({
                            title: 'Success!',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'OK',
                            timer: 1000,
                            timerProgressBar: true,
                            showConfirmButton: false
                        }).then(() => {
                            location.reload(); // Reload the page when the timer expires
                        });
                    }
                },
                error: function(xhr) {
                    // Handle validation errors
                    let errors = xhr.responseJSON.errors;
                    let errorMessages = '';
                    $.each(errors, function(key, value) {
                        errorMessages += value + '<br>';
                    });

                    Swal.fire({
                        title: 'Error!',
                        html: errorMessages,
                        icon: 'error',
                        confirmButtonText: 'OK',
                        timer: 1000, // Auto-close after 10 seconds
                        timerProgressBar: true, // Show a progress bar
                        showConfirmButton: false, // Hide the "OK" button
                    }).then((result) => {
                        if (result.dismiss === Swal.DismissReason.timer) {
                            // Reload the page and reset the form
                            $('#adduser')[0].reset(); // Reset the form
                            location.reload(); // Reload the page
                        }
                    });
                }
            });

            $('#addStudentModal').modal('hide');
        }
    </script>

    <script>
        $(document).ready(function() {
            var userDataTable = $('#userDataTable').DataTable({
                "pageLength": 10,    "ordering": false, // Set the default number of entries per page
                // ... Other DataTables configurations ...
            });
        });

        function changeEntriesPerPage() {
            var entriesPerPage = document.getElementById("entriesPerPage").value;
            var userDataTable = $('#userDataTable').DataTable();

            // Set the number of entries per page
            userDataTable.page.len(entriesPerPage).draw();
        }
    </script>


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <style>
        .position-relative {
            position: relative;
        }

        .toggle-password {
            position: absolute;
            right: 10px;
            top: 55% !important;
            cursor: pointer;
            z-index: 10;
            color: black;
            /* Black color for the eye icon */
        }

        .toggle-password i {
            font-size: 20px;
            /* Adjust size if needed */
        }

        .eye-with-cross {
            position: relative;
            display: inline-block;
        }

        .eye-with-cross::before,
        .eye-with-cross::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 100%;
            height: 2px;
            /* Thickness of the line */
            background-color: black;
            /* Color of the line */
            transform: translate(-50%, -50%);
        }

        .eye-with-cross::before {
            transform: translate(-50%, -50%) rotate(45deg);
            /* Rotate line to form a cross */
            width: 100%;
            /* Adjust width if necessary */
        }

        .eye-with-cross::after {
            transform: translate(-50%, -50%) rotate(-45deg);
            /* Rotate line to form a cross */
            width: 100%;
            /* Adjust width if necessary */
        }
    </style>

    <script>
        $(document).ready(function() {
            $('.toggle-password').on('click', function() {
                const passwordField = $('#Password');
                const eyeIcon = $(this).find('i');

                console.log(passwordField.html());
                console.log(eyeIcon.html());
                if (passwordField.attr('type') === 'password') {
                    passwordField.attr('type', 'text');
                    eyeIcon.removeClass('fa-eye').addClass('fa-eye-slash');
                    eyeIcon.removeClass('eye-with-cross');
                } else {
                    passwordField.attr('type', 'password');
                    eyeIcon.removeClass('fa-eye-slash').addClass('fa-eye');
                    eyeIcon.addClass('eye-with-cross');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>





<?php echo $__env->make('admin.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rehman/public_html/cphs/resources/views/admin/school.blade.php ENDPATH**/ ?>