<?php $__env->startSection('content'); ?>
<style>
    @media (min-width:992px) {

        .mdk-drawer-layout .container,
        .mdk-drawer-layout .container-fluid,
        .mdk-drawer-layout .container-lg,
        .mdk-drawer-layout .container-md,
        .mdk-drawer-layout .container-sm,
        .mdk-drawer-layout .container-xl {
            max-width: 1600px !important;
        }
    }

    .custom_card_btn {
        width: 100%;
        text-align: center;
    }


    .custom_card_btn .btn {
        background: #ffffff;
        color: #000;
        width: 100%;
        border-radius: 20px;
        padding: 20px 20px;
        font-size: 24px;
        margin: 0;
        font-weight: 700;
        gap: 0px;
        transition: 0.3s ease;
        display: flex;
        flex-direction: column;
        border: 1px solid rgba(0, 0, 0, .15);
    }

    .custom_card_btn .btn:hover {
        background: #d86744 !important;
    }

    .custom_card_btn .btn b {
        font-size: 36px;
        margin-top: -10px;
        padding: 0;
        color: #000;
    }

    .custom_card_btn .btn svg {
        color: #d86744;
        width: 50px;
        height: 50px;
        margin-bottom: 10px;
    }

    .custom_card_btn .btn:hover svg {
        color: #fff;
    }

    .custom_card_btn .btn:hover b {
        color: #fff;
    }

    .graph {
        padding: 20px;
    }

    .h1 {
        text-align: center;
    }

    .chartDivRow {
        display: flex;
        align-items: center;
        justify-content: start;
        flex-wrap: wrap;
        gap: 10px;
    }

    .chartDivOuter {
        height: 350px;
        border-radius: 5px;
        border: 1px solid rgba(0, 0, 0, .15);
        width: calc(50% - 10px);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .chartdiv {
        width: 100%;
        height: 100%;
    }

    #daterange {
        width: 200px;
        margin-left: auto;
        margin-bottom: 10px;
        margin-right: 10px;
    }

    .table tbody td button.counts {
        border: 1px solid #d86744;
        background: none;
        min-width: 34px;
        min-height: 26px;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto;
        color: #d86744;
        font-weight: 600;
        transition: all 0.3s ease;
        border-radius: 5px;
        padding: 0;
    }

    .table tbody td button.counts:hover {
        background: #d86744;
        color: #fff;
    }

    #findingreport-table_wrapper {
        padding: 10px;
    }

    div#datatable_info {
        color: #fff;
    }

    div.dataTables_filter {
        display: flex;
        justify-content: end;
        margin-right: 20px;
    }

    .btn-view {
        background-color: #ff5722;
        color: white;
        border: none;
        padding: 4px 10px;
        border-radius: 5px !important;
    }

    .fromtosearch {
        display: flex;
        align-items: flex-end;
        gap: 1rem;
    }

    .fromtosearch label {
        margin: 0;
    }

    .fromtosearch button {
        padding: .375rem 2rem !important;
    }
</style>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/fixedcolumns/4.3.0/css/fixedColumns.bootstrap4.min.css" />
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

<div class="pt-32pt">
    <div class="container page__container d-flex flex-column flex-md-row align-items-center text-center text-sm-left">
        <div class="flex d-flex flex-column flex-sm-row align-items-center mb-24pt mb-md-0">
            <div class="mb-24pt mb-sm-0 mr-sm-24pt">
                <h2 class="mb-0">Dashboard</h2>
                <ol class="breadcrumb p-0 m-0">
                    <li class="breadcrumb-item"><a href="http://127.0.0.1:8000/admin/dashboard">Home</a></li>
                    <li class="breadcrumb-item active">
                        Reportable Findings Report
                    </li>
                </ol>
            </div>
        </div>
        <form class="fromtosearch" method="GET" action="<?php echo e(route('reportable-findings')); ?>">
            <label for="start_date">
                <span class="d-block">From</span>
                <input type="date" name="start_date" id="start_date" class="form-control form-control-sm" value="<?php echo e(request('start_date')); ?>">
            </label>
            <label for="end_date">
                <span class="d-block">To</span>
                <input type="date" name="end_date" id="end_date" class="form-control form-control-sm" value="<?php echo e(request('end_date')); ?>">
            </label>
            <button type="submit" class="btn btn-primary">Search</button>
        </form>
    </div>
</div>

<!-- Page Content -->

<div class="container-fluid page__container page__container page-section" style="max-width: 100% !important;">
    <div class="page-separator">
        <div class="page-separator__text">Reportable Findings Report</div>
    </div>
    <div class="card mb-0">
        <div class="table-responsive">
            <table class="table table-striped table-bordered datatable table-nowrap findingreportTable" id="findingreport-table" style="z-index:3;width:100%">
                <thead style="color:black;">
                    <tr class="bg-primary white">
                        <th>SR No.</th>
                        <th>School Name</th>
                        <th>Total Students</th>
                        <th>Total Screened Students</th>
                        <th>Total Findings</th>
                        <th>Posture/Gait</th>
                        <th>Jaundice</th>
                        <th>Clubbing</th>
                        <th>Skin</th>
                        <th>Nails</th>
                        <th>Lice/Nits</th>
                        <th>Hair and Scalp</th>
                        <th>Scalp</th>
                        <th>Ocular Alignment</th>
                        <th>Nystagmus</th>
                        <th>Ear Examination</th>
                        <th>External Nasal Examination</th>
                        <th>Assess Gingiva</th>
                        <th>Examine Tonsils</th>
                        <th>Neck Swelling</th>
                        <th>Visible Chest Deformity</th>
                        <th>Cardiac Auscultation</th>
                        <th>Limitations in Joint Motion</th>
                        <th>Side-to-Side Curvature</th>
                        <th>Foot or Toe Abnormalities</th>
                        <th>Allergies</th>
                        <th>BMI</th>
                        <th>Anemia</th>
                        <th>Color Vision</th>
                        <th>Dental Caries</th>
                        <th>Breath</th>
                        <th>Discuss Hygiene</th>
                        <th>Uniform</th>
                        <th>Hair Problem</th>
                        <th>Ear Shape</th>
                        <th>Rinne Weber</th>
                        <th>Patency Test</th>
                        <th>Speech Development</th>
                        <th>Lung Auscultation</th>
                        <th>Distension, Scars, or Masses</th>
                        <th>Spinal Curvature</th>
                        <th>Vaccination</th>
                        <th>Discomfort During Urination</th>
                        <th>Menstrual Abnormality</th>
                      <!--   <th>Restless or overactive?</th>
                        <th>Excitable, Impulsive?</th>
                        <th>Disturbs other children?</th>
                        <th>Fails to finish things started</th>
                        <th>Inattentive, easily distracted?</th>
                        <th>Cries often and easily?</th>
                        <th>Is your spelling poor?</th>
                        <th>do you often make mistakes?</th>
                        <th>difficulty in telling left from right?</th>
                        <th>mix up bus numbers?</th> -->
                        <th>Life Style</th>
                        <th>Addiction</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $school): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($school->school_name); ?></td>
                        <td><?php echo e($school->total_students ?? 0); ?></td>
                        <td><?php echo e($screenedBySchool[$school->id] ?? 0); ?></td>
                        <td><b><?php echo e($schoolTotals[$school->school_name] ?? 0); ?></b></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="NormalPosture"><?php echo e($school->NormalPostureCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="jaundice"><?php echo e($school->jaundiceCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="clubing"><?php echo e($school->clubingCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="skin"><?php echo e($school->skinCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="nail"><?php echo e($school->nailCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="lice"><?php echo e($school->liceCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="hair"><?php echo e($school->hairCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="Scalp"><?php echo e($school->ScalpCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="ocular"><?php echo e($school->ocularCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="Nystagmus"><?php echo e($school->NystagmusCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="EarExamination"><?php echo e($school->EarExaminationCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="ExaminationNasal"><?php echo e($school->ExaminationNasalCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="asses"><?php echo e($school->assesCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="ExamineTonsile"><?php echo e($school->ExamineTonsileCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="NeckSweling"><?php echo e($school->NeckSwelingCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="ChestDeformaty"><?php echo e($school->ChestDeformatyCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="CardiacAuscultation"><?php echo e($school->CardiacAuscultationCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="jointMotion"><?php echo e($school->jointMotionCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="side_to_side_curvature"><?php echo e($school->side_to_side_curvatureCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="footOrToe"><?php echo e($school->footOrToeCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="Allergies"><?php echo e($school->AllergiesCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="bmiresult"><?php echo e($school->bmiresultCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="anemia"><?php echo e($school->anemiaCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="ColorVision"><?php echo e($school->ColorVisionCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="caries"><?php echo e($school->cariesCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="Breath"><?php echo e($school->BreathCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="DiscussHygiene"><?php echo e($school->DiscussHygieneCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="Uniform"><?php echo e($school->UniformCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="HairProblem"><?php echo e($school->HairProblemCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="EarShape"><?php echo e($school->EarShapeCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="RinnerWeber"><?php echo e($school->RinnerWeberCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="potensyTest"><?php echo e($school->potensyTestCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="SpeechDev"><?php echo e($school->SpeechDevCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="LungAuscultation"><?php echo e($school->LungAuscultationCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="ScarsMasses"><?php echo e($school->ScarsMassesCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="SpinalCurvature"><?php echo e($school->SpinalCurvatureCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="Epi"><?php echo e($school->EpiCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="DiscomfortDuringUrination"><?php echo e($school->DiscomfortDuringUrinationCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="MenstrualAbnormality"><?php echo e($school->MenstrualAbnormalityCount); ?></button></td>
                      
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="lifestyle"><?php echo e($school->lifestyleCount); ?></button></td>
                        <td> <button class="counts btn btn-primary" data-school="<?php echo e($school->id); ?>" data-finding="addiction"><?php echo e($school->addictionCount); ?></button></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo e($results->links()); ?>

        </div>
    </div>
    <!-- Modal Structure -->
    <div class="modal fade" id="dataModal" tabindex="-1" role="dialog" aria-labelledby="dataModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="dataModalLabel">Data for Findings</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="datatable-loader" style="display:none;text-align:center;margin-bottom:10px;">
                        <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading results...
                    </div>
                    <table id="datatable" class="table table-bordered table-striped">
                         <thead>
                            <tr>
                                <th>System Id</th>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Phone Number</th>
                                <th>Reportable</th>
                                <th>Result By</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
                <div class="modal-footer">
                     <button type="button" class="btn btn-success" id="exportCsvBtn">Export CSV</button>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>



<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdn.datatables.net/fixedcolumns/4.3.0/js/dataTables.fixedColumns.min.js"></script>

<script>
    $(document).ready(function() {
        $('#findingreport-table').DataTable({
            searching: false,
            fixedColumns: {
                leftColumns: 3 // pehle 2 columns freeze
            }
        });

        

        $(document).on('click', '#exportCsvBtn', function() {
            let csv = [];
            let rows = document.querySelectorAll("#datatable tr");

            for (let i = 0; i < rows.length; i++) {
                let row = [], cols = rows[i].querySelectorAll("td, th");
                for (let j = 0; j < cols.length; j++)
                    row.push('"' + cols[j].innerText.replace(/"/g, '""') + '"');
                csv.push(row.join(","));
            }

            // Download CSV
            let csvFile = new Blob([csv.join("\n")], { type: "text/csv" });
            let downloadLink = document.createElement("a");
            downloadLink.download = "findings_data.csv";
            downloadLink.href = window.URL.createObjectURL(csvFile);
            downloadLink.style.display = "none";
            document.body.appendChild(downloadLink);
            downloadLink.click();
        });

        $(document).on('click', '.counts', function() {
            var schoolId = $(this).data('school');
            var finding = $(this).data('finding');
            // Show loader
            $('#datatable-loader').show();
            $('#dataModal').modal('show');
            // Clear previous data
            $('#datatable tbody').empty();
            //var studentFindingBaseUrl = "<?php echo e(url('student-finding')); ?>/";
            var studentFindingBaseUrl = "https://cphs.biopharmainfo.net/Medical_Detail/";
            $.ajax({
                url: "<?php echo e(route('getReportableFindingsBySchool')); ?>",
                type: 'POST',
                data: {
                    school_id: schoolId,
                    finding: finding,
                    _token: '<?php echo e(csrf_token()); ?>',
                    start_date: $('#start_date').val(),
                    end_date: $('#end_date').val()
                },
                success: function(response) {
                    $('#datatable-loader').hide();
                    if(response.data && response.data.length > 0) {
                        response.data.forEach(function(row) {
                            $('#datatable tbody').append('<tr><td>' + row.id + '</td><td><a href="' + studentFindingBaseUrl + row.id + '" class="student-link" target="_blank">' + row.name + '</a></td><td>' + row.lname + '</td><td>' + row.phone + '</td><td>' + row.result + '</td><td>' + (row.result_by ?? '') + '</td></tr>');
                        });
                    } else {
                        $('#datatable tbody').append('<tr><td colspan="5">No data found</td></tr>');
                    }
                },
                error: function() {
                    $('#datatable-loader').hide();
                    $('#datatable tbody').append('<tr><td colspan="5">Error loading data</td></tr>');
                }
            });
        });
    });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rehman/public_html/cphs/resources/views/admin/reportable_findings.blade.php ENDPATH**/ ?>