<?php $__env->startSection('content'); ?>
    <style>
        @media (min-width:992px) {

            .mdk-drawer-layout .container,
            .mdk-drawer-layout .container-fluid,
            .mdk-drawer-layout .container-lg,
            .mdk-drawer-layout .container-md,
            .mdk-drawer-layout .container-sm,
            .mdk-drawer-layout .container-xl {
                max-width: 1440px;
            }
        }





        .bg_secondary {
            background-color: #e7e7e7 !important;
        }

        .form-group h5 {
            border-bottom: 1px solid;
            width: fit-content;
        }

        select[disabled] {
            background-color: #e9ecef;
            /* Light gray background to indicate disabled state */
            color: #6c757d;
            /* Gray text color */
            cursor: not-allowed;
            /* Change cursor to indicate disabled state */
        }


        select:disabled {
            appearance: none;
            /* Removes the default arrow in most browsers */
            -webkit-appearance: none;
            /* For Safari and Chrome */
            -moz-appearance: none;
            /* For Firefox */
            background: #e9ecef;
            /* Optional: to match default disabled background */
            pointer-events: none;
            /* Prevent interactions */
            position: relative;
        }

        select:disabled::-ms-expand {
            display: none;
            /* For Internet Explorer */
        }

        .box_style {
            box-shadow: 0 0 20px #0002;
            padding: 2.5rem;
            border-radius: 1.5rem;
            margin-bottom: 2rem;
        }
    </style>
    <div class="pt-32pt">
        <div class="container page__container d-flex flex-column flex-md-row align-items-center text-center text-sm-left">
            <div class="flex d-flex flex-column flex-sm-row align-items-center mb-24pt mb-md-0">

                <div class="mb-24pt mb-sm-0 mr-sm-24pt">
                    <h2 class="mb-0">
                        Screening Detail
                    </h2>

                    <ol class="breadcrumb p-0 m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard.index')); ?>">Home</a></li>

                        <li class="breadcrumb-item active">

                            Detail

                        </li>

                    </ol>

                </div>
            </div>

        </div>
    </div>

    <!-- Page Content -->

    <div class="container page__container page__container page-section">

        
        <div class="page-separator">
            <div class="page-separator__text">Detail</div>
        </div>
        <div class="col-md-12">

            <a href="<?php echo e(route('download.pdf', ['id' => $form_id])); ?>" class="btn btn-primary">Download PDF</a>


            <div class="table-responsive">
                <div class="container-fluid mt-4">
                    <div class="row">
                        <div class="row rounded py-3">
                            <div class="col-12">
                                <div class="data_heading">
                                    <h3>Bio Data</h3>
                                </div>
                            </div>
                            <div class="col-12 box_style">
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>Name : <?php echo e($details['name']); ?></h5>
                                            
                                        </div>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>Date Of Birth : <?php echo e($details['dob']); ?></h5>
                                            <input type="hidden" class="form-control" id="dob" name="dob"
                                                value="<?php echo e($details['dob']); ?>" disabled>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>Age : </h5>
                                            <input type="text" class="form-control" id="age" name="age"
                                                value="<?php echo e($details['age']); ?>" disabled>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">


                                            <?php
                                            $classLabels = [
                                                "0" => "Play group",
                                                "00" => "KG-1",
                                                "000" => "KG-2"
                                            ];
                                       ?>
                                


                                        <h5>Class : <?php echo e($classLabels[$details['class']] ?? $details['class']); ?></h5>

                                        
                                            
                                            <input type="hidden" class="form-control" id="class" name="class"
                                                value="<?php echo e($details['class']); ?>" disabled>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>GR Number : <?php echo e($details['gr_number']); ?></h5>
                                            <input type="hidden" class="form-control" id="gr_number" name="gr_number"
                                            value="<?php echo e($details['gr_number']); ?>" disabled>
                                        </div>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>MR Number : <?php echo e($details['mrr']); ?></h5>
                                            
                                        </div>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>Guardian Name : <?php echo e($details['guardianname']); ?></h5>
                                            
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <h5>Address : <?php echo e($details['address']); ?></h5>
                                        
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>Blood Group : <?php echo e($details['blood_group']); ?></h5>
                                            
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <h5>Gender : <?php echo e($details['gender']); ?></h5>

                                            
                                            <input type="hidden" name="gender" id="gender" class="form-control"
                                                value="<?php echo e($details['gender']); ?>" disabled>
                                        </div>
                                    </div>

                                    
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="Medical_condition">Any Known Medical Condition</label>
                                            <input type="text" class="form-control" id="Any_Known_Medical_Condition"
                                                name="Any_Known_Medical_Condition"
                                                value="<?php echo e($details['any_known_medical_condition']); ?>" disabled>
                                        </div>
                                    </div>




                                    <div class="form-roup col-md-12">
                                        <div class="form-group">
                                            <label for="comment">Comment/Findings</label><br>
                                            <input type="text" name="bio_data_comment" id="bio_data_comment"
                                                class="form-control" value="<?php echo e($details['bio_data_comment']); ?>" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Vitals/BMI</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group height">
                                        <div class="group-form">
                                            <label for="height" class="width-100">Question No.1: Height :cm(s)</label>
                                            <input type="text" class="form-control" id="height"
                                                name="Question_No_1_Weight" value="<?php echo e($details['question_no_1_height']); ?>"
                                                disabled>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">

                                    <div class="form-group weight">
                                        <div class="group-form">
                                            <label for="weight" class="w-100">Question No.2: Weight :kg(s)
                                                <input type="text" class="form-control" id="weight"
                                                    name="Question_No_2_Weight"
                                                    value="<?php echo e($details['question_no_2_weight']); ?>" disabled>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="bmi">Question No.3: BMI (Red field means abnomality )</label>
                                        <input type="text" class="form-control" id="bmi"
                                            name="Question_No_3_BMI" value="<?php echo e($details['question_no_3_bmi']); ?>"
                                            disabled>

                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="temp">Question No.4: Body Temperature</label>
                                        <input type="text" class="form-control" id="temp"
                                            name="Question_No_4_Body_Temperature"
                                            value="<?php echo e($details['question_no_4_body_temperature']); ?>" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="blood">Question No.5: Blood Pressure (Systolic) (Red field means
                                            abnomality )</label>
                                        <span id="Blood_Pressure_Systolic"></span>
                                        <input type="text" class="form-control"
                                            id="Question_No_6_Blood_Pressure_Systolic"
                                            name="Question_No_5_Blood_Pressure_Systolic"
                                            value="<?php echo e($details['question_no_5_blood_pressure_systolic']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="blood">Question No.6: Blood Pressure (Diastolic) (Red field means
                                            abnomality )</label>
                                        <span id="Blood_Pressure_Diastolic"></span>
                                        <input type="text" class="form-control"
                                            id="Question_No_6_Blood_Pressure_Diastolic"
                                            name="Question_No_6_Blood_Pressure_Diastolic"
                                            value="<?php echo e($details['question_no_6_blood_pressure_diastolic']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="pulse">Question No.7: Pulse (Red field means abnomality )</label>
                                        <input type="text" class="form-control" id="Question_No_7_Pulse"
                                            name="Question_No_7_Pulse" value="<?php echo e($details['question_no_7_pulse']); ?>"
                                            disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="comment">Comment/Findings</label><br>
                                        <input type="text" name="vitals_bmi_comment" id="comment"
                                            class="form-control" value="<?php echo e($details['vitals_bmi_comment']); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>General Apperance</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="field2">Question No.8: Normal Posture/Gait</label><br>
                                        <input type="text" name="Question_No_8_Normal_Posture_Gait" id="Posture"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_8_normal_posture_gait']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Mentalstatus">Question No.9: Mental Status</label><br>
                                        <input type="text" name="Question_No_9_Mental_Status" id="Mentalstatus"
                                            class="form-control" value="<?php echo e($details['question_no_9_mental_status']); ?>"
                                            disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="jaundice">Question No.10: Look For jaundice</label><br>
                                        <input type="text" name="Question_No_10_Look_For_jaundice" id="jaundice"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_10_look_for_jaundice']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="anemia">Question No.11: Look For anemia</label><br>
                                        <input type="text" name="Question_No_11_Look_For_anemia" id="anemia"
                                            class="form-control" value="<?php echo e($details['question_no_11_look_for_anemia']); ?>"
                                            disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="clubbing">Question No.12: Look For Clubbing</label><br>
                                        <input type="text" name="Question_No_12_Look_For_Clubbing" id="clubbing"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_12_look_for_clubbing']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="cyanosis">Question No.13: Look for Cyanosis</label><br>
                                        <input type="text" name="Question_No_13_Look_for_Cyanosis" id="cyanosis"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_13_look_for_cyanosis']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="skin">Question No.14: Skin</label><br>
                                        <input type="text" name="Question_No_14_Skin" id="skin"
                                            class="form-control" value="<?php echo e($details['question_no_14_skin']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="breath">Question No.15: Breath</label><br>
                                        <input type="text" name="Question_No_15_Breath" id="breath"
                                            class="form-control" value="<?php echo e($details['question_no_15_breath']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="comment">Comment/Findings</label><br>
                                        <input type="text" name="general_apperance_comment" id="comment"
                                            class="form-control" value="<?php echo e($details['general_apperance_comment']); ?>"
                                            disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Inspect Hygiene </h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Nails">Question No.16: Nails</label><br>
                                        <input type="text" name="Question_No_16_Nails" id="Nails"
                                            class="form-control" value="<?php echo e($details['question_no_16_nails']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Uniform-or-shoes">Question No.17: Uniform or shoes</label><br>
                                        <input type="text" name="Question_No_17_Uniform_or_shoes" id="Uniform-or-shoes" class="form-control" value="<?php echo e($details['question_no_17_uniform_or_shoes']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Lice/nits">Question No.18: Lice/nits</label><br>
                                        <input type="text" name="Question_No_18_Lice_nits" id="Lice_nits"
                                            class="form-control" value="<?php echo e($details['question_no_18_lice_nits']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="field2">Question No.19: Discuss hygiene routines and practices.</label><br>
                                        <input type="text" name="Question_No_19_Discuss_hygiene_routines_and_practices" id="field2" class="form-control" value="<?php echo e($details['question_no_19_discuss_hygiene_routines_and_practices']); ?>" disabled>

                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="comment">Comment/Findings</label><br>
                                        <input type="text" name="inspect_hygiene_comment" id="comment"
                                            class="form-control" value="<?php echo e($details['inspect_hygiene_comment']); ?>"
                                            disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Head and Neck examination</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="hair_and_scalp">Question No:20 Hair and Scalp</label><br>
                                        <input type="text" name="Question_No_20_Hair_and_Scalp" id="hair_and_scalp"
                                            class="form-control" value="<?php echo e($details['question_no_20_hair_and_scalp']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_21_Any_Hair_Problem">Question No.21: Any Hair
                                            Problem</label><br>
                                        <input type="text" name="Question_No_21_Any_Hair_Problem"
                                            id="Question_No_21_Any_Hair_Problem" class="form-control"
                                            value="<?php echo e($details['question_no_21_any_hair_problem']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_22_Sclap">Question No.22: Scalp</label><br>
                                        <input type="text" name="Question_No_22_Sclap" id="Question_No_22_Sclap"
                                            class="form-control" value="<?php echo e($details['question_no_22_sclap']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_23_Hair_distribution">Question No.23: Hair
                                            distribution</label><br>
                                        <input type="text" name="Question_No_23_Hair_distribution"
                                            id="Question_No_23_Hair_distribution" class="form-control"
                                            value="<?php echo e($details['question_no_23_hair_distribution']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="head_and_neck_examination_comment">Comment/Findings</label><br>
                                        <input type="text" name="head_and_neck_examination_comment"
                                            id="head_and_neck_examination_comment" class="form-control"
                                            value="<?php echo e($details['head_and_neck_examination_comment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Eye:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                               <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="normal_ocular_alignment">Question No.24: Visual acuity using Snellen’s
                                                chart</label><br>
                                            <input type="text" id="Question_No_24_Visual_acuity_using_Snellen’s_chart"
                                                name="Question_No_24_Visual_acuity_using_Snellen’s_chart" class="form-control"
                                                value="<?php echo e($details['question_no_24_visual_acuity_using_snellens_chart']); ?>"
                                                disabled>
                                        </div>
                                    </div> 
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_25_Normal_ocular_alignment">Question No.25: Normal ocular
                                            alignment</label><br>
                                        <input type="text" id="Question_No_25_Normal_ocular_alignment"
                                            name="Question_No_25_Normal_ocular_alignment" class="form-control"
                                            value="<?php echo e($details['question_no_25_normal_ocular_alignment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>

                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_26_Normal_eye_inspection">Question No.26: Normal eye
                                            inspection</label><br>
                                        <input type="text" id="Question_No_26_Normal_eye_inspection"
                                            name="Question_No_26_Normal_eye_inspection" class="form-control"
                                            value="<?php echo e($details['question_no_26_normal_eye_inspection']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="Question_No_27_Normal_Color_vision">Question No.27: Normal Color
                                                vision</label><br>
                                            <input type="text" id="Question_No_27_Normal_Color_vision"
                                                name="Question_No_27_Normal_Color_vision" class="form-control"
                                                value="<?php echo e($details['question_no_27_normal_color_vision']); ?>" disabled>
                                        </div>
                                    </div>
                            </div>
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_28_Nystagmus">Question No.28: Nystagmus</label><br>
                                        <input type="text" id="Question_No_28_Nystagmus"
                                            name="Question_No_28_Nystagmus" class="form-control"
                                            value="<?php echo e($details['question_no_28_nystagmus']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="eye_comment">Comment/Findings</label><br>
                                        <input type="text" name="eye_comment" id="eye_comment" class="form-control"
                                            value="<?php echo e($details['eye_comment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Ears:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_29_Normal_ears_shape_and_position">Question No.29: Normal
                                            ears shape and position</label><br>
                                        <input type="text" name="Question_No_29_Normal_ears_shape_and_position"
                                            id="Question_No_29_Normal_ears_shape_and_position" class="form-control"
                                            value="<?php echo e($details['question_no_29_normal_ears_shape_and_position']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Right_ear">Question No.30: Ear examination</label><br>
                                        <input type="text" name="Question_No_30_Ear_examination" id="Right_ear"
                                            class="form-control" value="<?php echo e($details['question_no_30_ear_examination']); ?>"
                                            disabled>

                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_31_Conclusion_of_hearing">Question No.31: Conclusion of
                                            hearing test with Rinner and
                                            Weber</label><br>
                                        <input type="text" name="Question_No_31_Conclusion_of_hearing"
                                            id="Question_No_31_Conclusion_of_hearing" class="form-control"
                                            value="<?php echo e($details['question_no_31_conclusion_of_hearing_test_with_rinner_and_weber']); ?>"
                                            disabled>

                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="ears_comment">Comment/Findings</label><br>
                                        <input type="text" name="ears_comment" id="ears_comment" class="form-control"
                                            value="<?php echo e($details['ears_comment']); ?>" disabled>
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Nose:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row align-items-end">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_32_External_inasal_examinaton">Question No.32:External
                                            nasal examinaton</label><br>
                                        <input type="text" name="Question_No_32_External_inasal_examinaton"
                                            id="Question_No_32_External_inasal_examinaton" class="form-control"
                                            value="<?php echo e($details['question_no_32_external_nasal_examinaton']); ?>" disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_33_perform">Question No.33:perform a nasal patency test
                                            [which involves gently closing one nostril at a time to assess the patient's
                                            ability to breathe through each nostril]</label><br>
                                        <input type="text" name="Question_No_33_perform" id="Question_No_33_perform"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_33_perform_a_nasal_patency']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="nose_comment">Comment/Findings</label><br>
                                        <input type="text" name="nose_comment" id="nose_comment" class="form-control"
                                            value="<?php echo e($details['nose_comment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Oral:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_34_Assess_gingiva">Question No.34: Assess
                                            gingiva</label><br>
                                        <input type="text" name="Question_No_34_Assess_gingiva"
                                            id="Question_No_34_Assess_gingiva" class="form-control"
                                            value="<?php echo e($details['question_no_34_assess_gingiva']); ?>" disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_35_Are_there_dental_caries">Question No.35: Are there
                                            dental caries</label><br>
                                        <input type="text" name="Question_No_35_Are_there_dental_caries"
                                            id="Question_No_35_Are_there_dental_caries" class="form-control"
                                            value="<?php echo e($details['question_no_35_are_there_dental_caries']); ?>" disabled>

                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="oral_comment">Comment/Findings</label><br>
                                        <input type="text" name="oral_comment" id="oral_comment" class="form-control"
                                            value="<?php echo e($details['oral_comment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Throat:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_36_Examine_tonsils">Question No.36: Examine tonsils</label>
                                        <input type="text" name="Question_No_36_Examine_tonsils"
                                            id="Question_No_36_Examine_tonsils" class="form-control"
                                            value="<?php echo e($details['question_no_36_examine_tonsils']); ?>" disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_37_Normal_Speech_development">Question No.37: Normal Speech
                                            development</label><br>
                                        <input type="text" name="Question_No_37_Normal_Speech_development"
                                            id="Question_No_37_Normal_Speech_development" class="form-control"
                                            value="<?php echo e($details['question_no_37_normal_speech_development']); ?>" disabled>

                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="any_neck_swelling">Question No.38:Any Neck swelling </label><br>
                                        <input type="text" name="any_neck_swelling" id="any_neck_swelling"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_38_any_neck_swelling']); ?>" disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="lymph_node">Question No.39: Examine lymph node</label><br>
                                        <input type="text" name="lymph_node" id="lymph_node" class="form-control"
                                            value="<?php echo e($details['question_no_39_examine_lymph_node']); ?>" disabled>

                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Specify_lymph_node">Specify lymph node</label><br>
                                        <input type="text" name="Specify_lymph_node" id="Specify_lymph_node"
                                            class="form-control" value="<?php echo e($details['specify_lymph_node']); ?>" disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="any_neck_swelling">Specify Any Neck swelling</label><br>
                                        <input type="text" name="any_neck_swelling" id="any_neck_swelling"
                                            class="form-control" value="<?php echo e($details['specify_any_neck_swelling']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="throat_comment">Comment/Findings</label><br>
                                        <input type="text" name="throat_comment" id="throat_comment"
                                            class="form-control" value="<?php echo e($details['throat_comment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Chest:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_40_Any_visible_chest_deformity">Question No.40 Any visible
                                            chest deformity</label><br>
                                        <input type="text" name="Question_No_40_Any_visible_chest_deformity"
                                            id="Question_No_40_Any_visible_chest_deformity" class="form-control"
                                            value="<?php echo e($details['question_no_40_any_visible_chest_deformity']); ?>" disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_41_Lung_Auscultation">Question No.41 Lung
                                            Auscultation</label><br>
                                        <input type="text" name="Question_No_41_Lung_Auscultation"
                                            id="Question_No_41_Lung_Auscultation" class="form-control"
                                            value="<?php echo e($details['question_no_41_lung_auscultation']); ?>" disabled>
                                    </div>
                                </div>



                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_42_Cardiac_Auscultation">Question No.42: Cardiac
                                            Auscultation</label><br>
                                        <input type="text" name="Question_No_42_Cardiac_Auscultation"
                                            id="Question_No_42_Cardiac_Auscultation" class="form-control"
                                            value="<?php echo e($details['question_no_42_cardiac_auscultation']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="chest_comment">Comment/Findings</label><br>
                                        <input type="text" name="chest_comment" id="chest_comment"
                                            class="form-control" value="<?php echo e($details['chest_comment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Abdomen:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-group">
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label for="distention_scar_mass">
                                            Question No.43: Did you observe any distension, scars, or masses on the child's
                                            abdomen?</label><br>
                                        <input type="text" name="distention_scar_mass" id="distention_scar_mass"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_43_did_you_observe_any_distension_scars_or_masses_on_the_childs_abdomen']); ?>"
                                            disabled>
                                    </div>
                                    <div class="form-group col-md-12">
                                            <label for="any_history_of_abdominal_pain">Question No.44 Any history of abdominal
                                                Pain</label><br>
                                            <input type="text" name="any_history_of_abdominal_pain"
                                                id="any_history_of_abdominal_pain" class="form-control"
                                                value="<?php echo e($details['question_no_44_any_history_of_abdominal_pain']); ?>"
                                                disabled>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <div class="form-group">
                                                <label for="any_history_of_abdominal_pain_specify">Specify Abdominal
                                                    Pain</label><br>
                                                <input type="text" name="any_history_of_abdominal_pain_specify"
                                                    id="any_history_of_abdominal_pain_specify" class="form-control"
                                                    value="<?php echo e($details['any_history_of_abdominal_pain_specify']); ?>" disabled>
                                            </div>
                                        </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="abdomen_comment">Comment/Findings</label><br>
                                            <input type="text" name="abdomen_comment" id="abdomen_comment"
                                                class="form-control" value="<?php echo e($details['abdomen_comment']); ?>" disabled>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Musculoskeletal</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="limitations_range_motion">Question No.45: Did you observe any
                                            limitations in the child's range of
                                            joint motion during your examination?*</label><br>
                                        <input type="text" name="limitations_range_motion"
                                            id="limitations_range_motion" class="form-control"
                                            value="<?php echo e($details['question_no_45_did_you_observe_any_limitations_in_the_childs_range_of_joint_motion_during_your_examination']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Specify_limitations_in_the_child">Specify limitations in the child's
                                            range of joint motion during
                                            your examination?*</label><br>
                                        <input type="text" name="Specify_limitations_in_the_child"
                                            id="Specify_limitations_in_the_child" class="form-control"
                                            value="<?php echo e($details['specify_limitations_in_the_childs_range_of_joint_motion_during_your_examination']); ?>"
                                            disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="spinal_curvature_assessment">Question No.46: Spinal curvature
                                            assessment (tick positive finding) </label><br>
                                        <input type="text" name="spinal_curvature_assessment"
                                            id="spinal_curvature_assessment" class="form-control"
                                            value="<?php echo e($details['question_no_46_spinal_curvature_assessment_tick_positive_finding']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="curvature_spine_resembling">Question No.47: side-to-side curvature in
                                            the spine resembling </label><br>
                                        <input type="text" name="curvature_spine_resembling"
                                            id="curvature_spine_resembling" class="form-control"
                                            value="<?php echo e($details['question_no_47_side-to-side_curvature_in_the_spine_resembling']); ?>"
                                            disabled>
                                    </div>
                                </div>


                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="adams_forward_bend_test">Question No.48: Adams forward bend
                                            test</label><br>
                                        <input type="text" name="adams_forward_bend_test" id="adams_forward_bend_test"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_48_adams_forward_bend_test']); ?>" disabled>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="foot_or_toe_abnormalities">Question No.49: Any foot or toe
                                            abnormalities</label><br>
                                        <input type="text" name="foot_or_toe_abnormalities"
                                            id="foot_or_toe_abnormalities" class="form-control"
                                            value="<?php echo e($details['question_no_49_any_foot_or_toe_abnormalities']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="musculoskeletal_comment">Comment/Findings</label><br>
                                        <input type="text" name="musculoskeletal_comment" id="musculoskeletal_comment"
                                            class="form-control" value="<?php echo e($details['musculoskeletal_comment']); ?>"
                                            disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Vaccination:</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Question_No_50_Have_EPI_immunization_card">Question No.50: Have EPI
                                            immunization card?</label><br>
                                        <input type="text" name="Question_No_50_Have_EPI_immunization_card"
                                            id="Question_No_50_Have_EPI_immunization_card" class="form-control"
                                            value="<?php echo e($details['question_no_50_have_epi_immunization_card']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="Reason_of_not_being_vaccinated">Reason of not being
                                            vaccinated</label><br>
                                        <input type="text" name="Reason_of_not_being_vaccinated"
                                            id="Reason_of_not_being_vaccinated" class="form-control"
                                            value="<?php echo e($details['reason_of_not_being_vaccinated']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="BCG_1_dose">Question No.50: Mark all the vaccinations that are
                                            completed</label><br>
                                        <input type="text" name="BCG_1_dose" id="BCG_1_dose" class="form-control"
                                            value="<?php echo e($details['BCG_1_dose']); ?>, <?php echo e($details['OPV_4_dose']); ?>, <?php echo e($details['Pentavalent_vaccine_DTP']); ?>, <?php echo e($details['rota']); ?>, <?php echo e($details['measles']); ?>, <?php echo e($details['never_had_any_vaccination']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12">
                                    <div class="form-group">
                                        <label for="vaccination_comment">Comment/Findings</label><br>
                                        <input type="text" name="vaccination_comment" id="vaccination_comment"
                                            class="form-control" value="<?php echo e($details['vaccination_comment']); ?>" disabled>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-12">
                                <div class="data_heading">
                                    <h3>Miscellaneous</h3>
                                </div>
                            </div> 
                       <div class="col-12 box_style">
                                <div class="form-row">
                                    <div class="form-group col-md-12 ">
                                        <label for="do_you_have_any_Allergies">Question No.55:Do you have any
                                            Allergies</label><br>
                                        <input type="text" name="do_you_have_any_Allergies" id="do_you_have_any_Allergies"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_55_do_you_have_any_allergies']); ?>" disabled>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label for="Do_you_have_any_allergies_specify">Specify Allergies</label><br>
                                        <input type="text" name="Do_you_have_any_allergies_specify"
                                            id="Do_you_have_any_allergies_specify" class="form-control"
                                            value="<?php echo e($details['do_you_have_any_allergies_specify']); ?>" disabled>
                                    </div>

                                    

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="discomfort_during_urination">Question No.57:Inquire about urinary
                                                frequency, urgency, and any pain
                                                or discomfort during urination.</label><br>
                                            <input type="text" name="discomfort_during_urination"
                                                id="discomfort_during_urination" class="form-control"
                                                value="<?php echo e($details['question_no_57_inquire_about_urinary_frequency_urgency_and_any_pain_or_discomfort_during_urination']); ?>"
                                                disabled>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="any_menstrual_abnormality">Question No.58:Any menstrual
                                                abnormality.</label><br>
                                            <input type="text" name="any_menstrual_abnormality"
                                                id="any_menstrual_abnormality" class="form-control"
                                                value="<?php echo e($details['questionno_58_any_menstrual_abnormality']); ?>" disabled>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="Any_menstrual_abnormality_specify">Specify Menstrual
                                                Abnormality</label><br>
                                            <input type="text" name="Any_menstrual_abnormality_specify"
                                                id="Any_menstrual_abnormality_specify" class="form-control"
                                                value="<?php echo e($details['any_menstrual_abnormality_specify']); ?>" disabled>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="miscellaneous_comment">Comment/Findings</label><br>
                                            <input type="text" name="miscellaneous_comment" id="miscellaneous_comment"
                                                class="form-control" value="<?php echo e($details['miscellaneous_comment']); ?>"
                                                disabled>
                                        </div>
                                    </div>
                                </div>
                            </div> 
                        <div class="col-12">
                            <div class="data_heading">
                                <h3>Psychological</h3>
                            </div>
                        </div>
                        <div class="col-12 box_style">
                            <div class="form-row">
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="thought_patterns">Question No.59: <b>Thought Patterns:</b>How often do
                                            you experience negative or intrusive thoughts?</label><br>
                                        <input type="text" name="thought_patterns" id="thought_patterns"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_59_how_often_do_you_experience_negative_or_intrusive_thoughts']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                        <div class="form-group">
                                            <label for="self_esteem">Question No.60: <b>Self-Esteem:</b> How would you rate
                                                your overall self-esteem and self-confidence?</label><br>
                                            <input type="text" name="self_esteem" id="self_esteem" class="form-control"
                                                value="<?php echo e($details['question_no_60_how_would_you_rate_your_overall_self_esteem_and_self_confidence']); ?>"
                                                disabled>
                                        </div>
                                    </div> 
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="energy_levels">Question No.61: <b>Energy Levels:</b> How would you
                                            describe your energy levels throughout a typical day?</label><br>
                                        <input type="text" name="energy_levels" id="energy_levels"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_61_how_would_you_describe_your_energy_levels_throughout_a_typical_day']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="coping_strategies">Question No.62: <b>Coping Strategies:</b> When faced
                                            with challenges, what are your typical coping mechanisms?</label><br>
                                        <input type="text" name="coping_strategies" id="coping_strategies"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_62_when_faced_with_challenges_what_are_your_typical_coping_mechanisms']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="sleep_quality">Question No.63: <b>Sleep Quality:</b> How would you rate
                                            the quality of your sleep on average?</label><br>
                                        <input type="text" name="sleep_quality" id="sleep_quality"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_63_how_would_you_rate_the_quality_of_your_sleep_on_average']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="stress_levels">Question No.64: <b>Stress Levels:</b> How often have you
                                            felt overwhelmed or stressed in the last few weeks?</label><br>
                                        <input type="text" name="stress_levels" id="stress_levels"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_64_how_often_have_you_felt_overwhelmed_or_stressed_in_the_last_few_weeks']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="mood_assessment">Question No.65: <b>Mood Assessment:</b> How would you
                                            describe your overall mood during the day?</label><br>
                                        <input type="text" name="mood_assessment" id="mood_assessment"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_65_how_would_you_describe_your_overall_mood_during_the_day']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="family_relationships">Question No.66: <b>Family Relationships:</b> How
                                            would you describe the quality of your relationships with family
                                            members?</label><br>
                                        <input type="text" name="family_relationships" id="family_relationships"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_66_how_would_you_describe_the_quality_of_your_relationships_with_family_members']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="problem_solving_skills">Question No.67: <b>Problem-Solving Skills:</b>
                                            How well does you handle challenges and solve problems?</label><br>
                                        <input type="text" name="problem_solving_skills" id="problem_solving_skills"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_67_how_well_does_you_handle_challenges_and_solve_problems']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="sleep_patterns">Question No.68: <b>Sleep Patterns:</b> How many hours
                                            of sleep does you typically get on a school night?</label><br>
                                        <input type="text" name="sleep_patterns" id="sleep_patterns"
                                            class="form-control"
                                            value="<?php echo e($details['question_no_68_how_many_hours_of_sleep_does_you_typically_get_on_a_school_night']); ?>"
                                            disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="sleep_patterns">Question No.69: <b> followup required?:</b></label><br>
                                        <input type="text" name="sleep_patterns" id="sleep_patterns"
                                            class="form-control" value="<?php echo e($details['followup_required']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="sleep_patterns">Question No.70: <b>Referred By:</b></label><br>
                                        <input type="text" name="sleep_patterns" id="sleep_patterns"
                                            class="form-control" value="<?php echo e($details['referred_by']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="sleep_patterns">Question No.71: <b>Referred To:</b></label><br>
                                        <input type="text" name="sleep_patterns" id="sleep_patterns"
                                            class="form-control" value="<?php echo e($details['referred_to']); ?>" disabled>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="contact">Findings by Psychologist(Add/Edit)</label>
                                        <select class="form-control" id="PsychologistRefferedTo"
                                            name="PsychologistRefferedTo" required>
                                            <option value="">Select</option>
                                            <option value="Counseling Session Required"
                                                <?php echo e($details['PsychologistRefferedTo'] === 'Counseling Session Required' ? 'selected' : ''); ?>>
                                                Counseling Session Required</option>
                                            <option value="Adequate Functioning"
                                                <?php echo e($details['PsychologistRefferedTo'] === 'Adequate Functioning' ? 'selected' : ''); ?>>
                                                Adequate Functioning</option>
                                            <option value="Therapy Session Required"
                                                <?php echo e($details['PsychologistRefferedTo'] === 'Therapy Session Required' ? 'selected' : ''); ?>>
                                                Therapy Session Required</option>
                                            <option value="Catharsis Required"
                                                <?php echo e($details['PsychologistRefferedTo'] === 'Catharsis Required' ? 'selected' : ''); ?>>
                                                Catharsis Required</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="comment">Comment/Findings</label><br>
                                        <textarea name="psychological_comment" id="psychological_comment" class="form-control" disabled><?php echo e(str_replace("No.", "", $details['psychological_comment'])); ?></textarea>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 Psychological">
                                    <div class="form-group">
                                        <label for="comment">Findings by Psychologist(Comment)</label><br>
                                        <textarea name="findings_by_psychologist" id="findings_by_psychologist" class="form-control"><?php echo e($details['Psychologist_Findings']); ?></textarea>
                                    </div>
                                </div>
                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation1">Question: Restless or overactive?</label><br>
                                        <select class="form-control" id="observation1" name="observation1" disabled>
                                            <option value="1" <?php echo $details['observation1'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation1'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation1'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation1'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation2">Question: Excitable, Impulsive?</label><br>
                                        <select class="form-control" id="observation2" name="observation2" disabled>
                                            <option value="1" <?php echo $details['observation2'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation2'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation2'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation2'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation3">Question: Disturbs other children?</label><br>
                                        <select class="form-control" id="observation3" name="observation3" disabled>
                                            <option value="1" <?php echo $details['observation3'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation3'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation3'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation3'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation4">Question: Fails to finish things started-short attention
                                            span?</label><br>
                                        <select class="form-control" id="observation4" name="observation4" disabled>
                                            <option value="1" <?php echo $details['observation4'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation4'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation4'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation4'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation5">Question: Inattentive, easily distracted?</label><br>
                                        <select class="form-control" id="observation5" name="observation5" disabled>
                                            <option value="1" <?php echo $details['observation5'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation5'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation5'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation5'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation6">Question: Cries often and easily?</label><br>
                                        <select class="form-control" id="observation6" name="observation6" disabled>
                                            <option value="1" <?php echo $details['observation6'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation6'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation6'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation6'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation7">Question: Is your spelling poor?</label><br>
                                        <select class="form-control" id="observation7" name="observation7" disabled>
                                            <option value="1" <?php echo $details['observation7'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation7'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation7'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation7'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation8">Question: When writing down the date, do you often make
                                            mistakes?</label><br>
                                        <select class="form-control" id="observation8" name="observation8" disabled>
                                            <option value="1" <?php echo $details['observation8'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation8'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation8'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation8'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation9">Question: Do you find difficulty in telling left from
                                            right?</label><br>
                                        <select class="form-control" id="observation9" name="observation9" disabled>
                                            <option value="1" <?php echo $details['observation9'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation9'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation9'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation9'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group col-md-12 observation">
                                    <div class="form-group">
                                        <label for="observation10">Question: Do you mix up bus numbers like 35 and
                                            53?</label><br>
                                        <select class="form-control" id="observation10" name="observation10" disabled>
                                            <option value="1" <?php echo $details['observation10'] == '1' ? 'selected' : ''; ?>>Not At All</option>
                                            <option value="2" <?php echo $details['observation10'] == '2' ? 'selected' : ''; ?>>Just a Little</option>
                                            <option value="3" <?php echo $details['observation10'] == '3' ? 'selected' : ''; ?>>Pretty Much</option>
                                            <option value="4" <?php echo $details['observation10'] == '4' ? 'selected' : ''; ?>>Very Much</option>
                                        </select>
                                    </div>
                                </div>



                            </div>

                            <div class="col-12">
                                <div class="data_heading">
                                    <h3>Nutritionist</h3>
                                </div>
                            </div>

                            <div class="col-12 NutritionistCol">

                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="Question_No_60_How_would_you_describe_your_lifestyle">Question
                                                No.60:
                                                How would
                                                you describe your lifestyle?</label><br>
                                            <select class="form-control"
                                                id="Question_No_60_How_would_you_describe_your_lifestyle"
                                                name="Question_No_60_How_would_you_describe_your_lifestyle" required>


                                                <option value="">Select</option>
                                                <option value="Sedentary"
                                                    <?php echo e($details['Question_No_60_How_would_you_describe_your_lifestyle'] === 'Sedentary' ? 'selected' : ''); ?>>
                                                    Sedentary</option>


                                                <option value="Moderately"
                                                    <?php echo e($details['Question_No_60_How_would_you_describe_your_lifestyle'] === 'Moderately' ? 'selected' : ''); ?>>
                                                    Moderately</option>


                                                

                                                <option value="Active"
                                                    <?php echo e($details['Question_No_60_How_would_you_describe_your_lifestyle'] === 'Active' ? 'selected' : ''); ?>>
                                                    Active</option>

                                                

                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group col-md-12 bmi61">
                                        <div class="form-group">
                                            <label for="bmi61">Question No.61: BMI</label><br>
                                            <input type="text" name="bmi61" class="form-control" id="bmi61"
                                                placeholder="BMI" value="<?php echo e($details['bmi61']); ?>">
                                        </div>
                                    </div>
                                </div>


                                <div class="form-row">
                                    <div class="form-group col-md-12 muac" id="muac-container">
                                        <div class="form-group">
                                            <label for="muac">Question No.62: MUAC</label><br>
                                            <input type="text" name="muac" class="form-control" id="muac"
                                                placeholder="MUAC" value="<?php echo e($details['muac']); ?>">

                                        </div>
                                    </div>
                                    <div class="form-group col-md-12 Daily_Protien_requirement">
                                        <div class="form-group">
                                            <label for="Daily_Protien_requirement">Question No.63: Daily Protien
                                                requirement </label><br>

                                            <input type="text" name="Daily_Protien_requirement"
                                                class="form-control"
                                                value="<?php echo e($details['Daily_Protien_requirement']); ?>"
                                                id="Daily_Protien_requirement" placeholder="Daily Protien requirement">
                                        </div>
                                    </div>
                                </div>


                                <div class="form-row">
                                    <div class="form-group col-md-12 Daily_energy_requirement">
                                        <div class="form-group">
                                            <label for="Daily_energy_requirement">Question No.64: Daily Energy <br>
                                                requirement </label><br>

                                            <input type="text" name="Daily_energy_requirement" class="form-control"
                                                value="<?php echo e($details['Daily_energy_requirement']); ?>"
                                                id="Daily_energy_requirement" placeholder="Daily Energy requirement">






                                        </div>
                                    </div>
                                     <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label
                                                for="Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day">Question
                                                No.65: How many glasses of water/liquids do you consume in a day?</label><br>

                                            <select class="form-control"
                                                id="Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day"
                                                name="Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day"
                                                required>

                                                <option value="">Select</option>
                                                <option value="6-8" <?php if (isset($details['Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day']) && $details['Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day'] == '6-8') {
                                                    echo 'selected';
                                                } ?>>6-8</option>
                                                <option value="4-6" <?php if (isset($details['Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day']) && $details['Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day'] == '4-6') {
                                                    echo 'selected';
                                                } ?>>4-6</option>
                                                <option value="< 4" <?php if (isset($details['Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day']) && $details['Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day'] == '< 4') {
                                                    echo 'selected';
                                                } ?>>
                                                    < 4</option>
                                            </select>






                                        </div>
                                    </div> 
                                </div>

                                 <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label
                                                for="Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to">Question
                                                No.66: Does the child have any history of substances abuse or addiction
                                                to</label><br>




                                            <select class="form-control"
                                                id="Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to"
                                                name="Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to"
                                                required>
                                                <option value="">Select</option>
                                                <option value="Yes" <?php if (isset($details['Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to']) && $details['Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to'] == 'Yes') {
                                                    echo 'selected';
                                                } ?>>Yes</option>
                                                <option value="No" <?php if (isset($details['Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to']) && $details['Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to'] == 'No') {
                                                    echo 'selected';
                                                } ?>>No</option>
                                            </select>

                                        </div>
                                    </div>

                                    <div class="form-group col-md-12 d-none" id="addictionContainer">
                                        <div class="form-group">
                                            <label for="addiction">Please Specify</label><br>

                                            <select class="form-control mt-4" id="addiction" name="addiction" required>
                                                <option value="">Select</option>
                                                <option value="Smoking" <?php if (isset($details['addiction']) && $details['addiction'] == 'Smoking') {
                                                    echo 'selected';
                                                } ?>>Smoking</option>
                                                <option value="Alcohol" <?php if (isset($details['addiction']) && $details['addiction'] == 'Alcohol') {
                                                    echo 'selected';
                                                } ?>>Alcohol</option>
                                                <option value="Pan / Gutka / Chalia consumption" <?php if (isset($details['addiction']) && $details['addiction'] == 'Pan / Gutka / Chalia consumption') {
                                                    echo 'selected';
                                                } ?>>Pan /
                                                    Gutka / Chalia
                                                    consumption</option>
                                                <option value="Substance / Drugs abuse" <?php if (isset($details['addiction']) && $details['addiction'] == 'Substance / Drugs abuse') {
                                                    echo 'selected';
                                                } ?>>Substance / Drugs
                                                    abuse
                                                </option>
                                                <option value="gutka" <?php if (isset($details['addiction']) && $details['addiction'] == 'gutka') {
                                                    echo 'selected';
                                                } ?>>gutka</option>
                                                <option value="chalia" <?php if (isset($details['addiction']) && $details['addiction'] == 'chalia') {
                                                    echo 'selected';
                                                } ?>>chalia</option>
                                                <option value="substance" <?php if (isset($details['addiction']) && $details['addiction'] == 'substance') {
                                                    echo 'selected';
                                                } ?>>substance</option>
                                                <option value="drug abuse" <?php if (isset($details['addiction']) && $details['addiction'] == 'drug abuse') {
                                                    echo 'selected';
                                                } ?>>drug abuse</option>
                                                <option value="other" <?php if (isset($details['addiction']) && $details['addiction'] == 'other') {
                                                    echo 'selected';
                                                } ?>>other</option>
                                            </select>

                                        </div>
                                    </div>


                                    <div class="form-group col-md-12 d-none" id="otherAddictionContainer">
                                        <div class="form-group">
                                            <label for="other_addiction">Please Describe</label><br>

                                            <textarea class="form-control w-100" name="other_addiction" id="other_addiction" rows="3"><?php echo isset($details['other_addiction']) ? htmlspecialchars($details['other_addiction']) : ''; ?></textarea>

                                        </div>
                                    </div>


                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="food_allergies">Question No.67: Does the child suffer from any food
                                                intolerances/
                                                food allergies?</label><br>




                                            <select class="form-control" id="food_allergies" name="food_allergies" required>
                                                <option value="">Select</option>
                                                <option value="Yes" <?php if (isset($details['food_allergies']) && $details['food_allergies'] == 'Yes') {
                                                    echo 'selected';
                                                } ?>>Yes</option>
                                                <option value="No" <?php if (isset($details['food_allergies']) && $details['food_allergies'] == 'No') {
                                                    echo 'selected';
                                                } ?>>No</option>
                                            </select>

                                        </div>
                                    </div>
                                                    
                                    <div class="form-group col-md-12 d-none" id="food_allergiesContainer">
                                        <div class="form-group">
                                            <label for="other_addiction">Specify the foods</label><br>
                                            <textarea class="form-control" name="other_food_allergies" id="other_food_allergies" class="w-100" rows="3"></textarea> 
                                             

                                            <select name="other_food_allergies" id="other_food_allergies"
                                                class="form-control">
                                                <option value="Milk" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Milk' ? 'selected' : ''; ?>>Milk</option>
                                                <option value="Eggs" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Eggs' ? 'selected' : ''; ?>>Eggs</option>
                                                <option value="Peanuts" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Peanuts' ? 'selected' : ''; ?>>Peanuts</option>
                                                <option value="Tree nuts (e.g., almonds, walnuts, cashews)"
                                                    <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Tree nuts (e.g., almonds, walnuts, cashews)' ? 'selected' : ''; ?>>Tree nuts
                                                    (e.g., almonds, walnuts, cashews)</option>
                                                <option value="Almonds" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Almonds' ? 'selected' : ''; ?>>Almonds</option>
                                                <option value="Walnuts" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Walnuts' ? 'selected' : ''; ?>>Walnuts</option>
                                                <option value="Cashews" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Cashews' ? 'selected' : ''; ?>>Cashews</option>
                                                <option value="Fish (e.g., salmon, tuna)" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Fish (e.g., salmon, tuna)' ? 'selected' : ''; ?>>Fish (e.g.,
                                                    salmon, tuna)
                                                </option>
                                                <option value="Salmon" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Salmon' ? 'selected' : ''; ?>>Salmon</option>
                                                <option value="Tuna" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Tuna' ? 'selected' : ''; ?>>Tuna</option>
                                                <option value="Shellfish (e.g., shrimp, crab)" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Shellfish (e.g., shrimp, crab)' ? 'selected' : ''; ?>>Shellfish
                                                    (e.g.,
                                                    shrimp, crab)</option>
                                                <option value="Shrimp" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Shrimp' ? 'selected' : ''; ?>>Shrimp</option>
                                                <option value="Crab" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Crab' ? 'selected' : ''; ?>>Crab</option>
                                                <option value="Soy" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Soy' ? 'selected' : ''; ?>>Soy</option>
                                                <option value="Wheat" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Wheat' ? 'selected' : ''; ?>>Wheat</option>
                                                
                                                <option value="Others" <?php echo isset($details['other_food_allergies']) && $details['other_food_allergies'] == 'Others' ? 'selected' : ''; ?>>Others</option>
                                            </select>



                                        </div>
                                    </div>




                                    
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="meals">Question No.69: How many meals (breakfast / lunch / dinner)
                                                do you
                                                consume in a day?</label><br>

                                            <select class="form-control" id="meals" name="meals" required>
                                                <option value="">Select</option>
                                                <option value="1" <?php if (isset($details['meals']) && $details['meals'] == '1') {
                                                    echo 'selected';
                                                } ?>>1</option>
                                                <option value="2-3" <?php if (isset($details['meals']) && $details['meals'] == '2-3') {
                                                    echo 'selected';
                                                } ?>>2-3</option>
                                                <option value=">3" <?php if (isset($details['meals']) && $details['meals'] == '>3') {
                                                    echo 'selected';
                                                } ?>>>3</option>
                                            </select>


                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="food_items">Question No.70: How many packed items/foods (chips /
                                                biscuits sodas)
                                                do you consume in average in a day?</label><br>


                                            <select class="form-control" id="food_items" name="food_items" required>
                                                <option value="">Select</option>
                                                <option value="0-1" <?php if (isset($details['food_items']) && $details['food_items'] == '0-1') {
                                                    echo 'selected';
                                                } ?>>0-1</option>
                                                <option value="1-2" <?php if (isset($details['food_items']) && $details['food_items'] == '1-2') {
                                                    echo 'selected';
                                                } ?>>1-2</option>
                                                <option value="3 or more" <?php if (isset($details['food_items']) && $details['food_items'] == '3 or more') {
                                                    echo 'selected';
                                                } ?>>3 or more</option>
                                            </select>



                                        </div>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="fast_food">Question No.71: How frequently do you consume fast food on
                                                dineout on
                                                average in a week?</label><br>
                                            <select class="form-control" id="fast_food" name="fast_food" required>
                                                <option value="">Select</option>

                                                




                                                <option value="< 1" <?php if (isset($details['fast_food']) && $details['fast_food'] == '< 1') {
                                                    echo 'selected';
                                                } ?>>
                                                    < 1</option>

                                                <option value="1-2" <?php if (isset($details['fast_food']) && $details['fast_food'] == '1-2') {
                                                    echo 'selected';
                                                } ?>>1-2</option>




                                                <option value="3 or more" <?php if (isset($details['fast_food']) && $details['fast_food'] == '3 or more') {
                                                    echo 'selected';
                                                } ?>>3 or more</option>



                                            </select>

                                        </div>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="NutritionistComment">Comment</label><br>

                                            <textarea class="form-control w-100" name="NutritionistComment" id="NutritionistComment" rows="3"
                                                required><?php echo isset($details['NutritionistComment']) ? htmlspecialchars($details['NutritionistComment']) : ''; ?></textarea>

                                        </div>
                                    </div>

                                </div>


                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="Follow_up_Required">Follow-up Required</label>
                                            <select id="Follow_up_Required" name="Follow_up_Required"
                                                class="form-control" required>
                                                <option value="">Select</option>
                                                <option value="Yes" <?php if (isset($details['Follow_up_Required']) && $details['Follow_up_Required'] == 'Yes') {
                                                    echo 'selected';
                                                } ?>>Yes</option>
                                                <option value="No" <?php if (isset($details['Follow_up_Required']) && $details['Follow_up_Required'] == 'No') {
                                                    echo 'selected';
                                                } ?>>No</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-row d-none refer_to_form_row ">
                                 

                                    <div class="form-row d-none refer_to_form_row ">
                                        <div class="form-group col-md-12">
                                        <?php
                                            $rawReferTo = $details['refer_to'] ?? old('refer_to') ?? [];
                                            if (!is_array($rawReferTo)) {
                                                    $decoded = json_decode($rawReferTo, true);
                                                    if (is_array($decoded)) {
                                                        $referTo = $decoded;
                                                    } elseif (!is_null($rawReferTo)) {
                                                        $referTo = [$rawReferTo]; // Convert single string to array
                                                    } else {
                                                        $referTo = [];
                                                    }
                                                } else {
                                                    $referTo = $rawReferTo;
                                                }
                                     
                                            ?>
                                            <div class="form-group">
                                                <label for="refer_to">Refer To</label>
                                                <select id="refer_to" name="refer_to[]" class="form-control" multiple required>
                            <option value="1" <?php echo e(in_array('1', $referTo) ? 'selected' : ''); ?>>Psychologist</option>
                            <option value="2" <?php echo e(in_array('2', $referTo) ? 'selected' : ''); ?>>Nutritionist</option>
                            <option value="4" <?php echo e(in_array('4', $referTo) ? 'selected' : ''); ?>>External Specialists</option>
                            <option value="5" <?php echo e(in_array('5', $referTo) ? 'selected' : ''); ?>>General Physician</option>
                            </select>




                                            </div>
                                        </div>
                                    </div>


                                </div>

                               

                                   
                                <div class="form-row d-none" id="follow_up_show">

                                    <div class="form-group col-md-12">
                                        <div class="form-group">
                                            <label for="Reason_for_Follow_up">Reason for Follow-up</label>
                                            <input placeholder="Reason for Follow-up" name="Reason_for_Follow_up"
                                                id="Reason_for_Follow_up"
                                                value="<?php echo e($details['Reason_for_Follow_up']); ?>" class="form-control" />
                                        </div>
                                    </div>
                                   
                                    <div class="form-group col-md-6">
                                        <form id="followUpForm">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" value="<?php echo e($details['id']); ?>" name="entry_id"
                                                id="entryId">
                                            <div class="form-group">
                                                <label for="Follow_up_Date">Follow-up Date </label>
                                                <input type="date" placeholder="Follow-up Date"
                                                    name="follow_up_date" id="Follow_up_Date"
                                                    value="<?php echo e($details['Follow_up_Date']); ?>" class="form-control" />
                                            </div>
                                            <div class="form-group">
                                                
                                                <input type="checkbox" id="FollowUpCheck"
                                                    <?php echo e(!empty($details['Follow_up_Date']) ? 'checked' : ''); ?>> Submit Form
                                                on Check
                                            </div>
                                        </form>
                                    </div>
                                    <?php if($details['id'] >5540): ?>

                                    <div class="form-group col-md-6">
                                        <form id="followUpFormPhycologist">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" value="<?php echo e($details['id']); ?>" name="entry_idforPhycologist"
                                                id="entryIdforPhycologist">
                                            <div class="form-group">
                                                <label for="Follow_up_Date">Follow-up Date Phycologist</label>
                                                <input type="date" placeholder="Follow-up Date"
                                                    name="follow_up_dateforPhycologist" id="Follow_up_DateforPhycologist"
                                                    value="<?php echo e($details['Physician_Follow_up_Date']); ?>" class="form-control" />
                                            </div>
                                            <div class="form-group">
                                                
                                                <input type="checkbox" id="FollowUpCheckforPhycologist"
                                                    <?php echo e(!empty($details['Physician_Follow_up_Date']) ? 'checked' : ''); ?>> Submit Form
                                                on Check
                                            </div>
                                        </form>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <form id="followUpFormExternal">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" value="<?php echo e($details['id']); ?>" name="entry_idforExternal"
                                                id="entry_idforExternal">
                                            <div class="form-group">
                                                <label for="Follow_up_Date">Follow-up Date External Specialist </label>
                                                <input type="date" placeholder="Follow-up Date"
                                                    name="follow_up_dateforExternal" id="Follow_up_DateforExternal"
                                                    value="<?php echo e($details['externalspecialist_Follow_up_Date']); ?>" class="form-control" />
                                            </div>
                                            <div class="form-group">
                                                
                                                <input type="checkbox" id="FollowUpCheckforExternal"
                                                    <?php echo e(!empty($details['externalspecialist_Follow_up_Date']) ? 'checked' : ''); ?>> Submit Form
                                                on Check
                                            </div>
                                        </form>
                                    </div>


                                    <div class="form-group col-md-6">
                                        <form id="followUpFormPhysician">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" value="<?php echo e($details['id']); ?>" name="entry_idforgeneralphysician"
                                                id="entryIdforgeneralphysician">
                                            <div class="form-group">
                                                <label for="Follow_up_Date">Follow-up Date General Physician </label>
                                                <input type="date" placeholder="Follow-up Date"
                                                    name="follow_up_dateforgeneralphysician" id="Follow_up_Dateforgeneralphysician"
                                                    value="<?php echo e($details['generalphysician_Follow_up_Date']); ?>" class="form-control" />
                                            </div>
                                            <div class="form-group">
                                                
                                                <input type="checkbox" id="Follow_up_forgeneralphysician"
                                                    <?php echo e(!empty($details['generalphysician_Follow_up_Date']) ? 'checked' : ''); ?>> Submit Form
                                                on Check
                                            </div>
                                        </form>
                                    </div>
                                        <?php endif; ?>
                                </div>



                            </div>

                            


                            <div class="form-row align-items-center my-4" id="birth_5_wasting_girls">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="wasting_birth_to_5_girl">For Wasting criteria from Birth to 5 years
                                            Girls</label>
                                        <input type="text" name="wasting_birth_to_5_girl"
                                            id="wasting_birth_to_5_girl" class="form-control"
                                            value="<?php echo e($details['wasting_birth_to_5_girl']); ?>" />
                                    </div>
                                </div>

                            </div>

                            <div class="form-row align-items-center my-4 " id="birth_5_wasting_boys">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="wasting_birth_to_5_boy">For Wasting criteria from Birth to 5 years
                                            Boys</label>
                                        <input type="text" name="wasting_birth_to_5_boy"
                                            id="wasting_birth_to_5_boy" class="form-control"
                                            value="<?php echo e($details['wasting_birth_to_5_boy']); ?>" />
                                    </div>
                                </div>

                            </div>

                            <div class="form-row align-items-center my-4 " id="5_19_wasting_girls">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="wasting_5_to_19_girl">For children and adolescents(Girls) Wasting
                                            (Criteria 5-19)</label>
                                        <input type="text" name="wasting_5_to_19_girl" id="wasting_5_to_19_girl"
                                            class="form-control" value="<?php echo e($details['wasting_5_to_19_girl']); ?>" />
                                    </div>
                                </div>

                            </div>

                            <div class="form-row align-items-center my-4 " id="5_19_wasting_boys">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="wasting_5_to_19_boy">For children and adolescents(Boys) Wasting
                                            (Criteria 5-19)</label>
                                        <input type="text" name="wasting_5_to_19_boy" id="wasting_5_to_19_boy"
                                            class="form-control" value="<?php echo e($details['wasting_5_to_19_boy']); ?>" />
                                    </div>
                                </div>

                            </div>


                            <div class="form-row align-items-center my-4 " id="birth_2_stunting_girls">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="stunting_birth_to_2_girl">STUNTING CRITERIA: FOR BIRTH TO 2 YEARS
                                            Girls</label>
                                        <input type="text" name="stunting_birth_to_2_girl"
                                            id="stunting_birth_to_2_girl" class="form-control"
                                            value="<?php echo e($details['stunting_birth_to_2_girl']); ?>" />
                                    </div>
                                </div>

                            </div>

                            <div class="form-row align-items-center my-4 " id="birth_2_stunting_boys">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="stunting_birth_to_2_boy">STUNTING CRITERIA: FOR BIRTH TO 2 YEARS
                                            Boys</label>
                                        <input type="text" name="stunting_birth_to_2_boy"
                                            id="stunting_birth_to_2_boy" class="form-control"
                                            value="<?php echo e($details['stunting_birth_to_2_boy']); ?>" />
                                    </div>
                                </div>

                            </div>

                            <div class="form-row align-items-center my-4 " id="2_5_stunting_girls">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="stunting_2_5_girl">STUNTING CRITERIA: FOR 2 TO 5 YEARS Girls</label>
                                        <input type="text" name="stunting_2_5_girl" id="stunting_2_5_girl"
                                            class="form-control" value="<?php echo e($details['stunting_2_5_girl']); ?>" />
                                    </div>
                                </div>

                            </div>

                            <div class="form-row align-items-center my-4 " id="2_5_stunting_boys">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="stunting_2_5_boy">STUNTING CRITERIA: FOR 2 TO 5 YEARS Boys</label>
                                        <input type="text" name="stunting_2_5_boy" id="stunting_2_5_boy"
                                            class="form-control" value="<?php echo e($details['stunting_2_5_boy']); ?>" />
                                    </div>
                                </div>

                            </div>


                            <div class="form-row align-items-center my-4 " id="5_19_stunting_girls">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="stunting_5_19_girl">STUNTING CRITERIA: FOR 5 TO 19 YEARS Girls</label>
                                        <input type="text" name="stunting_5_19_girl" id="stunting_5_19_girl"
                                            class="form-control" value="<?php echo e($details['stunting_5_19_girl']); ?>" />
                                    </div>
                                </div>

                            </div>

                            <div class="form-row align-items-center my-4 " id="5_19_stunting_boys">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="stunting_5_19_boy">STUNTING CRITERIA: FOR 5 TO 19 YEARS Boys</label>
                                        <input type="text" name="stunting_5_19_boy" id="stunting_5_19_boy"
                                            class="form-control" value="<?php echo e($details['stunting_5_19_boy']); ?>" />

                                    </div>
                                </div>
                                
                            </div>
                            <div class="col-12">
                                    <div class="form-group">
                                        <label for="DietaryAdviceComment">DIETERY COMMENT</label>
                                        <textarea name="DietaryAdviceComment" id="DietaryAdviceComment" class="form-control" rows="4" readonly><?php echo e($details['DietaryAdviceComment']); ?></textarea>
                                    </div>
                                </div>
                      
                            <div class="col-12">
                                    <div class="form-group">
                                        <label for="doctors_comment">DOCTOR COMMENT</label>
                                        <textarea name="doctor_comment" id="doctor_comment" class="form-control" rows="4"><?php echo e($details['doctor_comment']); ?></textarea>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
            </div>

            </div>
            <div class="row">
                <div class="col-md-12">

                </div>
                <a href="#" class="btn btn-primary" id="psychiatrist">View By Psychologist</a>
                &nbsp;
                <a href="#" class="btn btn-primary" id="doc">View By Doctor</a>
                &nbsp;
                &nbsp;
                <a href="#" class="btn btn-primary" id="docComment">Submit Doctor Comment</a>
                &nbsp;
                <a href="#" class="btn btn-primary" id="nutritionist">View By Nutritionist </a>
                &nbsp;
                <a href="#" class="btn btn-primary" id="PsychologistFindings">Sumbit Psychologist findings</a>
            </div>

        </div>



    </div>

    </div>
<?php $__env->stopSection(); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {

        $("#refer_to").select2({
            placeholder: "Refer To",
            allowClear: true,
            multiple: true,

        });

        $('#FollowUpCheck').on('click', function(event) {
            event.preventDefault(); // Prevent default link behavior

            var followUpDate = $("#Follow_up_Date").val();
            var entryid = $("#entryId").val(); // Get entry ID
            var Reason_for_Follow_up = $("#Reason_for_Follow_up").val(); // Get entry ID
            var gr_number = $("#gr_number").val(); // Get entry ID

            console.log('Follow-up Date:', followUpDate);

            $.ajax({
                url: "<?php echo e(route('store.follow.up.date')); ?>", // Ensure this route is correct
                type: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                    follow_up_date: followUpDate,
                    entry_id: entryid,
                    Reason_for_Follow_up: Reason_for_Follow_up,
                    gr_number: gr_number,
                },
                success: function(response) {
                    alert('Follow-up date updated successfully.');

                },
                error: function(xhr) {
                    console.log(xhr.responseJSON); // Log the full response for debugging
                    var errors = xhr.responseJSON.errors;
                    if (errors) {
                        var errorMessages = [];
                        for (var key in errors) {
                            if (errors.hasOwnProperty(key)) {
                                errorMessages.push(errors[key].join(', '));
                            }
                        }
                        // Optionally display error messages
                        alert('Validation errors: ' + errorMessages.join(', '));
                    } else {
                        // alert('An error occurred.');
                    }
                }
            });
        });

        $('#FollowUpCheckforPhycologist').on('click', function(event) {
            event.preventDefault(); // Prevent default link behavior

            var followUpDate = $("#Follow_up_DateforPhycologist").val();
            var entryid = $("#entryIdforPhycologist").val(); // Get entry ID
            var Reason_for_Follow_up = $("#Reason_for_Follow_up").val(); // Get entry ID
            var gr_number = $("#gr_number").val(); // Get entry ID

            console.log('Follow-up Date:', followUpDate);

            $.ajax({
                url: "<?php echo e(route('store.follow.up.Phycologist.date')); ?>", // Ensure this route is correct
                type: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                    follow_up_date: followUpDate,
                    entry_id: entryid,
                    Reason_for_Follow_up: Reason_for_Follow_up,
                    gr_number: gr_number,
                },
                success: function(response) {
                    alert('Follow-up date updated successfully.');

                },
                error: function(xhr) {
                    console.log(xhr.responseJSON); // Log the full response for debugging
                    var errors = xhr.responseJSON.errors;
                    if (errors) {
                        var errorMessages = [];
                        for (var key in errors) {
                            if (errors.hasOwnProperty(key)) {
                                errorMessages.push(errors[key].join(', '));
                            }
                        }
                        // Optionally display error messages
                        alert('Validation errors: ' + errorMessages.join(', '));
                    } else {
                        // alert('An error occurred.');
                    }
                }
            });
        });
        $('#FollowUpCheckforExternal').on('click', function(event) {
            event.preventDefault(); // Prevent default link behavior

            var followUpDate = $("#Follow_up_DateforExternal").val();
            var entryid = $("#entry_idforExternal").val(); // Get entry ID
            var Reason_for_Follow_up = $("#Reason_for_Follow_up").val(); // Get entry ID
            var gr_number = $("#gr_number").val(); // Get entry ID

            console.log('Follow-up Date:', followUpDate);

            $.ajax({
                url: "<?php echo e(route('store.follow.up.External.date')); ?>", // Ensure this route is correct
                type: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                    follow_up_date: followUpDate,
                    entry_id: entryid,
                    Reason_for_Follow_up: Reason_for_Follow_up,
                    gr_number: gr_number,
                },
                success: function(response) {
                    alert('Follow-up date updated successfully.');

                },
                error: function(xhr) {
                    console.log(xhr.responseJSON); // Log the full response for debugging
                    var errors = xhr.responseJSON.errors;
                    if (errors) {
                        var errorMessages = [];
                        for (var key in errors) {
                            if (errors.hasOwnProperty(key)) {
                                errorMessages.push(errors[key].join(', '));
                            }
                        }
                        // Optionally display error messages
                        alert('Validation errors: ' + errorMessages.join(', '));
                    } else {
                        // alert('An error occurred.');
                    }
                }
            });
        });
        $('#Follow_up_forgeneralphysician').on('click', function(event) {
            event.preventDefault(); // Prevent default link behavior

            var followUpDate = $("#Follow_up_Dateforgeneralphysician").val();
            var entryid = $("#entryIdforgeneralphysician").val(); // Get entry ID
            var Reason_for_Follow_up = $("#Reason_for_Follow_up").val(); // Get entry ID
            var gr_number = $("#gr_number").val(); // Get entry ID

            console.log('Follow-up Date:', followUpDate);

            $.ajax({
                url: "<?php echo e(route('store.follow.up.generalphysician.date')); ?>", // Ensure this route is correct
                type: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'), // CSRF token
                    follow_up_date: followUpDate,
                    entry_id: entryid,
                    Reason_for_Follow_up: Reason_for_Follow_up,
                    gr_number: gr_number,
                },
                success: function(response) {
                    alert('Follow-up date updated successfully.');

                },
                error: function(xhr) {
                    console.log(xhr.responseJSON); // Log the full response for debugging
                    var errors = xhr.responseJSON.errors;
                    if (errors) {
                        var errorMessages = [];
                        for (var key in errors) {
                            if (errors.hasOwnProperty(key)) {
                                errorMessages.push(errors[key].join(', '));
                            }
                        }
                        // Optionally display error messages
                        alert('Validation errors: ' + errorMessages.join(', '));
                    } else {
                        // alert('An error occurred.');
                    }
                }
            });
        });
        function updateBackgroundColor(selector, selectValue, category) {
            var backgroundColor = '';
            var textColor = 'white'; // Default text color

            switch (category) {
                case 'stunting':
                    switch (selectValue) {
                        case 'Severe Stunting (LAZ/HAZ < -3)':
                        case 'Severe Stunting (LAZ < -3)':
                        case 'Severe Stunting':
                            backgroundColor = 'red';
                            break;
                        case 'Stunting (LAZ/HAZ between -3 and -2)':
                        case 'Stunting (LAZ between -3 and -2)':
                        case 'Stunting':
                            backgroundColor = 'orange';
                            break;
                        case 'Normal (LAZ/HAZ between -2 and +2)':
                        case 'Normal (LAZ between -2 and +2)':
                        case 'Normal':
                            backgroundColor = 'green';
                            break;
                        case 'Tall (LAZ/HAZ > +2)':
                        case 'Tall (LAZ > +2)':
                        case 'Tall':
                            backgroundColor = 'blue';
                            break;
                        default:
                            backgroundColor = '';
                    }
                    break;

                case 'wasting':
                    switch (selectValue) {
                        case 'Severe Wasting (WHZ < -3)':
                        case 'Severe Thinness':
                        case 'Obesity':
                            backgroundColor = 'red';
                            $('#bmi, #bmi61').css({'background-color': 'red', 'color': 'black'});
                            break;
                        case 'Moderate Wasting (WHZ between -3 and -2)':
                        case 'Moderate Thinness':
                        case 'Overweight':
                            backgroundColor = 'orange';
                            $('#bmi, #bmi61').css({'background-color': 'orange', 'color': 'black'});
                            break;
                        case 'Mild Thinness':
                        case 'Mild Overweight':
                            backgroundColor = 'yellow';
                            $('#bmi, #bmi61').css({'background-color': 'yellow', 'color': 'black'});
                            break;
                        case 'Normal (WHZ between -2 and +2)':
                        case 'Normal Weight':
                            backgroundColor = 'green';
                            $('#bmi, #bmi61').css({'background-color': 'green', 'color': 'black'});
                            break;
                        case 'Overweight (WHZ > +2)':
                        case 'Overweight':
                            backgroundColor = 'yellow';
                            textColor = 'black';
                            $('#bmi, #bmi61').css({'background-color': 'yellow', 'color': 'black'});
                            break;
                        case 'Obesity':
                            backgroundColor = 'red';
                            $('#bmi, #bmi61').css({'background-color': 'red', 'color': 'black'});
                            break;
                        default:
                            backgroundColor = '';
                    }
                    break;
            }

            if (backgroundColor) {
                $(selector).attr('style', 'background-color: ' + backgroundColor + ' !important; color: ' +
                    textColor + ' !important;');
            } else {
                $(selector).attr('style', ''); // Reset style if no background color is set
            }
        }

        // Field mappings
        var fieldMappings = [{
                id: '#stunting_5_19_girl',
                category: 'stunting'
            },
            {
                id: '#stunting_5_19_boy',
                category: 'stunting'
            },
            {
                id: '#stunting_2_5_girl',
                category: 'stunting'
            },
            {
                id: '#stunting_2_5_boy',
                category: 'stunting'
            },
            {
                id: '#stunting_birth_to_2_girl',
                category: 'stunting'
            },
            {
                id: '#stunting_birth_to_2_boy',
                category: 'stunting'
            },
            {
                id: '#wasting_5_to_19_boy',
                category: 'wasting'
            },
            {
                id: '#wasting_5_to_19_girl',
                category: 'wasting'
            },
            {
                id: '#wasting_birth_to_5_girl',
                category: 'wasting'
            },
            {
                id: '#wasting_birth_to_5_boy',
                category: 'wasting'
            }
        ];

        // Loop through the mappings and run the function for each text field
        fieldMappings.forEach(function(mapping) {
            var selectedValue = $(mapping.id).val(); // Get the current value of the text field
            updateBackgroundColor(mapping.id, selectedValue, mapping
            .category); // Call the function immediately
        });

        $('#birth_5_wasting_girls, #birth_5_wasting_boys, #5_19_wasting_girls, #5_19_wasting_boys, #birth_2_stunting_girls, #birth_2_stunting_boys, #2_5_stunting_girls, #2_5_stunting_boys, #5_19_stunting_girls, #5_19_stunting_boys')
            .addClass('d-none');

        var age = $("#age").val();
        console.log("fresh age ",age);
        var gender = $("#gender").val();
        // var gender = $('#gender').val();
        // var dob = $('#dob').val();

        // Calculate age from dob
        // var today = new Date();
        // var birthDate = new Date(dob);
        // var age = today.getFullYear() - birthDate.getFullYear();
        // var monthDiff = today.getMonth() - birthDate.getMonth();

        // Adjust age if the birth month hasn't occurred yet in the current year
        // if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {
        //     age--;
        // }
        console.log("not fresh age ",age);
        // Set calculated age to the readonly input
        //  $('#read_oly_age').val(age);
// console.write(a);
        // $('#read_oly_gender').val(gender);
        if (gender == 'female' && age <= 5) {
            $('#birth_5_wasting_girls').removeClass('d-none');
        } else if (gender == 'male' && age <= 5) {
            $('#birth_5_wasting_boys').removeClass('d-none');
        } else if (gender == 'female' && age > 5 && age <= 19) {
            $('#5_19_wasting_girls').removeClass('d-none');
        } else if (gender == 'male' && age > 5 && age <= 19) {
            $('#5_19_wasting_boys').removeClass('d-none');

        } else {}

        if (gender == 'female' && age <= 2) {
            $('#birth_2_stunting_girls').removeClass('d-none');
        } else if (gender == 'male' && age <= 2) {
            $('#birth_2_stunting_boys').removeClass('d-none');
        } else if (gender == 'female' && age > 2 && age <= 5) {
            $('#2_5_stunting_girls').removeClass('d-none');
        } else if (gender == 'male' && age > 2 && age <= 5) {
            $('#2_5_stunting_boys').removeClass('d-none');
        } else if (gender == 'female' && age > 5 && age <= 19) {
            $('#5_19_stunting_girls').removeClass('d-none');
        } else if (gender == 'male' && age > 5 && age <= 19) {
            $('#5_19_stunting_boys').removeClass('d-none');
        }

        var Posture = $("#Posture").val();
        if (Posture == 'No') {
            $("#Posture").addClass("bg-danger");
        } else {}

        var jaundice = $("#jaundice").val();
        if (jaundice == 'yes') {
            $("#jaundice").addClass("bg-danger");
        } else {}

        var Mentalstatus = $("#Mentalstatus").val();
        if (Mentalstatus == 'Lethargic') {
            $("#Mentalstatus").addClass("bg-danger");
        } else {}

        var anemia = $("#anemia").val();
        if (anemia == 'Yes') {
            $("#anemia").addClass("bg-danger");
        } else {}

        var clubbing = $("#clubbing").val();
        if (clubbing == 'Yes') {
            $("#clubbing").addClass("bg-danger");
        } else {}

        var cyanosis = $("#cyanosis").val();
        if (cyanosis == 'Yes') {
            $("#cyanosis").addClass("bg-danger");
        } else {}

        var cyanosis = $("#cyanosis").val();
        if (cyanosis == 'Yes') {
            $("#cyanosis").addClass("bg-danger");
        } else {}

        var skin = $("#skin").val();
        if (skin == 'Rash' || skin == 'Allergy' || skin == 'Lesion' || skin == 'Bruises') {
            $("#skin").addClass("bg-danger");
        } else {}

        var breath = $("#breath").val();
        if (breath == 'Bad Breath') {
            $("#breath").addClass("bg-danger");
        } else {}

        var Nails = $("#Nails").val();
        if (Nails == 'Dirty') {
            $("#Nails").addClass("bg-danger");
        } else {}

        var Lice_nits = $("#Lice_nits").val();
        if (Lice_nits == 'Yes') {
            $("#Lice_nits").addClass("bg-danger");
        } else {}

        var hair_and_scalp = $("#hair_and_scalp").val();
        if (hair_and_scalp == 'Color-faded') {
            $("#hair_and_scalp").addClass("bg-danger");
        } else {}

        var Question_No_21_Any_Hair_Problem = $("#Question_No_21_Any_Hair_Problem").val();
        if (Question_No_21_Any_Hair_Problem == 'Kinky' || Question_No_21_Any_Hair_Problem == 'Brittle' ||
            Question_No_21_Any_Hair_Problem == 'Dry') {
            $("#Question_No_21_Any_Hair_Problem").addClass("bg-danger");
        } else {}

        var Question_No_22_Sclap = $("#Question_No_22_Sclap").val();
        if (Question_No_22_Sclap == 'Scaly' || Question_No_22_Sclap == 'Dry' || Question_No_22_Sclap ==
            'Moist') {
            $("#Question_No_22_Sclap").addClass("bg-danger");
        } else {}

        var Question_No_23_Hair_distribution = $("#Question_No_23_Hair_distribution").val();
        if (Question_No_23_Hair_distribution == 'Patchy' || Question_No_23_Hair_distribution == 'Receding' ||
            Question_No_23_Hair_distribution == 'Receding_Hair_Line') {
            $("#Question_No_23_Hair_distribution").addClass("bg-danger");
        } else {}

        var Question_No_25_Normal_ocular_alignment = $("#Question_No_25_Normal_ocular_alignment").val();
        if (Question_No_25_Normal_ocular_alignment == 'No' || Question_No_25_Normal_ocular_alignment == 'no') {
            $("#Question_No_25_Normal_ocular_alignment").addClass("bg-danger");
        } else {}

        var Question_No_26_Normal_eye_inspection = $("#Question_No_26_Normal_eye_inspection").val();
        if (Question_No_26_Normal_eye_inspection == 'No' || Question_No_26_Normal_eye_inspection == 'no') {
            $("#Question_No_26_Normal_eye_inspection").addClass("bg-danger");
        } else {}

         var Question_No_27_Normal_Color_vision = $("#Question_No_27_Normal_Color_vision").val();
         if(Question_No_27_Normal_Color_vision == 'No' || Question_No_27_Normal_Color_vision == 'no'){
             $("#Question_No_27_Normal_Color_vision").addClass("bg-danger");
         }else{}

        var Question_No_28_Nystagmus = $("#Question_No_28_Nystagmus").val();
        if (Question_No_28_Nystagmus == 'Yes' || Question_No_28_Nystagmus == 'yes') {
            $("#Question_No_28_Nystagmus").addClass("bg-danger");
        } else {}

        var Question_No_29_Normal_ears_shape_and_position = $("#Question_No_29_Normal_ears_shape_and_position")
            .val();
        if (Question_No_29_Normal_ears_shape_and_position == 'No' ||
            Question_No_29_Normal_ears_shape_and_position == 'no') {
            $("#Question_No_29_Normal_ears_shape_and_position").addClass("bg-danger");
        } else {}

        var Right_ear = $("#Right_ear").val();
        if (Right_ear == 'Ear wax' || Right_ear == 'Canal infection') {
            $("#Right_ear").addClass("bg-danger");
        } else {}

        var Question_No_31_Conclusion_of_hearing = $("#Question_No_31_Conclusion_of_hearing").val();
        if (Question_No_31_Conclusion_of_hearing == 'right_ear_conductive_hearing_loss' || Right_ear ==
            'left_ear_conductive_hearing_loss' || Right_ear == 'right_ear_sensorineural_hearing_loss' ||
            Right_ear == 'left_ear_sensorineural_hearing_loss') {
            $("#Question_No_31_Conclusion_of_hearing").addClass("bg-danger");
        } else {}

        var Question_No_32_External_inasal_examinaton = $("#Question_No_32_External_inasal_examinaton").val();
        if (Question_No_32_External_inasal_examinaton != 'Normal' &&
            Question_No_32_External_inasal_examinaton != 'normal') {
            $("#Question_No_32_External_inasal_examinaton").addClass("bg-danger");
        } else {}

        var Question_No_33_perform = $("#Question_No_33_perform").val();
        if (Question_No_33_perform != 'Normal' && Question_No_33_perform != 'normal') {
            $("#Question_No_33_perform").addClass("bg-danger");
        } else {}

        var Question_No_34_Assess_gingiva = $("#Question_No_34_Assess_gingiva").val();
        if (Question_No_34_Assess_gingiva != 'Normal' && Question_No_34_Assess_gingiva != 'normal') {
            $("#Question_No_34_Assess_gingiva").addClass("bg-danger");
        } else {}

        var Question_No_35_Are_there_dental_caries = $("#Question_No_35_Are_there_dental_caries").val();
        if (Question_No_35_Are_there_dental_caries == 'Yes' || Question_No_35_Are_there_dental_caries ==
            'yes') {
            $("#Question_No_35_Are_there_dental_caries").addClass("bg-danger");
        } else {}

        var Question_No_36_Examine_tonsils = $("#Question_No_36_Examine_tonsils").val();
        if (Question_No_36_Examine_tonsils == 'Tonsillitis') {
            $("#Question_No_36_Examine_tonsils").addClass("bg-danger");
        } else {}

        var Question_No_37_Normal_Speech_development = $("#Question_No_37_Normal_Speech_development").val();
        if (Question_No_37_Normal_Speech_development == 'No' || Question_No_37_Normal_Speech_development ==
            'no') {
            $("#Question_No_37_Normal_Speech_development").addClass("bg-danger");
        } else {}

        var any_neck_swelling = $("#any_neck_swelling").val();
        if (any_neck_swelling == 'Yes' || any_neck_swelling == 'yes') {
            $("#any_neck_swelling").addClass("bg-danger");
        } else {}

        var lymph_node = $("#lymph_node").val();
        if (lymph_node == 'abnormal') {
            $("#lymph_node").addClass("bg-danger");
        } else {}

        var Question_No_40_Any_visible_chest_deformity = $("#Question_No_40_Any_visible_chest_deformity").val();
        if (Question_No_40_Any_visible_chest_deformity == 'Yes' || Question_No_40_Any_visible_chest_deformity ==
            'yes') {
            $("#Question_No_40_Any_visible_chest_deformity").addClass("bg-danger");
        } else {}

        var Question_No_41_Lung_Auscultation = $("#Question_No_41_Lung_Auscultation").val();
        if (Question_No_41_Lung_Auscultation != 'Ronchi' && Question_No_41_Lung_Auscultation !=
            'Vesicular_Breathing') {
            $("#Question_No_41_Lung_Auscultation").addClass("bg-danger");
        } else {}

        var Question_No_42_Cardiac_Auscultation = $("#Question_No_42_Cardiac_Auscultation").val();
        if (Question_No_42_Cardiac_Auscultation == 'Murmur') {
            $("#Question_No_42_Cardiac_Auscultation").addClass("bg-danger");
        } else {}

        var distention_scar_mass = $("#distention_scar_mass").val();
        if (distention_scar_mass != 'Normal' && distention_scar_mass != 'normal') {
            $("#distention_scar_mass").addClass("bg-danger");
        } else {}

         var any_history_of_abdominal_pain = $("#any_history_of_abdominal_pain").val();
         if(any_history_of_abdominal_pain == 'Yes'|| any_history_of_abdominal_pain == 'yes'){
             $("#any_history_of_abdominal_pain").addClass("bg-danger");
         }else{}

         var any_history_of_abdominal_pain = $("#any_history_of_abdominal_pain").val();
         if(any_history_of_abdominal_pain == 'Yes'|| any_history_of_abdominal_pain == 'yes'){
             $("#any_history_of_abdominal_pain").addClass("bg-danger");
        }else{}

        var Formvalue = $('#curvature_spine_resembling').val();
        if (Formvalue != 'Normal' && Formvalue != 'normal') {
            $("#curvature_spine_resembling").addClass("bg-danger");
        } else {}


        var Formvalue = $('#spinal_curvature_assessment').val();
        if (Formvalue != 'Normal' && Formvalue != 'normal') {
            $("#spinal_curvature_assessment").addClass("bg-danger");
        } else {}


        var limitations_range_motion = $("#limitations_range_motion").val();
        if (limitations_range_motion == 'Yes' || limitations_range_motion == 'yes') {
            $("#limitations_range_motion").addClass("bg-danger");
        } else {}

        var adams_forward_bend_test = $("#adams_forward_bend_test").val();
        if (adams_forward_bend_test == 'Positive' || adams_forward_bend_test == 'positive') {
            $("#adams_forward_bend_test").addClass("bg-danger");
        } else {}

        var foot_or_toe_abnormalities = $("#foot_or_toe_abnormalities").val();
        if (foot_or_toe_abnormalities != 'Normal' && foot_or_toe_abnormalities != 'normal') {
            $("#foot_or_toe_abnormalities").addClass("bg-danger");
        } else {}

        var Question_No_50_Have_EPI_immunization_card = $("#Question_No_50_Have_EPI_immunization_card").val();
        if (Question_No_50_Have_EPI_immunization_card == 'No' || Question_No_50_Have_EPI_immunization_card ==
            'no') {
            $("#Question_No_50_Have_EPI_immunization_card").addClass("bg-danger");
        } else {}

         var do_you_have_any_Allergies = $("#do_you_have_any_Allergies").val();
         if(do_you_have_any_Allergies == 'Yes'|| do_you_have_any_Allergies == 'yes'){
             $("#do_you_have_any_Allergies").addClass("bg-danger");
         }else{}

         var discomfort_during_urination = $("#discomfort_during_urination").val();
        if(discomfort_during_urination != 'No urinary issues reported'){
             $("#discomfort_during_urination").addClass("bg-danger");
         }else{}

         var any_menstrual_abnormality = $("#any_menstrual_abnormality").val();
         if(any_menstrual_abnormality == 'Yes' || any_menstrual_abnormality == 'yes'){
             $("#any_menstrual_abnormality").addClass("bg-danger");
         }else{}

         var any_menstrual_abnormality = $("#any_menstrual_abnormality").val();
         if(any_menstrual_abnormality == 'Yes' || any_menstrual_abnormality == 'yes'){
             $("#any_menstrual_abnormality").addClass("bg-danger");
         }else{}

        var observation1 = $("#observation1").val();
        if (observation1 == '3' || observation1 == '4') {
            $("#observation1").addClass("bg-danger");
        } else {}

        var observation2 = $("#observation2").val();
        if (observation2 == '3' || observation2 == '4') {
            $("#observation2").addClass("bg-danger");
        } else {}

        var observation3 = $("#observation3").val();
        if (observation3 == '3' || observation3 == '4') {
            $("#observation3").addClass("bg-danger");
        } else {}

        var observation4 = $("#observation4").val();
        if (observation4 == '3' || observation4 == '4') {
            $("#observation4").addClass("bg-danger");
        } else {}

        var observation5 = $("#observation5").val();
        if (observation5 == '3' || observation5 == '4') {
            $("#observation5").addClass("bg-danger");
        } else {}

        var observation6 = $("#observation6").val();
        if (observation6 == '3' || observation6 == '4') {
            $("#observation6").addClass("bg-danger");
        } else {}

        var observation7 = $("#observation7").val();
        if (observation7 == '3' || observation7 == '4') {
            $("#observation7").addClass("bg-danger");
        } else {}

        var observation8 = $("#observation8").val();
        if (observation8 == '3' || observation8 == '4') {
            $("#observation8").addClass("bg-danger");
        } else {}

        var observation9 = $("#observation9").val();
        if (observation9 == '3' || observation9 == '4') {
            $("#observation9").addClass("bg-danger");
        } else {}

        var observation10 = $("#observation10").val();
        if (observation10 == '3' || observation10 == '4') {
            $("#observation10").addClass("bg-danger");
        } else {}

        $(".observation").hide();

        var updateFields = function() {

            var value = parseFloat($("#class").val());

            if (value <= 2 || value == 'KG-2' || value == 'KG-1' || value == 'Nursery' || value ==
                'Play group') {

                $(".observation").show();
                $(".Psychological").hide();

                // Add 'required' attribute to fields in .observation
                $(".observation").find("input, select,textarea").each(function() {
                    $(this).prop('required', true);
                });

                // Remove 'required' attribute from fields in .Psychological
                $(".Psychological").find("input, select,textarea").each(function() {
                    $(this).prop('required', false).val('');
                });

            } else {

                $(".observation").hide();
                $(".Psychological").show();

                // Remove 'required' attribute from fields in .observation
                $(".observation").find("input, select,textarea").each(function() {
                    $(this).prop('required', false).val('');
                });

                // Add 'required' attribute to fields in .Psychological
                $(".Psychological").find("input, select,textarea").each(function() {
                    $(this).prop('required', true);
                });
            }

        };

        // Initial check on page load
        updateFields();

        // Attach event listeners for keyup and change events
        $("#class").on("keyup change", function() {
            updateFields();
        });

        $('#Follow_up_Required').on('change', function() {
            var selectedValue = $(this).val();

            if (selectedValue === "Yes") {

                $('#follow_up_show').removeClass('d-none');
                $("#Reason_for_Follow_up").attr('required', true);
                $("#Follow_up_Date").attr('required', true);

                $('.refer_to_form_row').removeClass('d-none');
                $("#refer_to").attr('required', true);

            } else {

                $('.refer_to_form_row').addClass('d-none');
                $("#refer_to").attr('required', false);

                $('#follow_up_show').addClass('d-none');
                $("#Reason_for_Follow_up").attr('required', false);
                $("#Follow_up_Date").attr('required', false);
                $("#Reason_for_Follow_up").val('');
                $("#Follow_up_Date").val('');



            }
        });

        $('#Follow_up_Required').change();


        function updateEventColor(referToValue) {
            var color;
            var textColor = 'white';

            switch (referToValue) {
                case '1': // Psychologist
                    color = 'blue';
                    textColor = 'white';
                    break;
                case '2': // Nutritionist
                    color = 'green';
                    textColor = 'white';
                    break;
                case '3': // Physician
                    color = 'red';
                    textColor = 'white';
                    break;
                default:
                    color = 'white'; // Default background color
                    textColor = 'black'; // Default text color
                    break;
            }

            // Apply the background and text color to the select element
            $('#refer_to').css({
                'background-color': color,
                'color': textColor
            });
        }

        // Set the initial color based on the current selected value
        var initialReferToValue = $('#refer_to').val();
        // updateEventColor(initialReferToValue);

        // Update the color whenever the dropdown value changes
        // $('#refer_to').on('change', function() {
        //     var selectedValue = $(this).val();
        //     updateEventColor(selectedValue);
        // });



        /****************************** Nutritionist ***********************************/

        /* food_allergies */
         $('#food_allergies').change(function() {


             var selectedValue = $(this).val();
            // console.log("selectedValue " + selectedValue);

            var other_food_allergies = document.getElementById("other_food_allergies");

             const food_allergiesContainer = document.getElementById('food_allergiesContainer');

             if (selectedValue === 'Yes') {


                other_food_allergies.style.setProperty('background-color', 'red', 'important');
                 other_food_allergies.style.setProperty('color', 'white', 'important');
                 food_allergiesContainer.classList.remove('d-none');

            } else {

                 other_food_allergies.style.removeProperty('background-color');
                 other_food_allergies.style.removeProperty('color');
                 food_allergiesContainer.classList.add('d-none');

             }
         });

         $('#food_allergies').change();

        /* Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day*/
         $('#Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day').change(function() {
             var selectedValue = $(this).val();



             if (selectedValue === '< 4') {

                 // this.style.removeProperty('background-color');
                 // this.style.removeProperty('color');

                 this.style.setProperty('background-color', 'red', 'important');
                 this.style.setProperty('color', 'white', 'important');

             } else if (selectedValue === '6-8') {

                 this.style.setProperty('background-color', 'green', 'important');
                 this.style.setProperty('color', 'white', 'important');

             } else if (selectedValue === '4-6') {

                 this.style.setProperty('background-color', 'yellow', 'important');
                 this.style.setProperty('color', 'black', 'important');

             } else {

                 // this.style.setProperty('background-color', 'red', 'important');
                 // this.style.setProperty('color', 'white', 'important');

                 this.style.removeProperty('background-color');
                this.style.removeProperty('color');
            }
        });

         $('#Question_No65_How_many_glasses_of_waterliquids_do_you_consume_in_a_day').change();

        /* Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to */
         $('#Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to').change(
             function() {


                var selectedValue = $(this).val();
                 // console.log("Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to "+ selectedValue);

                 var addiction = document.getElementById("addiction");

                 // Select the container of the second form group
                 const addictionContainer = document.getElementById('addictionContainer');
                 const otherAddictionContainer = document.getElementById('otherAddictionContainer');


                 if (selectedValue === 'Yes') {

                     addiction.style.setProperty('background-color', 'red', 'important');
                    addiction.style.setProperty('color', 'white', 'important');
                     addictionContainer.classList.remove('d-none');
                     otherAddictionContainer.classList.remove('d-none');


                 } else {

                     addiction.style.removeProperty('background-color');
                     addiction.style.removeProperty('color');
                     addictionContainer.classList.add('d-none');
                     otherAddictionContainer.classList.add('d-none');

                 }
            });

         $('#Question_No66_Does_the_child_have_any_history_of_substances_abuse_or_addiction_to').change();


        /* Function to capitalize the first letter of a string */
         function capitalizeFirstLetter(string) {
                 return string.charAt(0).toUpperCase() + string.slice(1);
             }

        /* Function to capitalize the first letter of a string */
        function capitalizeFirstLetter(string) {
            if (typeof string !== 'string' || !string) {
                return ''; // Return an empty string or handle invalid input appropriately
            }
            return string.charAt(0).toUpperCase() + string.slice(1);
        }


        /* Question_No_60_How_would_you_describe_your_lifestyle */
        $('#Question_No_60_How_would_you_describe_your_lifestyle').change(
            function() {


                var age = $("#age").val();
                var gender = $("#gender").val();

                // Capitalize the first letter
                var gender = capitalizeFirstLetter(gender);


                var selectedValue = $(this).val();

                var Question_No_60_How_would_you_describe_your_lifestyle = document.getElementById(
                    "Question_No_60_How_would_you_describe_your_lifestyle");

                if (selectedValue === 'Sedentary') {


                    Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty(
                        'background-color', 'red', 'important');
                    Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty('color', 'white',
                        'important');





                } else if (selectedValue === 'Moderately') {


                    Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty(
                        'background-color', 'yellow', 'important');
                    Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty('color', 'black',
                        'important');







                } else if (selectedValue === 'Active') {


                    Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty(
                        'background-color', 'green', 'important');
                    Question_No_60_How_would_you_describe_your_lifestyle.style.setProperty('color', 'white',
                        'important');




                } else {

                    Question_No_60_How_would_you_describe_your_lifestyle.style.removeProperty(
                        'background-color');
                    Question_No_60_How_would_you_describe_your_lifestyle.style.removeProperty('color');
                    $("#Daily_energy_requirement").val('').attr('readonly', false);


                }
            });


        $('#Question_No_60_How_would_you_describe_your_lifestyle').change();





        $("#dob").on("change", function() {

            var dob = $(this).val();

            if (dob) {

                var today = new Date();
                var birthDate = new Date(dob);
                var age = today.getFullYear() - birthDate.getFullYear();
                var monthDiff = today.getMonth() - birthDate.getMonth();
                var gender = $("#gender").val();

                var totalMonths = (age * 12) + monthDiff;

                if (today.getDate() < birthDate.getDate()) {
                    totalMonths--;
                }

                $("#age").val(age);

                if (totalMonths >= 7 && totalMonths <= 12) {
                    $("#Daily_Protien_requirement").val("1.0").attr('readonly', true);
                } else if (age >= 1 && age <= 3) {
                    $("#Daily_Protien_requirement").val("0.87").attr('readonly', true);
                } else if (age >= 4 && age <= 8) {
                    $("#Daily_Protien_requirement").val("0.76").attr('readonly', true);
                } else if (age >= 9 && age <= 13) {
                    $("#Daily_Protien_requirement").val("0.76").attr('readonly', true);
                } else if (age >= 14 && age <= 18 && $("#gender").val() == "male") {
                    $("#Daily_Protien_requirement").val("0.73").attr('readonly', true);
                } else if (age >= 14 && age <= 18 && $("#gender").val() == "female") {
                    $("#Daily_Protien_requirement").val("0.71").attr('readonly', true);
                } else {
                    $("#Daily_Protien_requirement").val("").attr('readonly', false);

                }



            } else {

                $("#age").val("");
                $("#Daily_Protien_requirement").val("").attr('readonly', false);


            }



            console.log("age " + age);
            /* Check if age is less than 5 */
            if (parseFloat(age) < 5) {


                /* Show the field and ensure the required attribute is present */
                $('#muac').closest('.form-group').show();
                $('#muac').attr('required', true);
                //    $('#muac').val('');
                $('#muac-container').show();


            } else {

                /* Hide the field and remove the required attribute */
                $('#muac').closest('.form-group').hide();
                $('#muac').removeAttr('required');
                $('#muac').val('');
                $('#muac-container').hide();


            }




        });



        $('#dob').change();


        /* weight*/
        $("#weight").on("keyup change", function(e) {

            $("#dob").change();

            var weight = parseFloat($("#weight").val());
            var dailyEnergyRequirement = parseFloat($("#Daily_Protien_requirement").val());
            /*console.log("weight "+ weight);
            console.log("dailyEnergyRequirement "+ dailyEnergyRequirement);*/

            if (weight > 0) {

                var dailyProteinRequirement = dailyEnergyRequirement * weight;

                console.log('dailyProteinRequirement', dailyProteinRequirement);


                // Format to at least 3 decimal places
                var formattedDailyProteinRequirement = dailyProteinRequirement.toFixed(3);

                console.log('formattedDailyProteinRequirement', formattedDailyProteinRequirement);

                /*console.log("dailyProteinRequirement "+ formattedDailyProteinRequirement);*/

                $("#Daily_Protien_requirement").val(formattedDailyProteinRequirement).attr('readonly',
                    true);
            }

        });

        $("#weight").change();


        /* lifestyle */
        $('#lifestyle').change(function() {


            var selectedValue = $(this).val();

            var lifestyle = document.getElementById("lifestyle");

            if (selectedValue === 'Sedentary') {


                lifestyle.style.setProperty('background-color', 'red', 'important');
                lifestyle.style.setProperty('color', 'white', 'important');

            } else {

                lifestyle.style.removeProperty('background-color');
                lifestyle.style.removeProperty('color');

            }
        });


        $('#lifestyle').change();



        /* meals*/
        $('#meals').change(function() {
            var selectedValue = $(this).val();
            // console.log("meals " + selectedValue);

            if (selectedValue === "1") {

                this.style.setProperty('background-color', 'red', 'important');
                this.style.setProperty('color', 'white', 'important');

            } else {

                this.style.removeProperty('background-color');
                this.style.removeProperty('color');
            }
        });


        $('#meals').change();



        /* food_items*/
        $('#food_items').change(function() {
            var selectedValue = $(this).val();
            // console.log("meals " + selectedValue);

            if (selectedValue === "0-1") {

                this.style.setProperty('background-color', 'green', 'important');
                this.style.setProperty('color', 'white', 'important');

            } else if (selectedValue === "1-2") {

                this.style.setProperty('background-color', 'yellow', 'important');
                this.style.setProperty('color', 'black', 'important');

            } else if (selectedValue === "3 or more") {

                this.style.setProperty('background-color', 'red', 'important');
                this.style.setProperty('color', 'white', 'important');

            } else {

                this.style.removeProperty('background-color');
                this.style.removeProperty('color');
            }
        });


        $('#food_items').change();



        /* fast_food*/
        $('#fast_food').change(function() {
             var selectedValue = $(this).val();
             // console.log("meals " + selectedValue);

             if (selectedValue === "0-1") {

                 this.style.setProperty('background-color', 'green', 'important');
                 this.style.setProperty('color', 'white', 'important');

             } else if (selectedValue === "< 1") {

                 this.style.setProperty('background-color', 'green', 'important');
                 this.style.setProperty('color', 'white', 'important');

            } else if (selectedValue === "1-2") {

                 this.style.setProperty('background-color', 'yellow', 'important');
                 this.style.setProperty('color', 'black', 'important');

             } else if (selectedValue === "3 or more") {

                 this.style.setProperty('background-color', 'red', 'important');
                 this.style.setProperty('color', 'white', 'important');

             } else {

                 this.style.removeProperty('background-color');
                 this.style.removeProperty('color');
             }
         });


         $('#fast_food').change();


        // $('.NutritionistCol').find('input, select, textarea').attr('disabled', true);
        $('.NutritionistCol').find('input, select, textarea').not('#Follow_up_Date, #FollowUpCheck,#FollowUpCheckforPhycologist,#Follow_up_DateforPhycologist,#Follow_up_DateforExternal,#FollowUpCheckforExternal,#Follow_up_Dateforgeneralphysician,#Follow_up_forgeneralphysician').attr(
            'disabled', true);

        /************************************************************************************************/



        $('#PsychologistFindings').click(function(e) {
            var comment = $('#findings_by_psychologist').val();
            var PsychologistRefferedTo = $('#PsychologistRefferedTo').val();
            e.preventDefault();

            $.ajax({
                type: "post",
                url: "<?php echo e(url('PsychologistFindings')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: <?php echo e($form_id); ?>,
                    comment: comment,
                    PsychologistRefferedTo: PsychologistRefferedTo,
                },
                dataType: "json",
                beforeSend: function() {

                },
                success: function(response) {
                    console.log(response);
                    Swal.fire({
                        title: 'Success!',
                        text: 'Enrollment has been submitted successfully!',
                        icon: 'success',
                        confirmButtonText: 'OK',
                        timer: 2000, // Set the timer to 2 seconds (in milliseconds)
                        timerProgressBar: true, // Show a progress bar during the timer
                        showConfirmButton: false // Hide the "OK" button
                    }).then(() => {
                        // window.location.href = "<?php echo e(route('admin.form_entry.index')); ?>"
                    });
                },
                error: function(err) {
                    console.log(err);
                }
            });
        });

        $('#psychiatrist').click(function(e) {
            e.preventDefault();

            $.ajax({
                type: "post",
                url: "<?php echo e(url('ViewByphy')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: <?php echo e($form_id); ?>,
                },
                dataType: "json",
                beforeSend: function() {

                },
                success: function(response) {
                    console.log(response);
                    Swal.fire({
                        title: 'Success!',
                        text: 'Enrollment has been submitted successfully!',
                        icon: 'success',
                        confirmButtonText: 'OK',
                        timer: 2000, // Set the timer to 2 seconds (in milliseconds)
                        timerProgressBar: true, // Show a progress bar during the timer
                        showConfirmButton: false // Hide the "OK" button
                    }).then(() => {
                        window.location.href =
                            "https://cphs.biopharmainfo.net/admin/screening"
                    });
                },
                error: function(err) {
                    console.log(err);
                }
            });
        });
        $('#nutritionist').click(function(e) {

            e.preventDefault();

            $.ajax({
                type: "post",
                url: "<?php echo e(url('ViewBynutritionist')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: <?php echo e($form_id); ?>,
                },
                dataType: "json",
                beforeSend: function() {

                },
                success: function(response) {
                    console.log(response);
                    Swal.fire({
                        title: 'Success!',
                        text: 'Enrollment has been submitted successfully!',
                        icon: 'success',
                        confirmButtonText: 'OK',
                        timer: 2000, // Set the timer to 2 seconds (in milliseconds)
                        timerProgressBar: true, // Show a progress bar during the timer
                        showConfirmButton: false // Hide the "OK" button
                    }).then(() => {
                        window.location.href =
                            "https://cphs.biopharmainfo.net/admin/screening"
                    });
                },
                error: function(err) {
                    console.log(err);
                }
            });
        });
        $('#doc').click(function(e) {
          
            e.preventDefault();

            $.ajax({
                type: "post",
                url: "<?php echo e(url('ViewByDoc')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: <?php echo e($form_id); ?>,
                   
                },
                dataType: "json",
                beforeSend: function() {

                },
                success: function(response) {
                    console.log(response);
                    Swal.fire({
                        title: 'Success!',
                        text: 'Enrollment has been submitted successfully!',
                        icon: 'success',
                        confirmButtonText: 'OK',
                        timer: 2000, // Set the timer to 2 seconds (in milliseconds)
                        timerProgressBar: true, // Show a progress bar during the timer
                        showConfirmButton: false // Hide the "OK" button
                    }).then(() => {
                        window.location.href =
                           "https://cphs.biopharmainfo.net/admin/screening"
                    });
                },
                error: function(err) {
                    console.log(err);
                }
            });
        });
        $('#docComment').click(function(e) {
            var comment = $('#doctor_comment').val();
            e.preventDefault();

            $.ajax({
                type: "post",
                url: "<?php echo e(url('DoctorComment')); ?>",
                data: {
                    _token: "<?php echo e(csrf_token()); ?>",
                    id: <?php echo e($form_id); ?>,
                    doctor_comment:comment,
                },
                dataType: "json",
                beforeSend: function() {

                },
                success: function(response) {
                    console.log(response);
                    Swal.fire({
                        title: 'Success!',
                        text: 'Comment has been submitted successfully!',
                        icon: 'success',
                        confirmButtonText: 'OK',
                        timer: 2000, // Set the timer to 2 seconds (in milliseconds)
                        timerProgressBar: true, // Show a progress bar during the timer
                        showConfirmButton: false // Hide the "OK" button
                    }).then(() => {
                        window.location.href =
                           "https://cphs.biopharmainfo.net/admin/screening"
                    });
                },
                error: function(err) {
                    console.log(err);
                }
            });
        });
        // new code 
        function setBMIBasedOnValue(bmiValue, bmiInputId) {
            var bmiInput = $(bmiInputId);
            if (bmiValue <= 18.4 || bmiValue >= 24.10) {
                // bmiInput.addClass("bg-danger");
                // $("#bmishow").val("High");
                // $("#bmiresult").val('High');
            } else {
                // bmiInput.removeClass("bg-danger");
                // $("#bmishow").val("Normal");
                // $("#bmiresult").val('Normal');
            }
        }

        // Fetch and apply color for initial BMI values
        var initialBMI = parseFloat("<?php echo e($details['question_no_3_bmi']); ?>"); // For Question No.3
        if (!isNaN(initialBMI)) {
            setBMIBasedOnValue(initialBMI, '#bmi');
        }

        var initialBMI61 = parseFloat("<?php echo e($details['bmi61']); ?>"); // For Question No.61
        if (!isNaN(initialBMI61)) {
            setBMIBasedOnValue(initialBMI61, '#bmi61');
        }

        // Existing keyup/change logic for height and weight
        $("#weight, #height").on("keyup change", function(e) {
            var height = $('#height').val();
            var weight = $('#weight').val();
            if (height != '' && height > 0 && weight != '' && weight > 0) {
                var result = (weight / height / height) * 10000;
                $('#bmi').val(result.toFixed(2));
                setBMIBasedOnValue(result, '#bmi');
            }
        });

        // Add additional logic to calculate and set the BMI for bmi61 if needed
        $("#weight61, #height61").on("keyup change", function(e) {
            var height61 = $('#height61').val(); // Make sure you have this input
            var weight61 = $('#weight61').val(); // Make sure you have this input
            if (height61 != '' && height61 > 0 && weight61 != '' && weight61 > 0) {
                var result61 = (weight61 / height61 / height61) * 10000;
                $('#bmi61').val(result61.toFixed(2));
                setBMIBasedOnValue(result61, '#bmi61');
            }
        });

        function initializeBloodPressureDisplays() {
            var systolicValue = parseInt($("#Question_No_5_Blood_Pressure_Systolic").val());
            var diastolicValue = parseInt($("#Question_No_6_Blood_Pressure_Diastolic").val());
            var age = parseInt($("#age").val());
            console.log("Fetched Age:", age); // Log the fetched age
            console.log("Question_No_5_Blood_Pressure_Systolic", systolicValue)
            console.log("Question_No_6_Blood_Pressure_Diastolic", diastolicValue)
            // console.log("View Age",age)

            // Initialize systolic pressure display
            $("#Blood_Pressure_Systolic").text("").removeClass("text-success");
            if (age > 1 && age < 13) {
                    if (systolic < 90) {
                        $("#Blood_Pressure_Systolic").text("Normal BP").addClass("text-success");
                        $("#systolicresult").val("Normal BP")
                    } else if (systolic >= 90 && systolic < 95) {
                        $("#Blood_Pressure_Systolic").text("Elevated BP").addClass("text-success");
                        $("#systolicresult").val("Elevated BP")

                    } else if (systolic >= 130 && systolic < 139) {
                        $("#Blood_Pressure_Systolic").text("Stage 1 HTN ").addClass("text-success");
                        $("#systolicresult").val("Stage 1 HTN")

                    } else if (systolic > 140) {
                        $("#Blood_Pressure_Systolic").text("Stage 2 HTN ").addClass("text-success");
                        $("#systolicresult").val("Stage 2 HTN")

                    }
                } else if (age >= 13) {
                    if (systolic < 120) {
                        $("#Blood_Pressure_Systolic").text("Normal BP").addClass("text-success");
                        $("#systolicresult").val("Normal BP")

                    } else if (systolic >= 120 && systolic < 130) {
                        $("#Blood_Pressure_Systolic").text("Elevated BP").addClass("text-success");
                        $("#systolicresult").val("Elevated BP")

                    } else if (systolic >= 130 && systolic < 140) {
                        $("#Blood_Pressure_Systolic").text("Stage 1 HTN").addClass("text-success");
                        $("#systolicresult").val("Stage 1 HTN")

                    } else if (systolic > 140) {
                        $("#Blood_Pressure_Systolic").text("Stage 3 HTN ").addClass("text-success");
                        $("#systolicresult").val("Stage 1 HTN")

                    }
                }

            // Initialize diastolic pressure display
            $("#Blood_Pressure_Diastolic").text("").removeClass("text-success");
            if (age > 1 && age < 13) {
                    if (diastolic < 90) {
                        $("#Blood_Pressure_Diastolic").text("Normal BP").addClass("text-success");
                        $("#diastolicresult").val("Normal BP")

                    } else if (diastolic >= 90 && diastolic < 95) {
                        $("#Blood_Pressure_Diastolic").text("Elevated BP").addClass("text-success");
                        $("#diastolicresult").val("Elevated BP")

                    } else if (diastolic >= 80 && diastolic < 89) {
                        $("#Blood_Pressure_Diastolic").text("Stage 1 HTN ").addClass("text-success");
                        $("#diastolicresult").val("Stage 1 HTN")

                    } else if (diastolic >= 140) {
                        $("#Blood_Pressure_Diastolic").text("Stage 2 HTN ").addClass("text-success");
                        $("#diastolicresult").val("Stage 2 HTN")

                    }
                } else if (age >= 13) {
                    if (diastolic < 80) {
                        $("#Blood_Pressure_Diastolic").text("Elevated BP").addClass("text-success");
                        $("#diastolicresult").val("Elevated BP")

                    } else if (diastolic >= 80 && diastolic < 90) {
                        $("#Blood_Pressure_Diastolic").text("Stage 1 HTN").addClass("text-success");
                        $("#diastolicresult").val("Stage 1 HTN")

                    } else if (diastolic >= 90) {
                        $("#Blood_Pressure_Diastolic").text("Stage 2 HTN ").addClass("text-success");
                        $("#diastolicresult").val("Stage 2 HTN")

                    }
                }
        }


        initializeBloodPressureDisplays();

        function validatePulse() {
            var pulse = parseInt($('#Question_No_7_Pulse').val());
            var age = parseInt($('#age').val());

            if (age >= 3 && age <= 5) {
                if (pulse <= 79 || pulse >= 121) {
                    $("#Question_No_7_Pulse").addClass("bg-danger");
                } else {
                    $("#Question_No_7_Pulse").removeClass("bg-danger");
                }
            } else if (age >= 6 && age <= 12) {
                if (pulse <= 74 || pulse >= 119) {
                    $("#Question_No_7_Pulse").addClass("bg-danger");
                } else {
                    $("#Question_No_7_Pulse").removeClass("bg-danger");
                }
            } else if (age >= 13 && age <= 17) {
                if (pulse <= 59 || pulse >= 101) {
                    $("#Question_No_7_Pulse").addClass("bg-danger");
                } else {
                    $("#Question_No_7_Pulse").removeClass("bg-danger");
                }
            }
        }

        // Initial validation on page load
        validatePulse();


    });
</script>

<?php echo $__env->make('admin.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rehman/public_html/cphs/resources/views/admin/details_new.blade.php ENDPATH**/ ?>