<?php

    use App\Models\User;
    use App\Models\SchoolHealthPhysician;
    use App\Models\NutritionistHistoryEvaluationSection;
    use App\Models\PsychologistHistoryAssessmentSection;
    use App\Models\form_entry;
    use App\Models\FormData;
    use Illuminate\Support\Collection;
    use App\Models\StudentBiodata;
?>

<?php $__env->startSection('content'); ?>
    <style>
        @media (min-width:992px) {

            .mdk-drawer-layout .container,
            .mdk-drawer-layout .container-fluid,
            .mdk-drawer-layout .container-lg,
            .mdk-drawer-layout .container-md,
            .mdk-drawer-layout .container-sm,
            .mdk-drawer-layout .container-xl {
                max-width: 1440px;
            }
        }

        .link {
            color: white !important;
            border-bottom: 1px solid rgb(247, 190, 3);
        }



        #datatable_wrapper {
            padding: 10px;
        }

        div#datatable_info {
            color: #fff;
        }

        div#datatable_filter {
            display: flex;
            justify-content: end;
            margin-right: 20px;
        }

        .upload_csv {
            display: flex;
            gap: 20px;
            justify-content: end;
        }

        .upload_csv form {
            display: flex;
            align-items: center;
            flex-wrap: wrap;
        }

        @media (min-width:992px) {

            .mdk-drawer-layout .container,
            .mdk-drawer-layout .container-fluid,
            .mdk-drawer-layout .container-lg,
            .mdk-drawer-layout .container-md,
            .mdk-drawer-layout .container-sm,
            .mdk-drawer-layout .container-xl {
                max-width: 1600px !important;
            }
        }

        .bg_blue {
            background-color: #1c3866;
        }

        .fs_15 {
            font-size: 17px;
            color: #1F3864;
        }

        label {
            color: #5b626b;
        }



        .position-relative {
            posiion: relative;
        }

        #changeImageBtn {
            display: none;
        }

        .position-relative:hover #changeImageBtn {
            display: block;
            cursor: pointer;
        }





        /* Style the button */
        .btn-round {
            border-radius: 50px;
            padding: 10px 20px;
            font-size: 13px;
        }

        /* Style the dropdown container */
        .dropdown-content {
            display: none;
            position: absolute;
            top: 35px;
            background-color: #f9f9f9;
            min-width: -webkit-fill-available;
            box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.2);
            border-radius: 10px;
            z-index: 1;
            width: 100%;
            border: 1px solid #d86744;
            color: #000;
            padding: 1rem 2rem;
        }

        /* Style the links inside the dropdown */
        .dropdown-content a {
            color: #000!important;
            text-decoration: none;
            display: block;
            border-radius: 5px;
            font-size: 13px;
            font-weight: 500;
            padding: 10px 10px;
            text-align: left;
            color: #fff;
        }

        /* Add hover effect for links */
        .dropdown-content a:hover {
            background-color: #d86744;
            color: #fff !important;
        }

        /* Show dropdown on hover */
        .btn-group:hover .dropdown-content {
            display: block;
        }

        /* Style the dropdown divider */
        .dropdown-divider {
            height: 1px;
            background-color: #ddd;
            margin: 8px 0;
        }

        #customId {
            gap: 20px;
        }

        #customId .dropbtn {
            border-radius: 8px;
            box-shadow: none;
            padding: 11px 10px;
            font-weight: 600;
            text-transform: uppercase;
            border: none;
        }
        #customId .dropbtn:focus{
            outline: none!important;
        }
/* 
        #customId .dropbtn:hover {
            background-color: #ffffff34!important;
        } */

    </style>
    <section>
        <div class="container">
            <div class="row mt-4">
                <div class="col-md-12">
                    <div class="d-flex align-items-center justify-content-end">


                        <?php

                            $queryString =
                                !empty($details) && !empty($details['id']) ? 'screeningFormId=' . $details['id'] : 0;

                            $queryString .=
                                !empty($details) && !empty($details['gr_number'])
                                    ? '&gr_number=' . $details['gr_number']
                                    : '';

                            $queryString .=
                                !empty($details) && !empty($details['class']) ? '&class=' . $details['class'] : '';

                            $queryString .=
                                !empty($details) && !empty($details['name']) ? '&name=' . $details['name'] : '';
                            $queryString .=
                                !empty($details) && !empty($details['dob']) ? '&dob=' . $details['dob'] : '';
                            $queryString .=
                                !empty($details) && !empty($details['age']) ? '&age=' . $details['age'] : '';
                            $queryString .=
                                !empty($details) && !empty($details['gender']) ? '&gender=' . $details['gender'] : '';

                            $queryString .=
                                !empty($details) && !empty($details['school']) ? '&school=' . $details['school'] : '';

                            $queryString .=
                                !empty($details) && !empty($details['any_known_medical_condition'])
                                    ? '&any_known_medical_condition=' . $details['any_known_medical_condition']
                                    : '';

                            $queryString .=
                                !empty($details) && !empty($details['bio_data_comment'])
                                    ? '&bio_data_comment=' . urlencode($details['bio_data_comment'])
                                    : '';

                            $queryString .=
                                !empty($details) && !empty($details['address'])
                                    ? '&address=' . $details['address']
                                    : '';
                            $queryString .=
                                !empty($details) && !empty($details['emergency_contact_number'])
                                    ? '&emergency_contact_number=' . $details['emergency_contact_number']
                                    : '';

                            if (!empty($area)) {
                                foreach ($area as $item) {
                                    if (!empty($details) && !empty($details['area']) && $details['area'] == $item->id) {
                                        $queryString .=
                                            !empty($details) && !empty($details['area']) ? '&area=' . $item->id : '';
                                    }
                                }
                            }

                            if (!empty($area)) {
                                foreach ($city as $item) {
                                    if (!empty($details) && !empty($details['city']) && $details['city'] == $item->id) {
                                        $queryString .=
                                            !empty($details) && !empty($details['city']) ? '&city=' . $item->id : '';
                                    }
                                }
                            }

                            $queryString .=
                                !empty($details) && !empty($details['guardianname'])
                                    ? '&guardianname=' . $details['guardianname']
                                    : '';

                            $queryString .=
                                !empty($details) && !empty($details['blood_group'])
                                    ? '&blood_group=' . $details['blood_group']
                                    : '';

                            $classLabels1 = [
                                '0' => 'Play group',
                                '00' => 'KG-1',
                                '000' => 'KG-2',
                            ];

                            $queryStringClass = $classLabels1[$details['class']] ?? $details['class'];

                            $classLabels = [
                                '0' => 'Play group',
                                '00' => 'KG-1',
                                '000' => 'KG-2',
                                '1' => '1',
                                '2' => '2',
                                '3' => '3',
                                '4' => '4',
                                '5' => '5',
                                '6' => '6',
                                '7' => '7',
                                '8' => '8',
                                '9' => '9',
                                '10' => '10',
                                '11' => '11',
                                '12' => '12',
                            ];

                            $selectedClass = old('class', $details['class'] ?? '');

                            $queryString .= !empty($details) ? '&class=' . $selectedClass : '';

                        ?>



                        <?php if(auth()->guard('admin')->check() &&
                                (auth()->guard('admin')->user()->role == 1 || auth()->guard('admin')->user()->role == 2)): ?>
                            <!-- Button to Open the Modal -->
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#PrescriptionModal">
                            ADVICE <span class="material-icons sidebar-menu-icon ml-2">add</span>
                            </button>
                        <?php endif; ?>


                        <!-- The Modal -->
                        <div class="modal fade" id="PrescriptionModal" tabindex="-1" role="dialog"
                            aria-labelledby="PrescriptionModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="PrescriptionModalLabel">ADVICE</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>

                                    <form action="<?php echo e(route('Prescription')); ?>" method="POST" id="prescriptionForm">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-body">
                                            <!-- Form Starts Here -->


                                            <input type="hidden" readonly name="form_entry_id" value="<?php echo e($details['id']); ?>"
                                                required>

                                            <?php

                                                //  $Doctors = user::where('designation', '>',0)->get()->toArray();
                                                $Doctors = User::whereIn('designation', [1, 2, 3])->get();

                                            ?>
                                            <!-- Select Box -->
                                            <div class="form-group">
                                                <label for="DoctorID">Select Doctor</label>
                                                <select class="form-control" id="DoctorID" name="DoctorID" required>
                                                    <option value="">Select</option>
                                                    <?php if(!empty($Doctors)): ?>
                                                        <?php $__currentLoopData = $Doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($Doctor['id']); ?>"><?php echo e($Doctor['fullname']); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>

                                                    

                                                </select>
                                            </div>

                                            <!-- Reason -->
                                            <div class="form-group">
                                                <label for="textarea">Reason</label>
                                                <textarea class="form-control" id="Reason" name="Reason" rows="3" required></textarea>
                                            </div>

                                            <!-- Prescription -->
                                            <div class="form-group">
                                                <label for="Prescription">Prescription</label>
                                                <input type="text" class="form-control" id="Prescription"
                                                    name="Prescription" required>
                                            </div>
                                            <!-- Form Ends Here -->
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary" id="submitButton">Submit</button>
                                        </div>
                                    </form>


                                </div>
                            </div>
                        </div>

                        &nbsp;
                        &nbsp;
                        &nbsp;

                        <?php if(auth()->guard('admin')->check() &&
                                (auth()->guard('admin')->user()->role == 1 || auth()->guard('admin')->user()->role == 2)): ?>
                            <!-- Button to Open the Modal -->
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#AidsModal">
                                Aids <span class="material-icons sidebar-menu-icon ml-2">add</span>
                            </button>
                        <?php endif; ?>

                        <!-- The Modal -->
                        <div class="modal fade" id="AidsModal" tabindex="-1" role="dialog"
                            aria-labelledby="AidsModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="AidsModalLabel">Aids</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>

                                    <form action="<?php echo e(route('Aids')); ?>" method="POST" id="aidsForm">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-body">
                                            <!-- Form Starts Here -->


                                            <input type="hidden" readonly name="form_entry_id" value="<?php echo e($details['id']); ?>"
                                                required>

                                            <?php

                                                //  $Doctors = user::where('designation', '>',0)->get()->toArray();
                                                $Doctors = User::whereIn('designation', [1, 2, 3])->get();

                                            ?>
                                            <!-- Select Box -->
                                            <div class="form-group">
                                                <label for="DoctorID">Select Doctor</label>
                                                <select class="form-control" id="DoctorID" name="DoctorID" required>
                                                    <option value="">Select</option>
                                                    <?php if(!empty($Doctors)): ?>
                                                        <?php $__currentLoopData = $Doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($Doctor['id']); ?>"><?php echo e($Doctor['fullname']); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>

                                                    

                                                </select>
                                            </div>

                                            <!-- Reason -->
                                            <div class="form-group">
                                                <label for="textarea">Reason</label>
                                                <textarea class="form-control" id="Reason" name="Reason" rows="3" required></textarea>
                                            </div>

                                            <!-- Aids -->
                                            <div class="form-group">
                                                <label for="Aids">Aids</label>
                                                <input type="text" class="form-control" id="Aids" name="Aids"
                                                    required>
                                            </div>
                                            <!-- Form Ends Here -->
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary"
                                                id="submitButton1">Submit</button>
                                        </div>
                                    </form>


                                </div>
                            </div>
                        </div>


                        &nbsp;
                        &nbsp;
                        &nbsp;

                        <?php if(auth()->guard('admin')->check() &&
                                (auth()->guard('admin')->user()->role == 1 || auth()->guard('admin')->user()->role == 2)): ?>
                            <!-- Button to Open the Modal -->
                            <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#LabsModal">
                                Labs <span class="material-icons sidebar-menu-icon ml-2">add</span>
                            </button>
                        <?php endif; ?>

                        <!-- The Modal -->
                        <div class="modal fade" id="LabsModal" tabindex="-1" role="dialog"
                            aria-labelledby="LabsModalLabel" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="LabsModalLabel">Upload Labs Data</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>

                                    <form action="<?php echo e(route('Labs')); ?>" method="POST" enctype="multipart/form-data"
                                        id="labsForm">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-body">
                                            <!-- Form Starts Here -->

                                            <input type="hidden" name="form_entry_id" value="<?php echo e($details['id']); ?>"
                                                required>

                                            <!-- Title Field -->
                                            <div class="form-group">
                                                <label for="title">Title</label>
                                                <input type="text" class="form-control" id="title" name="title"
                                                    required>
                                            </div>


                                            <!-- File Upload -->
                                            <div class="form-group">
                                                <label for="fileUpload">Upload Files</label>
                                                <input type="file" class="form-control" id="fileUpload"
                                                    name="files[]" multiple required>
                                            </div>

                                            <!-- Additional fields can be added here -->

                                            <!-- Form Ends Here -->
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary"
                                                id="submitButton2">Submit</button>
                                        </div>
                                    </form>

                                </div>
                            </div>
                        </div>


                        <?php if(auth()->guard('admin')->check() &&
                                (auth()->guard('admin')->user()->role == 1 || auth()->guard('admin')->user()->role == 2)): ?>
                            <a href="<?php echo e(route('CreateScreening')); ?>?<?php echo e($queryString); ?>" class="ml-2" target="_blank"
                                rel="noopener noreferrer">
                                <button class="btn btn-primary ml-auto d-block">Screening Form<span
                                        class="material-icons sidebar-menu-icon ml-2">add</span>
                                </button>
                            </a>

                            

                            <a href="<?php echo e(route('StudentBiodata')); ?>?<?php echo e($queryString); ?>" class="ml-2" target="_blank"
                                rel="noopener noreferrer">
                                <button class="btn btn-primary ml-auto d-block">MEDICAL HISTORY<span
                                        class="material-icons sidebar-menu-icon ml-2">add</span>
                                </button>
                            </a>
                        <?php endif; ?>

                        
                        

                        

                        


                    </div>
                </div>
            </div>

            <!-- Modal -->
            <div class="modal fade" id="uploadModal" tabindex="-1" aria-labelledby="uploadModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="uploadModalLabel">Upload Profile Image</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form id="uploadForm" action="<?php echo e(route('upload.profile.image')); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label for="profile_image">Choose an image</label>
                                    <input type="hidden" readonly name="updateID" value="<?php echo e($details['id']); ?>"
                                        required>
                                    <input type="file" class="form-control-file" id="profile_image"
                                        name="profile_image" required>
                                </div>
                                <button type="submit" class="btn btn-primary">Upload</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>


            <form>
                <h4 class="mt-5" style="color:#e55123;">Student Details</h4>

                <?php if(Session::has('error_message')): ?>
                    <div class="alert alert-secondary dark alert-dismissible fade show" role="alert">
                        <strong>Error ! </strong>
                        <?php echo e(Session::get('error_message')); ?>.


                    </div>
                <?php endif; ?>

                <?php if(Session::has('success_message')): ?>
                    <div class="alert alert-success dark alert-dismissible fade show" role="alert">
                        <strong>Success ! </strong>
                        <?php echo e(Session::get('success_message')); ?>.


                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>


                <div class="row mt-2">
                    <div class="col-6">






                        <div class="mb-1 row ms-0 align-items-center">
                            <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Profile Image
                                :</label>
                            <div class="col-md-5 position-relative">
                                <?php
                                    // Define the default image path
                                    $defaultImage = asset('uploads/student/profile_images/default.png');

                                    // Check if the profile image exists
                                    $profileImagePath = $details['profile_image'] ?? null;

                                    $imagePath = public_path("uploads/student/profile_images/{$profileImagePath}");

                                    $profileImageUrl = file_exists($imagePath)
                                        ? asset('uploads/student/profile_images/' . $profileImagePath)
                                        : $defaultImage;

                                ?>

                                <!-- Display the profile image or the default image -->
                                <img src="<?php echo e($profileImageUrl); ?>" alt="Profile Image" class="img-fluid mt-1"
                                    style="max-width: 100px; max-height: 100px;">

                                <!-- Change image trigger -->
                                <button type="button" class="btn btn-secondary position-absolute" data-toggle="modal"
                                    data-target="#uploadModal" id="changeImageBtn" style="bottom: 10px; right: 10px;">
                                    <i class="fas fa-camera"></i>
                                </button>
                            </div>
                        </div>


                        <div class="mb-1 row ms-0 align-items-center">
                            <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Name :</label>
                            <div class="col-md-9">
                                <label class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($details['name']); ?> </label>
                            </div>
                        </div>

                        <div class="mb-1 row ms-0 align-items-center">
                            <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Gender
                                :</label>
                            <div class="col-md-9">
                                <label class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($details['gender']); ?></label>
                            </div>
                        </div>
                        <div class="mb-1 row ms-0 align-items-center">
                            <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">City :</label>
                            <div class="col-md-9">
                                <label class="col-md-6 col-form-label mt-1 fs_15">

                                    <?php if(!empty($city)): ?>
                                        <?php $__currentLoopData = $city; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($details['city'] == $item->id): ?>
                                                <?php echo e($item->name); ?>

                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>

                                </label>
                            </div>
                        </div>
                        <div class="mb-1 row ms-0 align-items-center">
                            <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Date Of Birth
                                :</label>
                            <div class="col-md-9">
                                
                                <label class="col-md-6 col-form-label mt-1 fs_15">
                                    <?php echo e(\Carbon\Carbon::parse($details['dob'])->format('d M Y')); ?>


                                </label>
                            </div>
                        </div>
                        <div class="mb-1 row ms-0 align-items-center">
                            <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Emergency
                                Contact
                                Number :</label>
                            <div class="col-md-9">
                                <label
                                    class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($details['emergency_contact_number']); ?></label>
                            </div>
                        </div>
                        <div class="mb-1 row ms-0 align-items-center">
                            <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Address
                                :</label>
                            <div class="col-md-9">
                                <label class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($details['address']); ?></label>
                            </div>
                        </div>

                    </div>
                    <div class="col-6">
                        <div>
                            <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Guardian
                                    Name
                                    :</label>
                                <div class="col-md-9">
                                    <label
                                        class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($details['guardianname']); ?></label>
                                </div>
                            </div>
                            <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">School
                                    :</label>
                                <div class="col-md-9">
                                    <label class="col-md-6 col-form-label mt-1 fs_15">

                                        <?php if(!empty($school)): ?>
                                            <?php $__currentLoopData = $school; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($details['school'] == $item->id): ?>
                                                    <?php echo e($item->school_name); ?>

                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                    </label>
                                </div>
                            </div>
                            <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Area
                                    :</label>
                                <div class="col-md-9">
                                    <label class="col-md-6 col-form-label mt-1 fs_15">
                                        <?php if(!empty($area)): ?>
                                            <?php $__currentLoopData = $area; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($details['area'] == $item->id): ?>
                                                    <?php echo e($item->name); ?>

                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                    </label>
                                </div>
                            </div>
                            <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Age (Year:Month)
                                    :</label>
                                <div class="col-md-9">
                                    <?php
                                         $renderAge = '';
                                         if (!empty($details['dob'])) {
                                             $dob = \Carbon\Carbon::parse($details['dob']);
                                             $now = \Carbon\Carbon::now();
                                             $diff = $dob->diff($now);
                                             $years = $diff->y;
                                             $months = $diff->m;
                                             $renderAge = $years . ':' . str_pad($months, 2, '0', STR_PAD_LEFT);
                                         } else {
                                             $renderAge = isset($details['age']) && $details['age'] !== '' ? $details['age'] . ':00' : '';
                                         }
                                     ?>
                                     <label class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($renderAge); ?></label>
                                </div>
                            </div>
                            <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">GR Number
                                    :</label>
                                <div class="col-md-9">
                                    <label class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($details['gr_number']); ?></label>
                                </div>
                            </div>
                            <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Blood
                                    Group
                                    :</label>
                                <div class="col-md-9">
                                    <label
                                        class="col-md-6 col-form-label mt-1 fs_15"><?php echo e($details['blood_group']); ?></label>
                                </div>
                            </div>
                            <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Class
                                    :</label>
                                <div class="col-md-9">


                                    <?php
                                        $classLabels = [
                                            '0' => 'Play group',
                                            '00' => 'KG-1',
                                            '000' => 'KG-2',
                                        ];
                                    ?>

                                    <label class="col-md-6 col-form-label mt-1 fs_15">
                                        <?php echo e($classLabels[$details['class']] ?? $details['class']); ?>

                                    </label>


                                </div>
                            </div>


  <div class="mb-1 row ms-0 align-items-center">
                                <label class="col-md-3 col-form-label leaddetailslabel fs_15 font-weight-bolder">Section
                                    :</label>
                                <div class="col-md-9">


                                   

                                    <label class="col-md-6 col-form-label mt-1 fs_15">
                                        <?php echo e($classLabels[$details['class_section']] ?? $details['class_section']??'-'); ?>

                                    </label>


                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Button to open the modal -->
                

            </form>






            <div class="row mt-5 align-items-center">
                <div class="col-md-12">
                    <h4 class="mt-5" style="color:#e55123;">Screening</h4>
                </div>


                <div class="col-md-12 d-flex align-items-center flex-wrap" id="customId">

                    


                    <div class="dropdown">
                        <div class="btn-group mb-0">
                            <button class="dropbtn btn-primary btn-round" type="button">Screening at <?php echo e(\Carbon\Carbon::parse($form_date)->format('d-m-Y')); ?>


                                <span><i class="icofont icofont-arrow-down"></i></span></button>
                            <div class="dropdown-content col-md-6 flex justify">
                                <a href="<?php echo e(Route('Medical_Detail', $form_id)); ?>")">&nbsp;<i class="fa fa-eye"></i> View </a>
                                <a href="<?php echo e(Route('UpdateScreening', $form_id)); ?>")">&nbsp;<i class="fa fa-edit"></i> Edit </a>

                            </div>
                        </div>
                    </div>
                   
                  
                    

                    <?php
                        $form_entry_screening = form_entry::where('screeningFormId', $form_id)->get()->toArray();
                        ?>
                        <?php if(!empty($form_entry_screening)): ?>
                        <?php $__currentLoopData = $form_entry_screening; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                       
                        <div class="dropdown">
                                <div class="btn-group mb-0">
                                    <button class="dropbtn btn-primary btn-round" type="button">Screening at
                                        
                                         <?php echo e(\Carbon\Carbon::parse($value['created_at'])->format('d-m-Y')); ?>


                                        <span><i class="icofont icofont-arrow-down"></i></span></button>
                                    <div class="dropdown-content col-md-6 flex justify">
                                        <a href="<?php echo e(Route('Medical_Detail', $value['id'])); ?>")">&nbsp;<i class="fa fa-eye"></i> View</a>
                                        <a href="<?php echo e(Route('UpdateScreening', $value['id'])); ?>")">&nbsp;<i class="fa fa-edit"></i> Edit</a>
                                        <a href="<?php echo e(Route('DeleteRecord', $value['id'])); ?>"
                                            onclick="return confirm(\'Are you sure you want to delete this record?\');">&nbsp;<i class="fa fa-trash"></i> Delete</a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>


                    







                </div>










                <div class="col-md-12">
                    <h4 class="mt-5" style="color:#e55123;">Medical History</h4>
                </div>

                <div class="col-md-12 d-flex align-items-center flex-wrap" id="customId">
                    <?php if($medical_history_id->isNotEmpty()): ?>
                        <?php $__currentLoopData = $medical_history_id; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medical_id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!-- <a href="<?php echo e(route('ViewMedicalHistory1', $medical_id)); ?>" class="ScreeningAnchor mr-3"
                            data-id="<?php echo e($medical_id); ?>">
                            <button class="btn btn-primary">MedicalHistory Ref# <?php echo e($medical_id); ?></button>
                        </a> -->
                        <?php
                             $diagnoses = collect();

                             $icd1 = NutritionistHistoryEvaluationSection::where('StudentBiodataId', $medical_id)->value('Provisional_Diagnosis1');
                             $icd2 = PsychologistHistoryAssessmentSection::where('StudentBiodataId', $medical_id)->value('Provisional_Diagnosis2');
                             $icd3 = SchoolHealthPhysician::where('StudentBiodataId', $medical_id)->value('Provisional_Diagnosis');
                             $BioDataDate = StudentBiodata::where('id', $medical_id)->value('created_at');
                         
                             // Merge and split by "|"
                             foreach ([$icd1, $icd2, $icd3] as $icd) {
                                 if (!empty($icd)) {
                                     $parts = explode('|', $icd);
                                     $diagnoses = $diagnoses->merge($parts);
                                 }
                             }
                            //  dd($diagnoses);
                        ?>
                        <div class="dropdown">
                            <div class="btn-group mb-0">
                                <a href="<?php echo e(route('ViewMedicalHistory1', $medical_id)); ?>" class="dropbtn btn-primary btn-round">
                                    MedicalHistory at 
                                    <?php echo e(\Carbon\Carbon::parse($BioDataDate)->format('d-m-Y')); ?>

                                    <span><i class="icofont icofont-arrow-down"></i></span>
                                </a>
                                <div class="dropdown-content col-md-6 flex justify">
                                <?php $__currentLoopData = $diagnoses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $diagnosis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="#"><?php echo e($diagnosis); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </div>




                <div class="col-md-12" data-toggle="collapse" data-target="#followupsContent" aria-expanded="false"
                    aria-controls="followupsContent" style="cursor: pointer;">
                    <h4 class="mt-5" style="color:#e55123;">
                        Followup Details - <?php echo e(count($followUps)); ?>

                        <!-- Toggle button for collapse -->
                        <button class="btn btn-secondary btn-sm float-right" type="button" data-toggle="collapse"
                            data-target="#followupsContent" aria-expanded="false" aria-controls="followupsContent">
                            <i class="fas fa-chevron-down"></i> <!-- You can use a chevron icon or other icons -->
                        </button>
                    </h4>
                </div>

                <!-- Collapsible content -->
                <!-- <div class="col-md-12 collapse" id="followupsContent">
                    <div class="d-flex align-items-center">
                        <?php if(!empty($medicalComplain)): ?>
                            <?php $__currentLoopData = $medicalComplain; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medicalComplai): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                        <?php if(!empty($StudentBiodata)): ?>
                            <?php $__currentLoopData = $StudentBiodata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $StudentBiodat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $SchoolHealthPhysician = SchoolHealthPhysician::where('deleted', 0)
                                        ->where('Follow_up_Required', 'yes')
                                        ->where('StudentBiodataId', $StudentBiodat->id)
                                        ->get()
                                        ->toArray();
                                ?>
                                <?php if(!empty($SchoolHealthPhysician)): ?>
                                    <?php $__currentLoopData = $SchoolHealthPhysician; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $SchoolHealthPhysicia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(Route('ViewMedicalHistory1')); ?>/<?php echo e($SchoolHealthPhysicia['StudentBiodataId']); ?>"
                                            class="btn btn-primary mr-2 followupsContentCount" target="_blank">
                                            Followup - <?php echo e(date('M-d-Y', strtotime($SchoolHealthPhysicia['created_at']))); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <?php
                                    $NutritionistHistoryEvaluationSection = NutritionistHistoryEvaluationSection::where(
                                        'deleted',
                                        0,
                                    )
                                        ->where('Follow_up_Required1', 'yes')
                                        ->where('StudentBiodataId', $StudentBiodat->id)
                                        ->get()
                                        ->toArray();
                                ?>
                                <?php if(!empty($NutritionistHistoryEvaluationSection)): ?>
                                    <?php $__currentLoopData = $NutritionistHistoryEvaluationSection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $NutritionistHistoryEvaluationSectio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(Route('ViewMedicalHistory1')); ?>/<?php echo e($NutritionistHistoryEvaluationSectio['StudentBiodataId']); ?>"
                                            class="btn btn-primary mr-2 followupsContentCount" target="_blank">
                                            Followup -
                                            <?php echo e(date('M-d-Y', strtotime($NutritionistHistoryEvaluationSectio['created_at']))); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>

                                <?php
                                    $PsychologistHistoryAssessmentSection = PsychologistHistoryAssessmentSection::where(
                                        'deleted',
                                        0,
                                    )
                                        ->where('Follow_up_Required2', 'yes')
                                        ->where('StudentBiodataId', $StudentBiodat->id)
                                        ->get()
                                        ->toArray();
                                ?>
                                <?php if(!empty($PsychologistHistoryAssessmentSection)): ?>
                                    <?php $__currentLoopData = $PsychologistHistoryAssessmentSection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $PsychologistHistoryAssessmentSectio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(Route('ViewMedicalHistory1')); ?>/<?php echo e($PsychologistHistoryAssessmentSectio['StudentBiodataId']); ?>"
                                            class="btn btn-primary mr-2 followupsContentCount" target="_blank">
                                            Followup -
                                            <?php echo e(date('M-d-Y', strtotime($PsychologistHistoryAssessmentSectio['created_at']))); ?>

                                        </a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                        
                    </div>
                </div> -->

                <!-- FollowUpDropDown -->

                <div class="row collapse" id="followupsContent" style="">
                <?php if(!empty($followUps)): ?>
                <?php $__currentLoopData = $followUps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $followUp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-12">
                            <h4 class="mt-5" style="color:#e55123;">
                                                                    
                                                            </h4>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Follow Up Date:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e(date('M-d-Y', strtotime($followUp->created_at))); ?></span>
                            </div>
                        </div>


                        


                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Reference Number:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($followUp->ref); ?></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">ICD:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($followUp->icd); ?></span>
                            </div>
                        </div>

                       
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Reason:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($followUp->reason); ?> </span>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Description:</label>

                                             <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($followUp->comment); ?></span>
                                            

                                
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    </div>
            </div>







            <div class="row" data-toggle="collapse" data-target="#detailsCollapse" style="cursor: pointer;">

                <div class="col-md-12">
                    <h4 class="mt-5" style="color:#e55123;">

                        Additional Details - <?php echo e(count($StudentBiodata) + count($findings)); ?>

                        <button class="btn btn-secondary btn-sm float-right" type="button" data-toggle="collapse"
                            data-target="#detailsCollapse" aria-expanded="false" aria-controls="detailsCollapse">
                            <i class="fas fa-chevron-down"></i>
                        </button>
                    </h4>
                </div>
            </div>

                        <!-- <?php
                    $Screeningform = form_entry::where('screeningFormId', $form_id)
                    ->orWhere('id', $form_id)
                    ->get()
                    ->toArray(); 
                
                    ?> -->
            <?php if(!empty($findings)): ?>
                <?php $__currentLoopData = $findings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $findingsData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div class="row collapse" id="detailsCollapse">

                        <div class="col-md-12">
                            <h4 class="mt-5" style="color:#e55123;">
                                <?php if($key == 0): ?>
                                    
                                <?php endif; ?>
                            </h4>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Date of Encounter:</label>
                                <span
                                    class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e(\Carbon\Carbon::parse($findingsData['created_at'])->format('d M Y, H:i')); ?></span>
                            </div>
                        </div>


                        <?php
                          

                          
                        ?>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Number of Encounter :</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($findingsData['count']); ?></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Encounter Type:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">Screened Form</span>
                            </div>
                        </div>

                       
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Encounter with:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                    <?php 
                                    $UserDetails = user::where('id', $findingsData['created_by'])->first();
                                    ?>
                                <?php echo e($UserDetails['fullname']); ?>

                                </span>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Reportables:</label>

                                             <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($findingsData['questions_with_answers']); ?></span>
                                            

                                
                            </div>
                        </div>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            <?php if(!empty($StudentBiodata)): ?>
                <?php $__currentLoopData = $StudentBiodata; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $StudentBiodat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row collapse" id="detailsCollapse">

                        <div class="col-md-12">
                            <h4 class="mt-5" style="color:#e55123;">
                                <?php if($key == 0): ?>
                                    
                                <?php endif; ?>
                            </h4>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Date of Encounter:</label>
                                <span
                                    class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e(\Carbon\Carbon::parse($StudentBiodat['created_at'])->format('d M Y, H:i')); ?></span>
                            </div>
                        </div>


                        <?php

                            $CountTotal = 0;
                            $CountLow = 0;
                            $CountHigh = 0;

                            $SchoolHealthPhysician5 = SchoolHealthPhysician::where('deleted', 0)
                                ->where('StudentBiodataId', $StudentBiodat['id'])
                                ->first();
                            if (!empty($SchoolHealthPhysician5)) {
                                $Blood_pressure_result = $SchoolHealthPhysician5['Blood_pressure_result'];

                                if ($Blood_pressure_result == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($Blood_pressure_result == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $BloodPressureDiastolicResult = $SchoolHealthPhysician5['BloodPressureDiastolicResult'];

                                if ($BloodPressureDiastolicResult == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($BloodPressureDiastolicResult == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $TemperatureResult = $SchoolHealthPhysician5['TemperatureResult'];

                                if ($TemperatureResult == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($TemperatureResult == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $PulseResult = $SchoolHealthPhysician5['PulseResult'];

                                if ($PulseResult == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($PulseResult == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $RespiratoryRateResult = $SchoolHealthPhysician5['RespiratoryRateResult'];

                                if ($RespiratoryRateResult == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($RespiratoryRateResult == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $WeightResult = $SchoolHealthPhysician5['WeightResult'];

                                if ($WeightResult == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($WeightResult == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $HeightResult = $SchoolHealthPhysician5['WeightResult'];

                                if ($HeightResult == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($HeightResult == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $BMIResult = $SchoolHealthPhysician5['BMIResult'];

                                if ($BMIResult == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($BMIResult == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }
                            }

                            $NutritionistHistoryEvaluationSection2 = NutritionistHistoryEvaluationSection::where(
                                'deleted',
                                0,
                            )
                                ->where('StudentBiodataId', $StudentBiodat['id'])
                                ->first();

                            if (!empty($NutritionistHistoryEvaluationSection2)) {
                                $HeightResult1 = $NutritionistHistoryEvaluationSection2['HeightResult1'];

                                if ($HeightResult1 == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($HeightResult1 == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $WeightResult1 = $NutritionistHistoryEvaluationSection2['WeightResult1'];

                                if ($WeightResult1 == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($WeightResult1 == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }

                                $BMIResult1 = $NutritionistHistoryEvaluationSection2['BMIResult1'];

                                if ($BMIResult1 == 'Low') {
                                    $CountLow += 1;
                                    $CountTotal += 1;
                                }
                                if ($BMIResult1 == 'High') {
                                    $CountHigh += 1;
                                    $CountTotal += 1;
                                }
                            }
                        ?>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Number of Encounter :</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($CountTotal); ?></span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Encounter Type:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">Medical History</span>
                            </div>
                        </div>

                        <?php

                            $StudentBiodat_created_by_updated_by =
                                $StudentBiodat['created_by'] == 0
                                    ? $StudentBiodat['updated_by']
                                    : $StudentBiodat['created_by'];

                            $UserDetails = user::where('id', $StudentBiodat_created_by_updated_by)->first();

                        ?>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Encounter with:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                    <?php if(!empty($UserDetails)): ?>
                                        <?php echo e($UserDetails['fullname']); ?>

                                    <?php endif; ?>
                                </span>
                            </div>

                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Reportables:</label>

                                <?php

                                    /* School Health Physician */

                                    $SchoolHealthPhysician5 = SchoolHealthPhysician::where('deleted', 0)
                                        ->where('StudentBiodataId', $StudentBiodat['id'])
                                        ->first();

                                    if (!empty($SchoolHealthPhysician5)) {
                                        $Blood_pressure_result = $SchoolHealthPhysician5['Blood_pressure_result'];

                                        if ($Blood_pressure_result == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Blood Pressure (Systolic) Low</span>';
                                        }
                                        if ($Blood_pressure_result == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Blood Pressure (Systolic) High</span>';
                                        }

                                        $BloodPressureDiastolicResult =
                                            $SchoolHealthPhysician5['BloodPressureDiastolicResult'];

                                        if ($BloodPressureDiastolicResult == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Blood Pressure (Diastolic) Low </span>';
                                        }
                                        if ($BloodPressureDiastolicResult == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Blood Pressure (Diastolic) High</span>';
                                        }

                                        $TemperatureResult = $SchoolHealthPhysician5['TemperatureResult'];

                                        if ($TemperatureResult == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Temperature  Low </span>';
                                        }
                                        if ($TemperatureResult == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Temperature  High</span>';
                                        }

                                        $PulseResult = $SchoolHealthPhysician5['PulseResult'];

                                        if ($PulseResult == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Pulse   Low </span>';
                                        }
                                        if ($PulseResult == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Pulse   Low </span>';
                                        }

                                        $RespiratoryRateResult = $SchoolHealthPhysician5['RespiratoryRateResult'];

                                        if ($RespiratoryRateResult == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Respiratory Rate   Low </span>';
                                        }
                                        if ($RespiratoryRateResult == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Respiratory Rate   Low </span>';
                                        }

                                        $WeightResult = $SchoolHealthPhysician5['WeightResult'];

                                        if ($WeightResult == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Weight   Low </span>';
                                        }
                                        if ($WeightResult == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Weight   Low </span>';
                                        }

                                        $HeightResult = $SchoolHealthPhysician5['WeightResult'];

                                        if ($HeightResult == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Height    Low </span>';
                                        }
                                        if ($HeightResult == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Height    Low </span>';
                                        }

                                        $BMIResult = $SchoolHealthPhysician5['BMIResult'];

                                        if ($BMIResult == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">BMI   Low </span>';
                                        }
                                        if ($BMIResult == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">BMI   Low </span>';
                                        }
                                    }

                                    /* Nutritionist History & Evaluation Section */

                                    $NutritionistHistoryEvaluationSection2 = NutritionistHistoryEvaluationSection::where(
                                        'deleted',
                                        0,
                                    )
                                        ->where('StudentBiodataId', $StudentBiodat['id'])
                                        ->first();

                                    if (!empty($NutritionistHistoryEvaluationSection2)) {
                                        $HeightResult1 = $NutritionistHistoryEvaluationSection2['HeightResult1'];

                                        if ($HeightResult1 == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Height (cm)Low</span><br>';
                                        }
                                        if ($HeightResult1 == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Height (cm) Low</span><br>';
                                        }

                                        $WeightResult1 = $NutritionistHistoryEvaluationSection2['WeightResult1'];

                                        if ($WeightResult1 == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Weight (kg) Low</span><br>';
                                        }
                                        if ($WeightResult1 == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">Weight (kg)  Low</span><br>';
                                        }

                                        $BMIResult1 = $NutritionistHistoryEvaluationSection2['BMIResult1'];

                                        if ($BMIResult1 == 'Low') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">BMI (auto-generated)  Low</span><br>';
                                        }
                                        if ($BMIResult1 == 'High') {
                                            echo '<span class="fs_15 font-weight-bolder ml-2 text-dark">BMI (auto-generated) Low</span><br>';
                                        }
                                    }

                                ?>

                                
                            </div>
                        </div>

                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>


            

            <div class="row" data-toggle="collapse" data-target="#prescriptionCollapse" style="cursor: pointer;">

                <div class="col-md-12">
                    <h4 class="mt-5" style="color:#e55123;">


                        Prescription - <?php echo e(count($Prescription)); ?>


                        <button class="btn btn-secondary btn-sm float-right" type="button" data-toggle="collapse"
                            data-target="#prescriptionCollapse" aria-expanded="false"
                            aria-controls="prescriptionCollapse">
                            <i class="fas fa-chevron-down"></i>
                        </button>

                    </h4>
                </div>
            </div>

            


            <?php if(!empty($Prescription)): ?>
                <?php $__currentLoopData = $Prescription; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $Prescriptio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row collapse" id="prescriptionCollapse">

                        <div class="col-md-12">
                            <h4 class="mt-5" style="color:#e55123;">


                                <?php if($key == 0): ?>
                                    
                                <?php endif; ?>
                            </h4>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Date:</label>
                                <span
                                    class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e(\Carbon\Carbon::parse($Prescriptio['created_at'])->format('d M Y, H:i')); ?></span>
                            </div>
                        </div>


                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Doctor:</label>

                                <?php
                                    $detailsUser = user::find($Prescriptio['DoctorID']);
                                ?>


                                <span
                                    class="fs_15 font-weight-bolder ml-2 text-dark"><?php echo e($detailsUser['fullname'] ?? ''); ?></span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Reason:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark"> <?php echo e($Prescriptio['Reason'] ?? ''); ?>

                                </span>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Prescription:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                    <?php echo e($Prescriptio['Prescription'] ?? ''); ?> </span>
                            </div>
                        </div>


                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>



            <div class="row" data-toggle="collapse" data-target="#aidsCollapse" style="cursor: pointer;">
                <div class="col-md-12">
                    <h4 class="mt-5" style="color:#e55123;">
                        Aids - <?php echo e(count($Aids)); ?>

                        <!-- Toggle button for collapse -->
                        <button class="btn btn-secondary btn-sm float-right" type="button" data-toggle="collapse"
                            data-target="#aidsCollapse" aria-expanded="false" aria-controls="aidsCollapse">
                            <i class="fas fa-chevron-down"></i>
                        </button>
                    </h4>
                </div>
            </div>

            <!-- Collapsible content -->
            <div class="col-md-12 collapse" id="aidsCollapse">
                <?php if(!empty($Aids)): ?>
                    <?php $__currentLoopData = $Aids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $Aid): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="" class="fs_15 font-weight-bolder">Date:</label>
                                    <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                        <?php echo e(\Carbon\Carbon::parse($Aid['created_at'])->format('d M Y, H:i')); ?>

                                    </span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="" class="fs_15 font-weight-bolder">Doctor:</label>
                                    <?php
                                        $detailsUser = user::find($Aid['DoctorID']);
                                    ?>
                                    <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                        <?php echo e($detailsUser['fullname'] ?? ''); ?>

                                    </span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="" class="fs_15 font-weight-bolder">Reason:</label>
                                    <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                        <?php echo e($Aid['Reason'] ?? ''); ?>

                                    </span>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="" class="fs_15 font-weight-bolder">Aids:</label>
                                    <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                        <?php echo e($Aid['Aids'] ?? ''); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </div>



            <!-- Collapsible toggle header -->
            <div class="row" data-toggle="collapse" data-target="#labsCollapse" style="cursor: pointer;">
                <div class="col-md-12">
                    <h4 class="mt-5" style="color:#e55123;">
                        Labs - <?php echo e(count($Labs)); ?>

                        <!-- Add an icon to indicate collapse/expand state -->

                        <button class="btn btn-secondary btn-sm float-right" type="button" data-toggle="collapse"
                            data-target="#labsCollapse" aria-expanded="false" aria-controls="aidsCollapse">
                            <i class="fas fa-chevron-down"></i>
                        </button>

                    </h4>
                </div>
            </div>

            <!-- Collapsible content -->
            <?php if(!empty($Labs)): ?>
                <?php $__currentLoopData = $Labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $Lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row collapse" id="labsCollapse">
                        <div class="col-md-12">
                            <h4 class="mt-5" style="color:#e55123;">
                                <?php if($key == 0): ?>
                                    
                                <?php endif; ?>
                            </h4>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Date:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                    <?php echo e(\Carbon\Carbon::parse($Lab['created_at'])->format('d M Y, H:i')); ?>

                                </span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Title:</label>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                    <?php echo e($Lab['title'] ?? ''); ?>

                                </span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Uploaded By:</label>
                                <?php
                                    $detailsUser = user::find($Lab['created_by']);
                                ?>
                                <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                    <?php echo e($detailsUser['fullname'] ?? ''); ?>

                                </span>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="" class="fs_15 font-weight-bolder">Documents:</label>
                                <?php if(!empty($Lab['document_names'])): ?>
                                    <?php
                                        $documents = explode('|', $Lab['document_names']);
                                    ?>
                                    <ul>
                                        <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a href="<?php echo e(asset('uploads/labs/reports/' . $document)); ?>"
                                                    target="_blank">
                                                    <?php echo e($document); ?>

                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php else: ?>
                                    <span class="fs_15 font-weight-bolder ml-2 text-dark">
                                        No documents available
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>




        </div>
    </section>

    <script>
        $(document).ready(function() {

            document.getElementById('prescriptionForm').addEventListener('submit', function(event) {
                var submitButton = document.getElementById('submitButton');
                submitButton.disabled = true; // Disable the button
                submitButton.innerHTML = 'Processing...'; // Change button text
            });

            document.getElementById('aidsForm').addEventListener('submit', function(event) {
                var submitButton1 = document.getElementById('submitButton1');
                submitButton1.disabled = true; // Disable the button
                submitButton1.innerHTML = 'Processing...'; // Change button text
            });

            document.getElementById('labsForm').addEventListener('submit', function(event) {
                var submitButton2 = document.getElementById('submitButton2');
                submitButton2.disabled = true; // Disable the button
                submitButton2.innerHTML = 'Processing...'; // Change button text
            });



            $(document).on('click', '.ScreeningAnchor', function() {

                var id = $(this).data('id');
                console.log('id ' + id);


                var base_url = '<?php echo Route('GeneralInfo'); ?>';
                console.log("base_url " + base_url);
                $.ajax({
                    url: base_url,
                    type: 'POST',
                    data: {
                        "_token": "<?php echo e(csrf_token()); ?>",
                        id: id
                    },
                    success: function(response) {
                        // Handle success response
                        console.log('Success:', response);
                    },
                    error: function(xhr, status, error) {
                        // Handle error response
                        console.log('Error:', error);
                    }

                });


            });
        });
    </script>
<?php $__env->stopSection(); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $('#changeImageBtn').click(function() {
            $('#uploadModal').modal('show');
        });

        $(".FolowUpCount").html($(".followupsContentCount").length);
    });
</script>

<?php echo $__env->make('admin.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\AR\Desktop\cpshmerge\resources\views/Screening/Details.blade.php ENDPATH**/ ?>