<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <title>Health Report PDF</title>
    <style>
        @page {
            size: A3 landscape;
            margin: 20mm;
        }

        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }

            .wrapper {
                display: block;
            }
        }

        html,
        body {
            width: 100%;
            max-width: none;
            margin: 0 auto;
            overflow-x: hidden;
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 2px;
            font-size: 10px;
            font-weight: normal;
        }

        th,
        td {
            text-align: left;
            /* vertical-align: top; */
            padding: 1px 2px;
            font-size: 10px;
        }

        .heading {
            font-size: 26px;
            font-weight: bold;
            color: #2b8385;
            text-align: center;
        }

        .section-title {
            /* background-color: #f0f0f0; */
            background: #d5efee;
            font-weight: bold;
            padding: 2px 4px;
            border-bottom: 1px solid #ccc;
            height: auto;
            min-height: 20px;
            border-radius: 8px 8px 0 0 !important;
            -webkit-border-radius: 8px 8px 0 0 !important;
            -moz-border-radius: 8px 8px 0 0 !important;
            overflow: visible;
            white-space: nowrap;
            text-overflow: ellipsis;
        }

        .bordered {
            border: 1px solid #ccc;
        }

        .logo {
            width: 200px;
            image-rendering: crisp-edges;
            -webkit-print-color-adjust: exact;
        }

        .small {
            font-size: 11px;
        }

        .highlight {
            color: #d9534f;
            font-weight: bold;
        }

        .green {
            color: green;
        }

        .red {
            color: red;
        }

        .gray {
            color: #555;
            padding: 10px 0 10px 0;
            text-align: left !important;
        }

        .main-layout-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 5px;
            table-layout: fixed;
        }

        .main-layout-table td {
            width: 50%;
            vertical-align: top;
            padding: 3px;
        }

        /* Ensure all tables within main layout have proper styling */
        .main-layout-table table {
            border-radius: 8px !important;
            -webkit-border-radius: 8px !important;
            -moz-border-radius: 8px !important;
        }

        .main-layout-table tr {
            height: auto;
        }

        .left-wrapper,
        .right-wrapper {
            width: 100%;
            padding: 0;
            vertical-align: top;
        }




        .heading {
            text-align: start;
            margin: 0;
            color: #358b7d;
            font-weight: 700;
            font-size: 11px;
        }

        .main-heading {
            color: #358b7d;
            font-size: 14px;
            font-weight: 700;
            text-align: center;
        }

        .center-heading {
            text-align: center !important;
        }

        table.bordered {
            border: 1px solid #ccc;
            border-radius: 8px;
            margin-bottom: 3px;
            overflow: hidden;
        }

        table.black-bordered {
            border: 1px solid rgba(0, 0, 0, 0.12);
            border-radius: 8px;
            margin-bottom: 3px;
            overflow: hidden;
        }

        /* Ensure border-radius works in PDF */
        table.bordered,
        table.black-bordered {
            -webkit-border-radius: 8px;
            -moz-border-radius: 8px;
            border-radius: 8px;
        }

        .bordered td {
            /* border: 1px solid #ccc; */
            padding: 1px 2px;
            font-weight: 300;
            color: #848989;
            word-wrap: break-word;
            overflow-wrap: break-word;
        }

        /* Ensure all bordered sections have proper styling */
        .bordered,
        .black-bordered {
            border-radius: 8px !important;
            -webkit-border-radius: 8px !important;
            -moz-border-radius: 8px !important;
        }

        /* Force border-radius on all tables with borders */
        table[class*="bordered"] {
            border-radius: 8px !important;
            -webkit-border-radius: 8px !important;
            -moz-border-radius: 8px !important;
        }

        /* Ensure all section-title elements have proper border-radius */
        .section-title {
            border-radius: 8px 8px 0 0 !important;
            -webkit-border-radius: 8px 8px 0 0 !important;
            -moz-border-radius: 8px 8px 0 0 !important;
        }

        /* Force border-radius on section-title for PDF */
        .section-title,
        .section-title td {
            border-radius: 8px 8px 0 0 !important;
            -webkit-border-radius: 8px 8px 0 0 !important;
            -moz-border-radius: 8px 8px 0 0 !important;
            overflow: hidden;
        }

        /* Specific border-radius for section-title in bordered tables */
        table.bordered .section-title,
        table.black-bordered .section-title {
            border-radius: 8px 8px 0 0 !important;
            -webkit-border-radius: 8px 8px 0 0 !important;
            -moz-border-radius: 8px 8px 0 0 !important;
        }

        /* Ensure border-radius works in DomPDF */
        * {
            -webkit-border-radius: inherit;
            -moz-border-radius: inherit;
        }

        /* Override any inherited border styles for sign-off sections */
        .main-layout-table .black-bordered,
        .main-layout-table table.black-bordered {
            border: 2px solid #000 !important;
            border-radius: 8px !important;
            -webkit-border-radius: 8px !important;
            -moz-border-radius: 8px !important;
        }

        .general-health td {
            background-color: #fff4e6;
        }

        .general-health .center-heading {
            color: #c7795a;
        }

        /* .bordered tr:first-child td:first-child {
            border-top-left-radius: 10px;
        }

        .bordered tr:first-child td:last-child {
            border-top-right-radius: 10px;
            background: #d5efee;
        }

        .bordered tr:last-child td:first-child {
            border-bottom-left-radius: 10px;
        }

        .bordered tr:last-child td:last-child {
            border-bottom-right-radius: 10px;
        } */

        .wrapper {
            width: 100%;
            margin-bottom: 15px;
        }

        .two-column {
            width: 100%;
            margin-bottom: 15px;
        }

        .two-column-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 3px;
        }

        .two-column-table td {
            width: 50%;
            vertical-align: top;
            padding: 2px;
            overflow: visible;
        }

        /* Ensure sign-off tables have proper width */
        table#health-screening-conducted-by,
        table#rechecked-by,
        table#phsychological-screening-conducted-by,
        table#nutritional-assessment-by {
            width: 100% !important;
            table-layout: fixed;
        }

        .two-column-table table {
            width: 100%;
            margin-bottom: 0;
        }

        #mdcl-history,
        #vitals {
            background: #e9f7f7;
        }

        table#std-profile {
            background: #e9f7f7;
            width: 100%;
        }

        table#anthropometry {
            background-color: #e9f7f7;
        }

        table#dental-assessment {
            background-color: #d8edde;
        }

        table#dental-assessment .section-title {
            background-color: #d8edde;

        }

        table#dental-assessment .section-title .heading {
            color: #31332d;
        }

        table#developmental-screening {
            width: 100%;
            background-color: #fff6ed;
        }

        table#cardio-pulmonary {
            width: 100%;
            background-color: #fff6ed;
        }

        table#musculoskeletal-examination {
            background-color: #d8edde;
        }

        table#musculoskeletal-examination .section-title {
            background-color: #d8edde;
        }

        table#musculoskeletal-examination .section-title .heading {
            color: #31332d;
        }

        table#dermatological-assessment {
            background-color: #fff6ed;
        }

        table#dermatological-assessment .section-title {
            background-color: #fff6ed;
        }

        table#dermatological-assessment .section-title .heading {
            color: #c77859;
        }

        table#social-emotional-behevioral {
            width: 100%;
        }

        table#std-profile td {
            padding: 2px 6px;
        }


        table#general-health,
        table#general-health .section-title {
            background-color: #fff6ed;
        }

        /* table#general-health .section-title,
        table#developmental-screening .section-title {
            background-color: #fff4e6;
        } */

        table#general-health .section-title .heading,
        table#cardio-pulmonary .section-title .heading {
            color: #c77859;
        }

        table#vision-hearing,
        table#vision-hearing .section-title,
        table#physician-notes-1,
        table#physician-notes-1 .section-title {
            background-color: #e3e4f0;
        }

        table#vision-hearing .section-title .heading,
        table#social-emotional-behevioral .section-title .heading,
        table#autism-screening .section-title .heading,
        table#physician-notes-1 .section-title .heading,
        table#nutritional-assessment .section-title .heading,
        table#nutritional-assessment p {
            color: #30303c;
        }

        table#social-emotional-behevioral,
        table#social-emotional-behevioral .section-title,
        table#autism-screening,
        table#autism-screening .section-title {
            background-color: #ffe9da;
        }

        table#nutritional-assessment,
        table#nutritional-assessment .section-title {
            background-color: #dcecd2;
        }

        table#social-emotional-behevioral p,
        table#autism-screening p {
            color: #ffa98c;
        }

        table#physician-notes-1 p {
            color: #30303c;
        }

        table#health-screening-conducted-by .section-title,
        table#rechecked-by .section-title,
        table#phsychological-screening-conducted-by .section-title,
        table#nutritional-assessment-by .section-title {
            background-color: #004370;
            border-radius: 8px 8px 0 0 !important;
            -webkit-border-radius: 8px 8px 0 0 !important;
            -moz-border-radius: 8px 8px 0 0 !important;
        }

        /* Ensure all sign-off table section titles have proper border-radius */
        table#health-screening-conducted-by .section-title,
        table#rechecked-by .section-title,
        table#phsychological-screening-conducted-by .section-title {
            border-radius: 8px 8px 0 0 !important;
            -webkit-border-radius: 8px 8px 0 0 !important;
            -moz-border-radius: 8px 8px 0 0 !important;
        }

        table#health-screening-conducted-by .section-title .heading,
        table#rechecked-by .section-title .heading,
        table#phsychological-screening-conducted-by .section-title .heading,
        table#nutritional-assessment-by .section-title .heading {
            color: #ffffff;
        }

        /* Light gray color for p tags in specific tables */
        table#nutritional-assessment p,
        table#physician-notes-1 p {
            color: #848989 !important;
            margin: 0;
            padding: 2px 0;
        }

        table#nutritional-assessment .py-10 {
            padding: 10px 0;
        }

        table#health-screening-conducted-by tr,
        table#rechecked-by tr,
        table#phsychological-screening-conducted-by tr,
        table#nutritional-assessment-by tr {
            background-color: #ffffff;
        }


        table#health-screening-conducted-by td,
        table#rechecked-by td,
        table#phsychological-screening-conducted-by td,
        table#nutritional-assessment-by td {
            padding: 1px 2px !important;
            font-size: 10px;
        }

        /* Ensure sign-off tables have proper borders and border-radius */
        table#health-screening-conducted-by,
        table#rechecked-by,
        table#phsychological-screening-conducted-by,
        table#nutritional-assessment-by {
            border: 1px solid rgba(0, 0, 0, 0.12) !important;
            border-radius: 8px !important;
            -webkit-border-radius: 8px !important;
            -moz-border-radius: 8px !important;
            border-collapse: separate !important;
        }

        /* Force black borders on sign-off table cells */
        table#health-screening-conducted-by td,
        table#rechecked-by td,
        table#phsychological-screening-conducted-by td,
        table#nutritional-assessment-by td {
            border: none !important;
        }

        /* Override any conflicting border styles for sign-off tables */
        .black-bordered {
            border: 1px solid rgba(0, 0, 0, 0.12) !important;
            border-radius: 8px !important;
            -webkit-border-radius: 8px !important;
            -moz-border-radius: 8px !important;
        }

        /* Ensure black-bordered class works specifically for sign-off tables */
        table#health-screening-conducted-by.black-bordered,
        table#rechecked-by.black-bordered,
        table#phsychological-screening-conducted-by.black-bordered,
        table#nutritional-assessment-by.black-bordered {
            border: 1px solid rgba(0, 0, 0, 0.12) !important;
            border-collapse: separate !important;
        }

        table#health-screening-conducted-by td strong,
        table#rechecked-by td strong,
        table#phsychological-screening-conducted-by td strong,
        table#nutritional-assessment-by td strong {
            font-size: 16px;
        }

        #std-profile tr td:nth-child(2),
        #std-profile tr td:nth-child(4) {
            width: 45%;
            word-wrap: break-word;
        }

        #std-profile tr td:nth-child(1),
        #std-profile tr td:nth-child(3) {
            width: 15%;
            white-space: nowrap;
        }

        .bordered td {
            word-wrap: break-word;
            overflow-wrap: break-word;
            max-width: 200px;
        }

        .section-title {
            height: auto;
            min-height: 40px;
        }

        .section-title .heading {
            text-align: start;
            margin: 2px 0;
            padding: 0;
            font-size: 10px;
            white-space: normal;
            word-wrap: break-word;
            overflow-wrap: break-word;
        }

        .two-column-table tr {
            height: auto;
        }

        .two-column-table td {
            height: auto;
            min-height: 100px;
        }

    </style>
</head>

<body>

    <!-- Main content layout -->
    <table style="width: 100%; border-collapse: collapse;">
        <tr>
            <td style="width: 70%; vertical-align: top; padding-right: 10px;">

            <table>
                <tr>
                    <td>
                        <img src="https://cphs.biopharmainfo.net/admin/images/bicphs_logo_new.png" alt="Logo"
                            class="logo" />
                    </td>
                    <td>
                        <div class="main-heading">
                            <h2>COMPREHENSIVE STUDENT
                            HEALTH REPORT</h2>
                        </div>
                    </td>
                </tr>
            </table>

            <table class="bordered" id="std-profile">
                <tr class="section-title">
                    <td colspan="12">
                        <p class="heading center-heading">STUDENT PROFILE</p>
                    </td>
                </tr>
                <tr>
                    <td>Full Name:</td>
                    <td><?php echo e($details['Bio Data']['Name'] ?? '-'); ?></td>
                    <td>System ID:</td>
                    <td><?php echo e($details['Bio Data']['System ID'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>Guardian:</td>
                    <td>Shakoor Ahmed</td>
                    <td>Screening Date:</td>
                    <td><?php echo e($formattedDate); ?></td>
                </tr>
                <tr>
                    <td>Gender:</td>
                    <td><?php echo e($details['Bio Data']['Gender'] ?? '-'); ?></td>
                    <!-- <td>Contact:</td>
                    <td>0327-XXXXXXX</td> -->
                </tr>
                <tr>
                    <td>DOB:</td>
                    <td><?php echo e($details['Bio Data']['Date of Birth'] ?? '-'); ?></td>
                    <td>Contact Information:</td>
                    <!-- <td>ER Contact #: 0327-XXXXXXX</td> -->
                    <!-- <td>Address:</td>
                    <td>ABC Building & XYZ Road, Karachi</td> -->
                </tr>
                <tr>
                    <td>Age:</td>
                    <td><?php echo e($details['Bio Data']['Age'] ?? '-'); ?></td>
                    <td>ER Contact #: <?php echo e($details['Bio Data']['Emergency Contact'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>GR #:</td>
                    <td><?php echo e($details['Bio Data']['GR #'] ?? '-'); ?></td>
                    <td>Address:</td>
                    <td><?php echo e($details['Bio Data']['Address'] ?? '-'); ?></td>

                </tr>
                <tr>
                    <td>Class/Section:</td>
                    <td><?php echo e($details['Bio Data']['class'] ?? '-'); ?>/<?php echo e($details['Bio Data']['class_section'] ?? '-'); ?></td>
                    <td>Area / City:</td>
                    <td><?php echo e($details['Bio Data']['Area'] ?? '-'); ?> / <?php echo e($details['Bio Data']['City'] ?? '-'); ?></td>
                </tr>
            </table>

            <table class="two-column-table">
                <tr>
                    <td>
                        <table class="bordered" id="mdcl-history">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">MEDICAL HISTORY</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Any Known Med Condition: </td>
                                <td><?php echo e($details['Bio Data']['ANY KNOWN MEDICAL CONDITION'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Blood Group:</td>
                                <td><?php echo e($details['Bio Data']['Blood Group'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Known Allergy:</td>
                                <td><?php echo e($details['Miscellaneous']['ANY KNOWN ALLERGY'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Lead Exposure Risk:</td>
                                <td><?php echo e($details['development']['Question_No_48_Frequently_put_things_in_mouth'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Vaccination Status:</td>
                                <td>
                                    <?php
                                        $vaccination = $details['Vaccination'] ?? [];
                                        $vaccinated = (!empty($vaccination['BCG_1_dose'])
                                            || !empty($vaccination['OPV_4_dose'])
                                            || !empty($vaccination['Pentavalent_vaccine_DTP'])
                                            || !empty($vaccination['Rota'])
                                            || !empty($vaccination['Measles']));
                                    ?>
                                    <?php echo e($vaccinated ? 'Vaccinated' : 'Not Vaccinated'); ?>

                                </td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="bordered" id="vitals">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">VITALS</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Temperature: </td>
                                <td> <?php echo e($details['Vitals/BMI']['Temperature'] ?? '-'); ?> F </td>
                            </tr>
                            <tr>
                                <td>Systolic BP:</td>
                                <td><?php echo e($details['Vitals/BMI']['Systolic BP'] ?? '-'); ?> mmHg</td>
                            </tr>
                            <tr>
                                <td>Diastolic BP:</td>
                                <td> <?php echo e($details['Vitals/BMI']['Diastolic BP'] ?? '-'); ?> mHg</td>
                            </tr>
                            <tr>
                                <td>Pulse:</td>
                                <td> <?php echo e($details['Vitals/BMI']['Pulse'] ?? '-'); ?> bpm</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <table class="two-column-table">
                <tr>
                    <td>
                        <table class="bordered" id="anthropometry">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">ANTHROPOMETRY</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Height: </td>
                                <td> <?php echo e($details['Vitals/BMI']['Height'] ?? '-'); ?> cm </td>
                            </tr>
                            <tr>
                                <td>Weight:</td>
                                <td> <?php echo e($details['Vitals/BMI']['Weight'] ?? '-'); ?> kg</td>
                            </tr>
                            <tr>
                                <td>BMI:</td>
                                <td> <?php echo e($details['Vitals/BMI']['BMI'] ?? '-'); ?> kg/m2</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="bordered" id="dermatological-assessment">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">DERMATOLOGICAL ASSESSMENT</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Skin:</td>
                                <td><?php echo e($details['General Appearance']['Skin'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Hair/ Scalp:</td>
                                <td> <?php echo e($details['Head and Neck examination']['Hair/scalp'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Hair Problem:</td>
                                <td><?php echo e($details['Head and Neck examination']['Hair Problem'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Scalp:</td>
                                <td><?php echo e($details['Head and Neck examination']['Scalp'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Hair/ Distribution: </td>
                                <td><?php echo e($details['Head and Neck examination']['Hair/distribution'] ?? '-'); ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <table class="two-column-table">
                <tr>
                    <td>
                        <table class="bordered" id="dental-assessment">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">DENTAL ASSESSMENT</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Gums: </td>
                                <td><?php echo e($details['Dental Examination']['GUMS'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Dental Caries:</td>
                                <td><?php echo e($details['Dental Examination']['dental_caries'] ?? '-'); ?></td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="bordered" id="cardio-pulmonary">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">CARDIO PULMONARY & ABDOMEN</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Lung Auscultation:</td>
                                <td><?php echo e($details['Chest']['Lung_Auscultation'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Cardiac Auscultation:</td>
                                <td><?php echo e($details['Chest']['Cardiac_auscultation'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Abdomen</td>
                                <td><?php echo e($details['Abdomen']['ABDOMEN'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Abdominal Pain</td>
                                <td><?php echo e($details['Abdomen']['Abdominal_pain'] ?? '-'); ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <table class="two-column-table">
                <tr>
                    <td>
                        <table class="bordered" id="musculoskeletal-examination">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">MUSCULOSKELETAL EXAMINATION</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Any Limitation in Child Range of Motion: </td>
                                <td><?php echo e($details['Musculoskeletal']['Any_limitation_in_child_range_of_motion'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Adam Forward Bend Test:</td>
                                <td><?php echo e($details['Musculoskeletal']['Adams_forward_bend_test'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Any Foot or Toe Abnormalities:</td>
                                <td><?php echo e($details['Musculoskeletal']['Any_foot_or_toe_abnormalities'] ?? '-'); ?></td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="bordered" id="vision-hearing">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">VISION & HEARING ASSESSMENT</p>
                                </td>
                            </tr>
                            <tr>
                                <td>Visual Acuity:</td>
                                <td>Right Eye <?php echo e($details['Eye']['Visual_acuity_using_snellens_chart'] ?? '-'); ?></td>
                                <td>Left Eye <?php echo e($details['Eye']['Question_No_24B_Visual_acuity_using_Snellens_chart_left_eye'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Normal Ocular Alignment:</td>
                                <td><?php echo e($details['Eye']['Normal_ocular_alignment'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Normal Eye Inspection:</td>
                                <td><?php echo e($details['Eye']['Normal_eye_inspection'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Normal Color Vision:</td>
                                <td><?php echo e($details['Eye']['Normal_color_vision'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Nystagmus:</td>
                                <td><?php echo e($details['Eye']['Nystagmus'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Ear Examination:</td>
                                <td><?php echo e($details['Ears']['Ear_examination'] ?? '-'); ?></td>
                            </tr>
                            <tr>
                                <td>Hearing Test:</td>
                                <td><?php echo e(!empty($details['Ears']['Conclusion_of_hearing_test_with_rinne_and_weber']) ? str_replace('_', ' ', $details['Ears']['Conclusion_of_hearing_test_with_rinne_and_weber']) : '-'); ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <table class="bordered" id="general-health">
                <tr class="section-title">
                    <td colspan="12">
                        <p class="heading">GENERAL HEALTH & HYGIENE</p>
                    </td>
                </tr>
                <tr>
                    <td>Posture Gait:</td>
                    <td><?php echo e($details['General Appearance']['Normal Posture Gait'] ?? '-'); ?></td>
                    <td>Mental Status:</td>
                    <td><?php echo e($details['General Appearance']['Mental Status'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>Jaundice:</td>
                    <td><?php echo e($details['General Appearance']['JAUNDICE'] ?? '-'); ?></td>
                    <td>Anemia:</td>
                    <td><?php echo e($details['General Appearance']['ANEMIA'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>Clubbing:</td>
                    <td><?php echo e($details['General Appearance']['CLUBBING'] ?? '-'); ?></td>
                    <td>Cyanosis:</td>
                    <td><?php echo e($details['General Appearance']['CYANOSIS'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>Breath:</td>
                    <td><?php echo e($details['General Appearance']['Breath'] ?? '-'); ?></td>
                    <td>Nails:</td>
                    <td><?php echo e($details['Inspect Hygiene']['Nails'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>Lice Nits:</td>
                    <td><?php echo e($details['Inspect Hygiene']['lice/Nits'] ?? '-'); ?></td>
                    <td>Tonsils:</td>
                    <td><?php echo e($details['Throat']['tonsils'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>Any Neck Swelling:</td>
                    <td><?php echo e($details['Throat']['Any_neck_swelling'] ?? '-'); ?></td>
                    <td>Lymph Node:</td>
                    <td><?php echo e($details['Throat']['LYMPH NODE'] ?? '-'); ?></td>
                </tr>
                <tr>
                    <td>External Nasal Examination:</td>
                    <td><?php echo e($details['Nose']['External_nasal_examinaton'] ?? '-'); ?></td>
                    <td>Nasal Patency Test:</td>
                    <td><?php echo e($details['Nose']['nasal_patency_test'] ?? '-'); ?></td>
                </tr>
            </table>

            </td>
            <td class="right-wrapper">
            <table>
                <tr>
                    <td>
                        <img src="https://cphs.biopharmainfo.net/admin/images/bicphs_logo_new.png" alt="Logo"
                            class="logo" />
                    </td>
                    <td>
                        <div class="main-heading">
                            <h2>
                            PERSONALIZED
                            <br>
                            CLINICAL INSIGHT
                            </h2>
                        </div>
                    </td>
                </tr>
            </table>

            <table class="bordered" id="autism-screening">
                <tr class="section-title">
                    <td colspan="12">
                        <p class="heading">PSYCHOLOGICAL ASSESSMENT</p>
                    </td>
                </tr>
                <tr>
                    <td colspan="12">
                        <p>
                          <?php echo e($details['Psychological']['Psychologist_Comment'] ?? '-'); ?>

                        </p>
                    </td>
                </tr>
            </table>

            <table class="bordered" id="nutritional-assessment">
                <tr class="section-title">
                    <td colspan="12">
                        <p class="heading">NUTRITIONIST REVIEW</p>
                    </td>
                </tr>
                <tr>
                    <td colspan="12">
                      <p>
                          <?php echo e($details['Nutritionist']['Assessment'] ?? '-'); ?>

                      </p> 
                    </td>
                </tr>
            </table>

            <table class="bordered" id="physician-notes-1">
                <tr class="section-title">
                    <td colspan="12">
                        <p class="heading">PHYSICIAN NOTES</p>
                    </td>
                </tr>
                <tr>
                    <td colspan="12">
                        <p>
                           <?php echo e($details['DOCTOR COMMENT']['doctor_comment'] ?? '-'); ?> 
                        </p>
                    </td>
                </tr>
            </table>

            <table class="two-column-table">
                <tr>
                    <td>
                        <table class="black-bordered" id="health-screening-conducted-by">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">HEALTH SCREENING CONDUCTED BY</p>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Dr. Kiran Rafiq Dosani</strong></td>
                            </tr>
                            <tr>
                                <td>School Health Physician</td>
                            </tr>
                            <tr>
                                <td>MBBS, MRCP UK</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="black-bordered" id="rechecked-by">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">RECHECKED BY</p>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Dr. Syeda Nabira Abbas</strong></td>
                            </tr>
                            <tr>
                                <td>Clinical Operations Lead</td>
                            </tr>
                            <tr>
                                <td>MBBS (DOW), MCPS, PGD (IBA)</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <table class="two-column-table">
                <tr>
                    <td>
                        <table class="black-bordered" id="phsychological-screening-conducted-by">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">PSYCHOLOGICAL SCREENING REVIEWED BY </p>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Ms. Wajeeha Gul</strong></td>
                            </tr>
                            <tr>
                                <td>Clinical Psychologist</td>
                            </tr>
                            <tr>
                                <td>MPhil Clinical Psychology</td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table class="black-bordered" id="nutritional-assessment-by">
                            <tr class="section-title">
                                <td colspan="12">
                                    <p class="heading">NUTRITIONAL ASSESSMENT REVIEWED BY</p>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>Ms. Uroosha Jamal</strong></td>
                            </tr>
                            <tr>
                                <td>Clinical Nutritionist</td>
                            </tr>
                            <tr>
                                <td>Registered Dietitian/ Nutritionist</td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            

            </td>
        </tr>
    </table>

    <table style="width: 100%; border-collapse: collapse;">
        <tr>
            <td style="width: 50%;"></td>
            <td style="width: 50%; text-align: right;">
                <div class="gray small" style="text-align: right; padding-right: 0 !important;">
                    <strong>Please Note:</strong> This health screening report is based on information provided by your child at the time of screening and is not a substitute for a full medical examination. While efforts have been made to ensure accuracy, we recommend consulting a healthcare professional for any medical concerns. This report is for educational purposes and to support student well-being at school.
                </div>
            </td>
        </tr>
    </table>


</body>

</html>
<?php /**PATH C:\Users\AR\Desktop\cpshmerge\resources\views/admin/health-report-pdf-2.blade.php ENDPATH**/ ?>