<?php



namespace App\Http\Controllers;


use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use DB;
use Session;
use Str;
use Illuminate\Support\Facades\Auth;
use App\Models\CalendarEvents;
use App\Models\form_entry;
use App\Models\School;


class CalendarController extends Controller
{

    public function index(Request $request)
    {
        if ($request->isMethod('post')) {

            $dataArr = $request->all();

            // echo "<PRE>";
            // print_r($dataArr);
            // exit;

            $rules = array(
                'title' => 'required',
                'startDate' => 'required',
                // 'endDate' => 'required',
                'color' => 'required',


            );


            $this->validate($request, $rules);

            $title = (isset($dataArr['title']) && !empty($dataArr['title'])) ? trim($dataArr['title']) : null;
            $startDate = (isset($dataArr['startDate']) && !empty($dataArr['startDate'])) ? trim($dataArr['startDate']) : null;
            $endDate = (isset($dataArr['endDate']) && !empty($dataArr['endDate'])) ? trim($dataArr['endDate']) : null;
            $color = (isset($dataArr['color']) && !empty($dataArr['color'])) ? trim($dataArr['color']) : null;
            $UpdateID = (isset($dataArr['UpdateID']) && !empty($dataArr['UpdateID'])) ? trim($dataArr['UpdateID']) : 0;

            $CalendarEvents = new CalendarEvents();

            if ($UpdateID > 0) {
                $CalendarEvents = CalendarEvents::find($UpdateID);
            }
            $CalendarEvents->title = $title;
            $CalendarEvents->slug = Str::slug($title, '-');
            $CalendarEvents->startDate = $startDate;
            $CalendarEvents->endDate = $endDate;
            $CalendarEvents->color = $color;


            if ($UpdateID > 0) {
                $CalendarEvents->updated_by = Auth::user()->id;

            } else {
                $CalendarEvents->created_by = Auth::user()->id;

            }

            $CalendarEvents->save();



            if ($UpdateID > 0) {
                $CalendarEventsReturnID = $UpdateID;
                $message = "Event Updated Successfully";

            } else {
                $CalendarEventsReturnID = DB::getPdo()->lastInsertId();
                $message = "Event Create Successfully";

            }



            return response()->json(
                array(
                    'status' => true,
                    'message' => $message,
                    'CalendarEventsReturnID' => $CalendarEventsReturnID,
                )
            );
        }

        $CalendarEventsArr = array();
        $CalendarEvents = CalendarEvents::where('deleted', 0)->get()->toArray();
        if (!empty($CalendarEvents)) {
            foreach ($CalendarEvents as $CalendarEvent) {
                $CalendarEventsID = $CalendarEvent['id'];

                $title = $CalendarEvent['title'];
                $start = $CalendarEvent['startDate'];
                $end = $CalendarEvent['endDate'];
                $color = $CalendarEvent['color'];
                $description = $CalendarEvent['description'];
                $event_type = $CalendarEvent['event_type'];
                $redirect_link = $CalendarEvent['redirect_link'];
                $event_id = $CalendarEvent['event_id'];

                $custom_param1 = "N/A";
                /* Screening  = event_type 2 */
                if($event_type==2)
                {
                    $form_entry = form_entry::where('id', $event_id)->first();
                    if(!empty($form_entry))
                    {

                        $School = School::where('id',$form_entry['school'])->first();
                        if(!empty($School))
                        {
                            $custom_param1 = $School['school_name'];

                        }
                    }

                }

                $CalendarEventsArr[] = array(

                    'id' => $CalendarEventsID,
                    'title' => $title,
                    'start' => $start,
                    'end' => $end,
                    'color' => $color,
                    'description' => $description,
                    'event_type' => $event_type,
                    'event_id' => $event_id,
                    'redirect_link' => $redirect_link,
                    'extraParams' => array(
                        'custom_param1' => $custom_param1,  // Additional custom parameter 1
                        'custom_param2' => 'somethingelse'  // Additional custom parameter 2
                    )

                );
            }
        }

        // echo json_encode($CalendarEventsArr);exit;

        return view("Calendar.index")->with(compact('CalendarEvents', 'CalendarEventsArr'));
    }


    public function Delete(Request $request)
    {

        if ($request->isMethod('post')) {

            $dataArr = $request->all();

            //                echo "<PRE>";
            //    print_r($dataArr);
            //    exit;

            $returnAffected = CalendarEvents::where('id', $dataArr['id'])->update(array('deleted' => 1, 'updated_by' => Auth::user()->id));

            if ($returnAffected === 0) {
                $message = "Some Issue Occurs try later";
                return response()->json(
                    array(
                        'status' => false,
                        'message' => $message,
                    )
                );
            }

            $message = "Deleted successfully";

            return response()->json(
                array(
                    'status' => true,
                    'message' => $message,
                    'returnAffected' => $returnAffected,
                )
            );

        } else {
            $message = "Some Issue Occurs try later";
            return response()->json(
                array(
                    'status' => false,
                    'message' => $message,
                )
            );
        }
    }
}

