<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\form_entry;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\School;
use App\Models\StudentBiodata;
use App\Models\FormData;
use App\Models\SchoolHealthPhysician;
use App\Models\NutritionistHistoryEvaluationSection;
use App\Models\PsychologistHistoryAssessmentSection;
use App\Models\MedicalHistory;
use DataTables;

class AdminDashBoardController extends Controller
{
    //

    public function student_findings()
    {


        return view("admin.findings3");
    }


    public function getQuestionsData()
    {

        $questions = [

            /* General Apperance */


            ['key' => 'Question_No_8_Normal_Posture_Gait', 'label' => 'Posture/Gait', 'value' => 'no'],
            ['key' => 'Question_No_9_Mental_Status', 'label' => 'Mental Status', 'value' => 'Lethargic'],
            ['key' => 'Question_No_10_Look_For_jaundice', 'label' => 'Jaundice', 'value' => 'yes'],
            ['key' => 'Question_No_11_Look_For_anemia', 'label' => 'Anemia', 'value' => 'yes'],
            ['key' => 'Question_No_12_Look_For_Clubbing', 'label' => 'Clubbing', 'value' => 'yes'],
            ['key' => 'Question_No_13_Look_for_Cyanosis', 'label' => 'Cyanosis', 'value' => 'yes'],
            ['key' => 'Question_No_14_Skin', 'label' => 'Skin', 'value' => ['rash', 'allergy', 'lesion', 'bruises', 'Bad Breath']],
            ['key' => 'Question_No_15_Breath', 'label' => 'Breath', 'value' => 'Bad Breath'],

            /* Inspect Hygiene */

            ['key' => 'Question_No_16_Nails', 'label' => 'Nails', 'value' => 'dirty'],
            ['key' => 'Question_No_17_Uniform_or_shoes', 'label' => 'Uniform or Shoes', 'value' => 'untidy'],
            ['key' => 'Question_No_18_Lice/nits', 'label' => 'Lice/Nits', 'value' => 'yes'],
            ['key' => 'Question_No_19_Discuss_hygiene_routines_and_practices', 'label' => 'Hygiene Routines and Practices', 'value' => 'not-aware'],

            /* Head and Neck Examination */

            ['key' => 'Question_No_20_Hair_and_Scalp', 'label' => 'Hair and Scalp', 'value' => 'Color-faded'],
            ['key' => 'Question_No_21_Any_Hair_Problem', 'label' => 'Hair Problem', 'value' => ['Dry', 'Kinky', 'Brittle']],
            ['key' => 'Question_No_22_Scalp', 'label' => 'Scalp', 'value' => ['Dry', 'Scaly', 'Moist']],
            ['key' => 'Question_No_23_Hair_Distribution', 'label' => 'Hair Distribution', 'value' => ['Patchy', 'Receding', 'Receding_hair_line']],

            /* Eye Examination */

            ['key' => 'Question_No_25_Normal_ocular_alignment', 'label' => 'Ocular Alignment', 'value' => 'no'],
            ['key' => 'Question_No_26_Normal_eye_inspection', 'label' => 'Eye Inspection', 'value' => 'no'],
            ['key' => 'Question_No_28_Nystagmus', 'label' => 'Nystagmus', 'value' => 'yes'],

            /* Ears */

            ['key' => 'Question_No_29_Normal_ears_shape_and_position', 'label' => '  Ears Shape and Position', 'value' => 'no'],
            ['key' => 'Question_No_30_Ear_examination', 'label' => '  Ear Examination', 'value' => ['Ear wax', 'Canal Infection']],
            ['key' => 'Question_No_31_Conclusion_of_hearing_test_with_Rinner_and_Weber', 'label' => '  Conclusion of Hearing Test', 'value' => ['right_ear_conductive_hearing_loss', 'left_ear_conductive_hearing_loss', 'right_sensorineural_loss', 'left_sensorineural_loss']],


            /* Nose */

            ['key' => 'Question_No_32_External_nasal_examinaton', 'label' => '  External Nasal Examination', 'value' => ['deformities', 'swelling', 'redness', 'lesions', 'Nasal Discharge']],
            ['key' => 'Question_No_33_perform_a_nasal_patency_test_which_involves_gently_closing_one_nostril_at_a_time_to_assess_the_patients_ability_to_breathe_through_each_nostril', 'label' => '  Nasal Patency Test', 'value' => ['obstruction', 'dns']],

            /* Oral */

            ['key' => 'Question_No_34_Assess_gingiva', 'label' => ' Assess Gingiva', 'value' => ['Infection', 'bleed']],
            ['key' => 'Question_No_35_Are_there_dental_caries', 'label' => '  Are There Dental Caries', 'value' => 'yes'],

            /* Throat */

            ['key' => 'Question_No_36_Examine_tonsils', 'label' => '  Examine Tonsils', 'value' => 'tonsillitis'],
            ['key' => 'Question_No_37_Normal_Speech_development', 'label' => '  Speech Development', 'value' => 'no'],
            ['key' => 'Question_No_38_Any_Neck_swelling', 'label' => '  Neck Swelling', 'value' => 'yes'],
            ['key' => 'Question_No_39_Examine_lymph_node', 'label' => '  Examine Lymph Node', 'value' => 'abnormal'],

            /* Chest */

            ['key' => 'Question_No_40_Any_visible_chest_deformity', 'label' => '  Visible Chest Deformity', 'value' => 'yes'],
            ['key' => 'Question_No_41_Lung_Auscultation', 'label' => '  Lung Auscultation', 'value' => ['wheezing', 'crackles']],
            ['key' => 'Question_No_42_Cardiac_Auscultation', 'label' => '  Cardiac Auscultation', 'value' => 'murmur'],

            /* Abdomen */

            ['key' => 'Question_no_43_did_you_observe_any_distension_scars_or_masses_on_the_childs_abdomen', 'label' => '  Distension/Scars/Masses on Abdomen', 'value' => ['distension', 'scar', 'mass']],

            /* Musculoskeletal */

            ['key' => 'Question_No_45_Did_you_observe_any_limitations_in_the_child_s_range_of_joint_motion_during_your_examination', 'label' => ' Limitations in Joint Motion', 'value' => 'yes'],
            ['key' => 'Question_No_46_Spinal_curvature_assessment_tick_positive_finding', 'label' => ' Spinal Curvature Assessment', 'value' => ['uneven shoulder', 'shoulder blade', 'uneven waist', 'Hips']],
            ['key' => 'Question_No_47_side_to_side_curvature_in_the_spine_resembling', 'label' => '  Side-to-Side Curvature', 'value' => ['c_shape', 's_shape']],
            ['key' => 'Question_No_48_Adams_forward_bend_test', 'label' => '  Adams Forward Bend Test', 'value' => 'positive'],
            ['key' => 'Question_No_49_Any_foot_or_toe_abnormalities', 'label' => '  Foot or Toe Abnormalities', 'value' => ['flat feet', 'varus', 'valgus', 'high arch', 'hammer toe', 'bunion']],

            /*    Vaccination */

            ['key' => 'Question_No_50_Have_EPI_immunization_card', 'label' => '  EPI Immunization Card', 'value' => ['No','no']],

            /*   Miscellaneous  */

            ['key' => 'Question_No_55_Do_you_have_any_Allergies', 'label' => '   Allergies', 'value' => 'yes'],
            /* ['key' => 'Question_No_56_Girls_above_8_years_old_ask:?', 'label' => '  Girls Above 8 Years Old Ask?', 'value' => 'no'], */
            ['key' => 'Question_No_57_Inquire_about_urinary_frequency_urgency_and_any_pain_or_discomfort_during_urination', 'label' => ' Inquire About Urinary Frequency', 'value' => 'yes'],
          
            /* Psychological */
            
            // ['key' => 'Question_No_58_Note_any_discomfort_or_pain_in_the_abdominal_area?', 'label' => '   Discomfort or Pain in the Abdominal Area', 'value' => 'yes'],
            // ['key' => 'Question_No_59_Looking_for_clinical_signs_of_dehydration?', 'label' => '  Clinical Signs of Dehydration', 'value' => 'yes'],
            // ['key' => 'Question_No_60_Swelling_in_the_extremities?', 'label' => '  Swelling in the Extremities', 'value' => 'yes'],

            /* ['key' => 'observation1', 'label' => 'Observation 1', 'value' => [3, 4]],
             ['key' => 'observation2', 'label' => 'Observation 2', 'value' => [3, 4]],
             ['key' => 'observation3', 'label' => 'Observation 3', 'value' => [3, 4]],
             ['key' => 'observation4', 'label' => 'Observation 4', 'value' => [3, 4]],
             ['key' => 'observation5', 'label' => 'Observation 5', 'value' => [3, 4]],
             ['key' => 'observation6', 'label' => 'Observation 6', 'value' => [3, 4]],
             ['key' => 'observation7', 'label' => 'Observation 7', 'value' => [3, 4]],
             ['key' => 'observation8', 'label' => 'Observation 8', 'value' => [3, 4]],
             ['key' => 'observation9', 'label' => 'Observation 9', 'value' => [3, 4]],
             ['key' => 'observation10', 'label' => 'Observation 10', 'value' => [3, 4]],*/

            // ['key' => 'bmi61', 'label' => 'BMI', 'value' => null],
            // ['key' => 'muac', 'label' => 'MUAC', 'value' => null],
            // ['key' => 'Daily_Protien_requirement', 'label' => 'Daily Protein Requirement', 'value' => null],
            // ['key' => 'Daily_energy_requirement', 'label' => 'Daily Energy Requirement', 'value' => null],
            // ['key' => 'meals', 'label' => 'Meals', 'value' => null],
            // ['key' => 'food_items', 'label' => 'Food Items', 'value' => null],
        ];

        $data = [];
        $schoolid= json_decode(auth()->guard('admin')->user()?->school_id);
// dd($schoolid[0]);
        $count1 = 1;
        foreach ($questions as $key => $question) {


            /*$FormData1 = FormData::where('key', $question['key'])->get()->toArray();
            if(!empty($FormData1))
            {
                foreach($FormData1 as $key2=>$value2)
                {

                     $findings = form_entry::where("id", $value2['entry_id'])->count();
                     if(!empty($findings) && $findings > 0)
                     {

                     }

                }
            }*/


            // $query = FormData::where('key', $question['key']);


            $query = FormData::join('form_entries', 'form_data.entry_id', '=', 'form_entries.id')
                ->where('form_data.key', $question['key'])
                ->whereIn('form_entries.school', $schoolid);


            if (is_array($question['value'])) {
                $count = $query->whereIn('value', $question['value'])->count();
            } elseif ($question['value'] !== null) {
                $count = $query->where('value', $question['value'])->count();
            } elseif ($question['value'] == null) {
                $count = $query->where('value', $question['value'])->count();
            } else {
                $count = $query->count();
            }



            $data[] = [
                'id' => count($data),
                'entryId' => $count1,
                'question' => $question['key'],
                'label' => $question['label'],
                'question_key' => $question['value'],
                'count' => $count,
            ];

            $count1++;
        }
// dd($data['entryId']);
        return DataTables::of($data)->make(true);
    }

    public function getQuestionData(Request $request)
    {
        $question = $request->input('question');
        $question_key = $request->input("question_key");

        // dd($request->input("entry_id"));

        if ($question_key !== null) {
            $question_key = explode(",", $question_key);

        }


        $entryIds = FormData::where('key', $question);

        if (is_array($question_key)) {
            // echo "HERE 1"; exit;
            // dd($question_key);

            $entryIds = $entryIds->whereIn('value', $question_key);


        } elseif ($question_key == null) {
            // echo "HERE 2"; exit;

            $entryIds = $entryIds->where('value', $question_key);



        } else {
            // echo "HERE 3"; exit;

            $entryIds = $entryIds->where('value', $question_key);

        }



        $entryIds = $entryIds->pluck('entry_id');
        // dd($entryIds);

        if ($entryIds->isEmpty()) {
            return DataTables::of([])->make(true);
        }
        $schoolid= json_decode(auth()->guard('admin')->user()?->school_id);
        $findings = form_entry::whereIn("school", $schoolid)->whereIn("id", $entryIds)->get()->toArray();


        return DataTables::of($findings)->make(true);
    }


    public function dashboard1()
    {

        return view('admin.dashboard1');

    }
    public function schoolDashboard()
    {

        return view('admin.schoolDashboard');

    }
    public function mainDashboard()
    {

        return view('admin.mainDashboard');

    }


    /* schoolDashboard2 */

    public function schoolDashboard2()
    {

        return view('admin.schoolDashboard2');

    }


    /* schoolDashboard1 */

    public function schoolDashboard1()
    {

        return view('admin.schoolDashboard1');

    }
    public function index()
    {



        $enter_by = Auth::guard('admin')->user()->id;
        $role = Auth::guard('admin')->user()->role;
        if ($role == '1') {

            $data['total_users'] = User::all()->count();
            $data['total_entries'] = form_entry::all()->count();
            $data['schoolsCount'] = form_entry::select('schools.id', 'schools.school_name', DB::raw('COUNT(form_entries.id) as entry_count'))
                ->join('schools', 'schools.id', '=', 'form_entries.school')
                ->groupBy('schools.id')
                ->get();
            // dd($schools);


            $data['SchoolHealthPhysician'] = SchoolHealthPhysician::where('deleted', 0)->where('Follow_up_Required', 'yes')->count();
            $data['NutritionistHistoryEvaluationSection'] = NutritionistHistoryEvaluationSection::where('deleted', 0)->where('Follow_up_Required1', 'yes')->count();
            $data['PsychologistHistoryAssessmentSection'] = PsychologistHistoryAssessmentSection::where('deleted', 0)->where('Follow_up_Required2', 'yes')->count();

            return view('admin.dashboard2');

            /*return view('admin.dashboard1');*/


            /*return view('admin.index', compact('data'));*/

        } else if ($role == 3) {


            return view('admin.schoolDashboard2');


        } else {
            $data1['total_entries1'] = form_entry::where('enterby', $enter_by)->count();
            return view('admin.indexdoctor', $data1);
        }

    }
}
